/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.database;

import com.redhat.victims.VictimsConfig;
import com.redhat.victims.VictimsException;
import com.redhat.victims.VictimsRecord;
import com.redhat.victims.VictimsResultCache;
import com.redhat.victims.VictimsService;
import com.redhat.victims.database.VictimsDBInterface;
import com.redhat.victims.database.VictimsSQL;
import com.redhat.victims.fingerprint.Algorithms;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class VictimsSqlDB
extends VictimsSQL
implements VictimsDBInterface {
    protected static final String UPDATE_FILE_NAME = "lastUpdate";
    protected File lastUpdate = FileUtils.getFile((File)VictimsConfig.home(), (String[])new String[]{"lastUpdate"});
    protected VictimsResultCache cache = new VictimsResultCache();

    protected int remove(Connection connection, VictimsService.RecordStream recordStream) throws SQLException, IOException {
        int count = 0;
        PreparedStatement ps = this.statement(connection, "DELETE FROM records WHERE hash = ?");
        while (recordStream.hasNext()) {
            VictimsRecord vr = recordStream.getNext();
            this.setObjects(ps, vr.hash);
            ps.addBatch();
            ++count;
        }
        this.executeBatchAndClose(ps);
        return count;
    }

    protected int update(Connection connection, VictimsService.RecordStream recordStream) throws SQLException, IOException {
        int count = 0;
        PreparedStatement insertFileHash = this.statement(connection, "INSERT INTO filehashes (record, filehash) VALUES (?, ?)");
        PreparedStatement insertMeta = this.statement(connection, "INSERT INTO meta (record, prop, value) VALUES (?, ?, ?)");
        PreparedStatement insertCVE = this.statement(connection, "INSERT INTO cves (record, cve) VALUES (?, ?)");
        while (recordStream.hasNext()) {
            VictimsRecord vr = recordStream.getNext();
            String hash = vr.hash.trim();
            this.deleteRecord(connection, hash);
            int id = this.insertRecord(connection, hash);
            for (String filehash : vr.getHashes(Algorithms.SHA512).keySet()) {
                this.setObjects(insertFileHash, id, filehash.trim());
                insertFileHash.addBatch();
            }
            HashMap<String, String> md = vr.getFlattenedMetaData();
            for (String key : md.keySet()) {
                this.setObjects(insertMeta, id, key, md.get(key));
                insertMeta.addBatch();
            }
            for (String cve : vr.cves) {
                this.setObjects(insertCVE, id, cve.trim());
                insertCVE.addBatch();
            }
            ++count;
        }
        this.executeBatchAndClose(insertFileHash, insertMeta, insertCVE);
        return count;
    }

    protected void setLastUpdate(Date date) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String stamp = sdf.format(date);
        FileUtils.write((File)this.lastUpdate, (CharSequence)stamp);
    }

    @Override
    public Date lastUpdated() throws VictimsException {
        Exception throwable = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date since = sdf.parse("1970-01-01T00:00:00");
            if (VictimsConfig.forcedUpdate()) {
                return since;
            }
            try {
                if (this.lastUpdate.exists()) {
                    String temp = FileUtils.readFileToString((File)this.lastUpdate).trim();
                    since = sdf.parse(temp);
                }
            }
            catch (IOException e) {
                throwable = e;
            }
            return since;
        }
        catch (ParseException e) {
            throwable = e;
            throw new VictimsException("Failed to retreive last updated data", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize() throws VictimsException {
        Exception throwable = null;
        try {
            Connection connection = this.getConnection();
            connection.setAutoCommit(false);
            Savepoint savepoint = connection.setSavepoint();
            try {
                VictimsService service = new VictimsService();
                Date since = this.lastUpdated();
                int removed = this.remove(connection, service.removed(since));
                int updated = this.update(connection, service.updates(since));
                if (removed > 0 || updated > 0) {
                    this.cache.purge();
                }
                this.setLastUpdate(new Date());
            }
            catch (IOException e) {
                throwable = e;
            }
            catch (SQLException e) {
                throwable = e;
            }
            finally {
                if (throwable != null) {
                    connection.rollback(savepoint);
                }
                connection.releaseSavepoint(savepoint);
                connection.commit();
                connection.close();
            }
        }
        catch (SQLException e) {
            throwable = e;
        }
        if (throwable != null) {
            throw new VictimsException("Failed to sync database", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashSet<String> getVulnerabilities(int recordId) throws SQLException {
        HashSet<String> cves = new HashSet<String>();
        Connection connection = this.getConnection();
        try {
            PreparedStatement ps = this.setObjects(connection, "SELECT cve FROM cves WHERE record = ?", recordId);
            ResultSet matches = ps.executeQuery();
            while (matches.next()) {
                cves.add(matches.getString(1));
            }
            matches.close();
        }
        finally {
            connection.close();
        }
        return cves;
    }

    @Override
    public HashSet<String> getVulnerabilities(String sha512) throws VictimsException {
        try {
            if (this.cache.exists(sha512)) {
                return this.cache.get(sha512);
            }
            int id = this.selectRecordId(sha512);
            return this.getVulnerabilities(id);
        }
        catch (Throwable e) {
            throw new VictimsException("Failed to get vulnerabilities for " + sha512, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<String> getVulnerabilities(HashMap<String, String> props) throws VictimsException {
        try {
            HashSet<String> cves = new HashSet<String>();
            int requiredMinCount = props.size();
            HashMap<Integer, MutableInteger> matchedPropCount = new HashMap<Integer, MutableInteger>();
            Connection connection = this.getConnection();
            try {
                for (String key : props.keySet()) {
                    String value = props.get(key);
                    PreparedStatement ps = this.setObjects(connection, "SELECT record FROM meta WHERE prop = ? AND value = ?", key, value);
                    ResultSet rs = ps.executeQuery();
                    while (rs.next()) {
                        Integer id = rs.getInt("record");
                        if (!matchedPropCount.containsKey(id)) {
                            matchedPropCount.put(id, new MutableInteger());
                            continue;
                        }
                        MutableInteger count = (MutableInteger)matchedPropCount.get(id);
                        count.increment();
                        if (count.get() != requiredMinCount) continue;
                        cves.addAll(this.getVulnerabilities(id));
                    }
                    rs.close();
                    ps.close();
                }
            }
            finally {
                connection.close();
            }
            return cves;
        }
        catch (SQLException e) {
            throw new VictimsException("Failed to search on properties", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashSet<Integer> getEmbeddedRecords(Set<String> hashes) throws SQLException {
        Connection connection = this.getConnection();
        Statement stmt = connection.createStatement();
        HashSet<Integer> ignore = new HashSet<Integer>();
        HashSet<Integer> candidates = new HashSet<Integer>();
        try {
            ResultSet resultSet = stmt.executeQuery("SELECT record, filehash FROM filehashes");
            while (resultSet.next()) {
                Integer id = resultSet.getInt("record");
                if (ignore.contains(id)) continue;
                String filehash = resultSet.getString("filehash");
                if (hashes.contains(filehash)) {
                    candidates.add(id);
                    continue;
                }
                candidates.remove(id);
                ignore.add(id);
            }
            resultSet.close();
        }
        finally {
            stmt.close();
            connection.close();
        }
        return candidates;
    }

    protected HashSet<String> getEmbeddedVulnerabilities(VictimsRecord vr) throws SQLException {
        HashSet<String> cves = new HashSet<String>();
        Set<String> hashes = vr.getHashes(Algorithms.SHA512).keySet();
        if (hashes.size() <= 0) {
            return cves;
        }
        for (Integer id : this.getEmbeddedRecords(hashes)) {
            cves.addAll(this.getVulnerabilities(id));
        }
        return cves;
    }

    @Override
    public HashSet<String> getVulnerabilities(VictimsRecord vr) throws VictimsException {
        try {
            if (this.cache.exists(vr.hash)) {
                return this.cache.get(vr.hash);
            }
            HashSet<String> cves = new HashSet<String>();
            cves.addAll(this.getVulnerabilities(vr.hash.trim()));
            cves.addAll(this.getEmbeddedVulnerabilities(vr));
            this.cache.add(vr.hash, cves);
            return cves;
        }
        catch (Throwable e) {
            throw new VictimsException("Could not determine vulnerabilities for hash: " + vr.hash, e);
        }
    }

    @Override
    public int getRecordCount() throws VictimsException {
        int count = 0;
        Connection connection = null;
        Statement stmt = null;
        try {
            connection = this.getConnection();
            stmt = connection.createStatement();
            ResultSet resultSet = stmt.executeQuery("SELECT COUNT(*) from records");
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            throw new VictimsException("Could not query database size", e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {}
        }
        return count;
    }

    protected static class MutableInteger {
        int value = 1;

        protected MutableInteger() {
        }

        public void increment() {
            ++this.value;
        }

        public int get() {
            return this.value;
        }
    }
}

