/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.victims.fingerprint;

import com.redhat.victims.fingerprint.Fingerprint;
import com.redhat.victims.fingerprint.Key;
import com.redhat.victims.fingerprint.Metadata;
import java.util.ArrayList;
import java.util.HashMap;

public class Artifact
extends HashMap<Key, Object> {
    protected static final ArrayList<Class<?>> PERMITTED_VALUE_TYPES = new ArrayList();

    @Override
    public Object put(Key key, Object value) throws IllegalArgumentException {
        if (!PERMITTED_VALUE_TYPES.contains(value.getClass())) {
            throw new IllegalArgumentException(String.format("Values of class type <%s> are not permitted in <%s>", value.getClass().getName(), this.getClass().getName()));
        }
        return super.put(key, value);
    }

    private String getString(Key key) {
        Object value = this.get((Object)key);
        if (value != null) {
            return (String)value;
        }
        return null;
    }

    public String filename() {
        return this.getString(Key.FILENAME);
    }

    public String filetype() {
        return this.getString(Key.FILETYPE);
    }

    public ArrayList<Artifact> contents() {
        Object value = this.get((Object)Key.CONTENT);
        if (value != null) {
            return (ArrayList)value;
        }
        return null;
    }

    public ArrayList<Artifact> embedded() {
        Object value = this.get((Object)Key.EMBEDDED);
        if (value != null) {
            return (ArrayList)value;
        }
        return null;
    }

    public HashMap<String, Metadata> metadata() {
        Object value = this.get((Object)Key.METADATA);
        if (value != null) {
            return (HashMap)value;
        }
        return null;
    }

    public Fingerprint fingerprint() {
        Object value = this.get((Object)Key.FINGERPRINT);
        if (value != null) {
            return (Fingerprint)value;
        }
        return null;
    }

    static {
        PERMITTED_VALUE_TYPES.add(Artifact.class);
        PERMITTED_VALUE_TYPES.add(String.class);
        PERMITTED_VALUE_TYPES.add(ArrayList.class);
        PERMITTED_VALUE_TYPES.add(Fingerprint.class);
        PERMITTED_VALUE_TYPES.add(Metadata.class);
        PERMITTED_VALUE_TYPES.add(HashMap.class);
    }
}

