/*
 * Decompiled with CFR 0.152.
 */
package com.sanhert.security;

import com.sanhert.security.util.SignUtils;
import java.util.Map;

public class Signature {
    private String charset = "UTF-8";
    private String privateKey;
    private String otherPublicKey;

    public Signature(String privateKey) {
        this.privateKey = privateKey;
        this.otherPublicKey = "";
    }

    public Signature(String privateKey, String otherPublicKey) {
        this.privateKey = privateKey;
        this.otherPublicKey = otherPublicKey;
    }

    public String sign(String content) {
        return SignUtils.sign(content, this.privateKey, this.charset);
    }

    public String sign(Map<String, String> params) {
        return SignUtils.sign(params, this.privateKey, this.charset);
    }

    public boolean check(String content, String sign, String publicKey) {
        return SignUtils.check(content, sign, publicKey, this.charset);
    }

    public boolean check(String content, String sign) {
        return SignUtils.check(content, sign, this.otherPublicKey, this.charset);
    }

    public boolean check(Map<String, String> params, String publicKey) {
        return SignUtils.check(params, publicKey, this.charset);
    }

    public boolean check(Map<String, String> params) {
        return SignUtils.check(params, this.otherPublicKey, this.charset);
    }

    public boolean checkParameterMap(Map<String, String[]> parameterMap, String publicKey) {
        return SignUtils.checkParameterMap(parameterMap, publicKey, this.charset);
    }

    public boolean checkParameterMap(Map<String, String[]> parameterMap) {
        return SignUtils.checkParameterMap(parameterMap, this.otherPublicKey, this.charset);
    }

    public boolean checkJson(String json, String publicKey) {
        return SignUtils.checkJson(json, publicKey, this.charset);
    }

    public boolean checkJson(String json) {
        return SignUtils.checkJson(json, this.otherPublicKey, this.charset);
    }
}

