/*
 * Decompiled with CFR 0.152.
 */
package com.sanhert.security.util;

import com.sanhert.security.util.Base64Utils;
import com.sanhert.security.util.StreamUtils;
import com.sanhert.security.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SignUtils {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String SIGN_TYPE_RSA = "RSA";
    private static final String SIGN_SHA256RSA_ALGORITHMS = "SHA256WithRSA";

    public static String sign(String content, String privateKey, String charset) {
        try {
            PrivateKey priKey = SignUtils.getPrivateKeyFromPKCS8(SIGN_TYPE_RSA, new ByteArrayInputStream(privateKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
            signature.initSign(priKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] signed = signature.sign();
            return Base64Utils.encode(signed);
        }
        catch (Exception e) {
            throw new RuntimeException("\u7b7e\u540d\u5931\u8d25\uff1aRSAcontent = " + content + "; charset = " + charset, e);
        }
    }

    public static String sign(String content, String privateKey) {
        return SignUtils.sign(content, privateKey, CHARSET_UTF8);
    }

    public static String sign(Map<String, String> params, String privateKey, String charset) {
        String signContent = SignUtils.getSignContent(params);
        return SignUtils.sign(signContent, privateKey, charset);
    }

    public static String sign(Map<String, String> params, String privateKey) {
        return SignUtils.sign(params, privateKey, CHARSET_UTF8);
    }

    public static boolean check(String content, String sign, String publicKey, String charset) {
        try {
            PublicKey pubKey = SignUtils.getPublicKeyFromX509(SIGN_TYPE_RSA, new ByteArrayInputStream(publicKey.getBytes()));
            Signature signature = Signature.getInstance(SIGN_SHA256RSA_ALGORITHMS);
            signature.initVerify(pubKey);
            if (StringUtils.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            return signature.verify(Base64Utils.decode(sign));
        }
        catch (Exception e) {
            throw new RuntimeException("\u9a8c\u8bc1\u5931\u8d25\uff1aRSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, e);
        }
    }

    public static boolean check(Map<String, String> params, String publicKey, String charset) {
        String sign = params.get("sign");
        String content = SignUtils.getSignCheckContent(params);
        return SignUtils.check(content, sign, publicKey, charset);
    }

    public static boolean check(Map<String, String> params, String publicKey) {
        return SignUtils.check(params, publicKey, CHARSET_UTF8);
    }

    public static boolean check(String content, String sign, String publicKey) {
        return SignUtils.check(content, sign, publicKey, CHARSET_UTF8);
    }

    public static boolean checkParameterMap(Map<String, String[]> parameterMap, String publicKey, String charset) {
        Map<String, String> params = SignUtils.getMap(parameterMap);
        String sign = params.get("sign");
        String content = SignUtils.getSignCheckContent(params);
        return SignUtils.check(content, sign, publicKey, charset);
    }

    public static boolean checkParameterMap(Map<String, String[]> parameterMap, String publicKey) {
        return SignUtils.checkParameterMap(parameterMap, publicKey, CHARSET_UTF8);
    }

    public static boolean checkJson(String json, String publicKey, String charset) {
        String sign = SignUtils.getSignFromJson(json);
        String content = SignUtils.getContentFromJson(json);
        return SignUtils.check(content, sign, publicKey, charset);
    }

    public static boolean checkJson(String json, String publicKey) {
        return SignUtils.checkJson(json, publicKey, CHARSET_UTF8);
    }

    public static String getContentFromJson(String json) {
        int responseBeginIndex = json.indexOf("\"response\":");
        responseBeginIndex += 11;
        if (json.contains(",\"sign\"")) {
            int responseEndIndex = json.indexOf(",\"sign\"");
            return json.substring(responseBeginIndex, responseEndIndex);
        }
        return json.substring(responseBeginIndex, json.length() - 1);
    }

    public static String getSignFromJson(String json) {
        int signBeginIndex = json.indexOf("\"sign\":\"");
        String sign = json.substring(signBeginIndex += 8);
        int signEndIndex = sign.indexOf("\"");
        return sign.substring(0, signEndIndex);
    }

    private static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = Base64Utils.decode(StreamUtils.readText(ins));
            return encodedKey != null ? keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey)) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("algorithm = " + algorithm, e);
        }
    }

    private static PrivateKey getPrivateKeyFromPKCS8(String algorithm, InputStream ins) {
        try {
            if (ins == null || StringUtils.isEmpty(algorithm)) {
                return null;
            }
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            byte[] encodedKey = Base64Utils.decode(StreamUtils.readText(ins));
            return encodedKey != null ? keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encodedKey)) : null;
        }
        catch (Exception e) {
            throw new RuntimeException("algorithm = " + algorithm, e);
        }
    }

    private static String getSignCheckContent(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        params.remove("sign");
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            content.append(i == 0 ? "" : "&");
            content.append(key);
            content.append("=");
            content.append(value);
        }
        return content.toString();
    }

    private static Map<String, String> getMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : parameterMap.keySet()) {
            map.put(key, parameterMap.get(key)[0]);
        }
        return map;
    }

    private static String getSignContent(Map<String, String> sortedParams) {
        StringBuffer content = new StringBuffer();
        ArrayList<String> keys = new ArrayList<String>(sortedParams.keySet());
        Collections.sort(keys);
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String value;
            String key = (String)keys.get(i);
            if (!StringUtils.areNotEmpty(key, value = sortedParams.get(key))) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }
}

