/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering;

import com.spotify.docker.client.shaded.javax.inject.Inject;
import com.spotify.docker.client.shaded.javax.inject.Singleton;
import com.spotify.docker.client.shaded.javax.ws.rs.ConstrainedTo;
import com.spotify.docker.client.shaded.javax.ws.rs.RuntimeType;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Configuration;
import com.spotify.docker.client.shaded.javax.ws.rs.core.Context;
import com.spotify.docker.client.shaded.javax.ws.rs.core.SecurityContext;
import com.spotify.docker.client.shaded.org.glassfish.hk2.api.ServiceLocator;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.SecurityHelper;
import com.spotify.docker.client.shaded.org.glassfish.jersey.message.filtering.ServerScopeProvider;
import java.lang.annotation.Annotation;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.Sets;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, ServiceLocator serviceLocator) {
        super(config, serviceLocator);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = Sets.newHashSet();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

