/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownServiceException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.Connection;
import okhttp3.ConnectionSpec;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectionSpecSelector;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealConnection$WhenMappings;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.Transmitter;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.StreamResetException;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.tls.CertificateChainCleaner;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.internal.ws.RealWebSocket;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 r2\u00020\u00012\u00020\u0002:\u0001rB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u00105\u001a\u000206J>\u00107\u001a\u0002062\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@J(\u0010A\u001a\u0002062\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010B\u001a\u0002062\u0006\u0010C\u001a\u00020DH\u0002J0\u0010E\u001a\u0002062\u0006\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J*\u0010F\u001a\u0004\u0018\u00010G2\u0006\u00109\u001a\u00020\t2\u0006\u0010:\u001a\u00020\t2\u0006\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020JH\u0002J\b\u0010K\u001a\u00020GH\u0002J(\u0010L\u001a\u0002062\u0006\u0010C\u001a\u00020D2\u0006\u0010;\u001a\u00020\t2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J%\u0010M\u001a\u00020\u00172\u0006\u0010N\u001a\u00020O2\u000e\u0010P\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010QH\u0000\u00a2\u0006\u0002\bRJ\u000e\u0010S\u001a\u00020\u00172\u0006\u0010T\u001a\u00020\u0017J\u001d\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u0015\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0000\u00a2\u0006\u0002\b`J\u0006\u0010\u0019\u001a\u000206J\u0018\u0010a\u001a\u0002062\u0006\u0010b\u001a\u00020\u000f2\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u0002062\u0006\u0010f\u001a\u00020gH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010h\u001a\u00020\u00172\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00060QH\u0002J\b\u0010)\u001a\u00020 H\u0016J\u0010\u0010j\u001a\u0002062\u0006\u0010;\u001a\u00020\tH\u0002J\u000e\u0010k\u001a\u00020\u00172\u0006\u0010I\u001a\u00020JJ\b\u0010l\u001a\u00020mH\u0016J\u0017\u0010n\u001a\u0002062\b\u0010o\u001a\u0004\u0018\u00010pH\u0000\u00a2\u0006\u0002\bqR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0018\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010*\u001a\u0004\u0018\u00010+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010$\"\u0004\b.\u0010&R\u001d\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002020100\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006s"}, d2={"Lokhttp3/internal/connection/RealConnection;", "Lokhttp3/internal/http2/Http2Connection$Listener;", "Lokhttp3/Connection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "route", "Lokhttp3/Route;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Route;)V", "allocationLimit", "", "getConnectionPool", "()Lokhttp3/internal/connection/RealConnectionPool;", "handshake", "Lokhttp3/Handshake;", "http2Connection", "Lokhttp3/internal/http2/Http2Connection;", "idleAtNanos", "", "getIdleAtNanos$okhttp", "()J", "setIdleAtNanos$okhttp", "(J)V", "isMultiplexed", "", "()Z", "noNewExchanges", "getNoNewExchanges", "setNoNewExchanges", "(Z)V", "protocol", "Lokhttp3/Protocol;", "rawSocket", "Ljava/net/Socket;", "refusedStreamCount", "routeFailureCount", "getRouteFailureCount$okhttp", "()I", "setRouteFailureCount$okhttp", "(I)V", "sink", "Lokio/BufferedSink;", "socket", "source", "Lokio/BufferedSource;", "successCount", "getSuccessCount$okhttp", "setSuccessCount$okhttp", "transmitters", "", "Ljava/lang/ref/Reference;", "Lokhttp3/internal/connection/Transmitter;", "getTransmitters", "()Ljava/util/List;", "cancel", "", "connect", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "call", "Lokhttp3/Call;", "eventListener", "Lokhttp3/EventListener;", "connectSocket", "connectTls", "connectionSpecSelector", "Lokhttp3/internal/connection/ConnectionSpecSelector;", "connectTunnel", "createTunnel", "Lokhttp3/Request;", "tunnelRequest", "url", "Lokhttp3/HttpUrl;", "createTunnelRequest", "establishProtocol", "isEligible", "address", "Lokhttp3/Address;", "routes", "", "isEligible$okhttp", "isHealthy", "doExtensiveChecks", "newCodec", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/Interceptor$Chain;", "newCodec$okhttp", "newWebSocketStreams", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "exchange", "Lokhttp3/internal/connection/Exchange;", "newWebSocketStreams$okhttp", "onSettings", "connection", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "routeMatchesAny", "candidates", "startHttp2", "supportsUrl", "toString", "", "trackFailure", "e", "Ljava/io/IOException;", "trackFailure$okhttp", "Companion", "okhttp"})
public final class RealConnection
extends Http2Connection.Listener
implements Connection {
    private Socket rawSocket;
    private Socket socket;
    private Handshake handshake;
    private Protocol protocol;
    private Http2Connection http2Connection;
    private BufferedSource source;
    private BufferedSink sink;
    private boolean noNewExchanges;
    private int routeFailureCount;
    private int successCount;
    private int refusedStreamCount;
    private int allocationLimit;
    @NotNull
    private final List<Reference<Transmitter>> transmitters;
    private long idleAtNanos;
    @NotNull
    private final RealConnectionPool connectionPool;
    private final Route route;
    private static final String NPE_THROW_WITH_NULL = "throw with null exception";
    private static final int MAX_TUNNEL_ATTEMPTS = 21;
    public static final Companion Companion = new Companion(null);

    public final boolean getNoNewExchanges() {
        return this.noNewExchanges;
    }

    public final void setNoNewExchanges(boolean bl) {
        this.noNewExchanges = bl;
    }

    public final int getRouteFailureCount$okhttp() {
        return this.routeFailureCount;
    }

    public final void setRouteFailureCount$okhttp(int n) {
        this.routeFailureCount = n;
    }

    public final int getSuccessCount$okhttp() {
        return this.successCount;
    }

    public final void setSuccessCount$okhttp(int n) {
        this.successCount = n;
    }

    @NotNull
    public final List<Reference<Transmitter>> getTransmitters() {
        return this.transmitters;
    }

    public final long getIdleAtNanos$okhttp() {
        return this.idleAtNanos;
    }

    public final void setIdleAtNanos$okhttp(long l) {
        this.idleAtNanos = l;
    }

    public final boolean isMultiplexed() {
        return this.http2Connection != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void noNewExchanges() {
        RealConnectionPool $this$assertThreadDoesntHoldLock$iv = this.connectionPool;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
        }
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            this.noNewExchanges = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void connect(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, @NotNull Call call, @NotNull EventListener eventListener) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)eventListener, (String)"eventListener");
        boolean bl = this.protocol == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "already connected";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        RouteException routeException = null;
        List<ConnectionSpec> connectionSpecs = this.route.address().connectionSpecs();
        ConnectionSpecSelector connectionSpecSelector = new ConnectionSpecSelector(connectionSpecs);
        if (this.route.address().sslSocketFactory() == null) {
            if (!connectionSpecs.contains(ConnectionSpec.CLEARTEXT)) {
                throw (Throwable)new RouteException(new UnknownServiceException("CLEARTEXT communication not enabled for client"));
            }
            String host = this.route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted(host)) {
                throw (Throwable)new RouteException(new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy"));
            }
        } else if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw (Throwable)new RouteException(new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS"));
        }
        while (true) {
            try {
                if (this.route.requiresTunnel()) {
                    this.connectTunnel(connectTimeout, readTimeout, writeTimeout, call, eventListener);
                    if (this.rawSocket == null) {
                        break;
                    }
                } else {
                    this.connectSocket(connectTimeout, readTimeout, call, eventListener);
                }
                this.establishProtocol(connectionSpecSelector, pingIntervalMillis, call, eventListener);
                eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), this.protocol);
            }
            catch (IOException e) {
                Socket socket = this.socket;
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                Socket socket2 = this.rawSocket;
                if (socket2 != null) {
                    Util.closeQuietly(socket2);
                }
                this.socket = null;
                this.rawSocket = null;
                this.source = null;
                this.sink = null;
                this.handshake = null;
                this.protocol = null;
                this.http2Connection = null;
                this.allocationLimit = 1;
                eventListener.connectFailed(call, this.route.socketAddress(), this.route.proxy(), null, e);
                if (routeException == null) {
                    routeException = new RouteException(e);
                    continue;
                }
                routeException.addConnectException(e);
                if (connectionRetryEnabled && connectionSpecSelector.connectionFailed(e)) continue;
                throw (Throwable)routeException;
            }
            break;
        }
        if (this.route.requiresTunnel() && this.rawSocket == null) {
            throw (Throwable)new RouteException(new ProtocolException("Too many tunnel connections attempted: 21"));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void connectTunnel(int connectTimeout, int readTimeout, int writeTimeout, Call call, EventListener eventListener) throws IOException {
        Request tunnelRequest = this.createTunnelRequest();
        HttpUrl url = tunnelRequest.url();
        int n = 0;
        int n2 = 21;
        while (n < n2) {
            void i;
            this.connectSocket(connectTimeout, readTimeout, call, eventListener);
            if (this.createTunnel(readTimeout, writeTimeout, tunnelRequest, url) == null) {
                break;
            }
            Socket socket = this.rawSocket;
            if (socket != null) {
                Util.closeQuietly(socket);
            }
            this.rawSocket = null;
            this.sink = null;
            this.source = null;
            eventListener.connectEnd(call, this.route.socketAddress(), this.route.proxy(), null);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void connectSocket(int connectTimeout, int readTimeout, Call call, EventListener eventListener) throws IOException {
        block7: {
            proxy = this.route.proxy();
            address = this.route.address();
            v0 = proxy.type();
            if (v0 == null) ** GOTO lbl-1000
            switch (RealConnection$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
                case 1: 
                case 2: {
                    v1 = address.socketFactory().createSocket();
                    if (v1 != null) break;
                    Intrinsics.throwNpe();
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v1 = new Socket(proxy);
                }
            }
            this.rawSocket = rawSocket = v1;
            eventListener.connectStart(call, this.route.socketAddress(), proxy);
            rawSocket.setSoTimeout(readTimeout);
            try {
                Platform.Companion.get().connectSocket(rawSocket, this.route.socketAddress(), connectTimeout);
            }
            catch (ConnectException e) {
                var9_10 = new ConnectException("Failed to connect to " + this.route.socketAddress());
                var10_11 = false;
                var11_12 = false;
                $this$apply = var9_10;
                $i$a$-apply-RealConnection$connectSocket$1 = false;
                $this$apply.initCause(e);
                throw (Throwable)var9_10;
            }
            try {
                this.source = Okio.buffer((Source)Okio.source((Socket)rawSocket));
                this.sink = Okio.buffer((Sink)Okio.sink((Socket)rawSocket));
            }
            catch (NullPointerException npe) {
                if (!Intrinsics.areEqual((Object)npe.getMessage(), (Object)"throw with null exception")) break block7;
                throw (Throwable)new IOException(npe);
            }
        }
    }

    private final void establishProtocol(ConnectionSpecSelector connectionSpecSelector, int pingIntervalMillis, Call call, EventListener eventListener) throws IOException {
        if (this.route.address().sslSocketFactory() == null) {
            if (this.route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
                this.socket = this.rawSocket;
                this.protocol = Protocol.H2_PRIOR_KNOWLEDGE;
                this.startHttp2(pingIntervalMillis);
                return;
            }
            this.socket = this.rawSocket;
            this.protocol = Protocol.HTTP_1_1;
            return;
        }
        eventListener.secureConnectStart(call);
        this.connectTls(connectionSpecSelector);
        eventListener.secureConnectEnd(call, this.handshake);
        if (this.protocol == Protocol.HTTP_2) {
            this.startHttp2(pingIntervalMillis);
        }
    }

    private final void startHttp2(int pingIntervalMillis) throws IOException {
        Http2Connection http2Connection;
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwNpe();
        }
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        if (bufferedSource == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        if (bufferedSink == null) {
            Intrinsics.throwNpe();
        }
        BufferedSink sink = bufferedSink;
        socket2.setSoTimeout(0);
        this.http2Connection = http2Connection = new Http2Connection.Builder(true, TaskRunner.INSTANCE).socket(socket2, this.route.address().url().host(), source, sink).listener(this).pingIntervalMillis(pingIntervalMillis).build();
        this.allocationLimit = Http2Connection.Companion.getDEFAULT_SETTINGS().getMaxConcurrentStreams();
        Http2Connection.start$default(http2Connection, false, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void connectTls(ConnectionSpecSelector connectionSpecSelector) throws IOException {
        block12: {
            Address address = this.route.address();
            SSLSocketFactory sslSocketFactory = address.sslSocketFactory();
            boolean success = false;
            SSLSocket sslSocket = null;
            try {
                SSLSession sslSocketSession;
                SSLSocketFactory sSLSocketFactory = sslSocketFactory;
                if (sSLSocketFactory == null) {
                    Intrinsics.throwNpe();
                }
                Socket socket = sSLSocketFactory.createSocket(this.rawSocket, address.url().host(), address.url().port(), true);
                if (socket == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.SSLSocket");
                }
                sslSocket = (SSLSocket)socket;
                ConnectionSpec connectionSpec = connectionSpecSelector.configureSecureSocket(sslSocket);
                if (connectionSpec.supportsTlsExtensions()) {
                    Platform.Companion.get().configureTlsExtensions(sslSocket, address.url().host(), address.protocols());
                }
                sslSocket.startHandshake();
                SSLSession sSLSession = sslSocketSession = sslSocket.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)sSLSession, (String)"sslSocketSession");
                Handshake unverifiedHandshake = Handshake.Companion.get(sSLSession);
                HostnameVerifier hostnameVerifier = address.hostnameVerifier();
                if (hostnameVerifier == null) {
                    Intrinsics.throwNpe();
                }
                if (!hostnameVerifier.verify(address.url().host(), sslSocketSession)) {
                    List<Certificate> peerCertificates = unverifiedHandshake.peerCertificates();
                    Collection collection = peerCertificates;
                    boolean bl = false;
                    if (!collection.isEmpty()) {
                        Certificate certificate = peerCertificates.get(0);
                        if (certificate == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                        }
                        X509Certificate cert = (X509Certificate)certificate;
                        StringBuilder stringBuilder = new StringBuilder().append("\n              |Hostname ").append(address.url().host()).append(" not verified:\n              |    certificate: ").append(CertificatePinner.Companion.pin(cert)).append("\n              |    DN: ");
                        Principal principal = cert.getSubjectDN();
                        Intrinsics.checkExpressionValueIsNotNull((Object)principal, (String)"cert.subjectDN");
                        throw (Throwable)new SSLPeerUnverifiedException(StringsKt.trimMargin$default((String)stringBuilder.append(principal.getName()).append("\n              |    subjectAltNames: ").append(OkHostnameVerifier.INSTANCE.allSubjectAltNames(cert)).append("\n              ").toString(), null, (int)1, null));
                    }
                    throw (Throwable)new SSLPeerUnverifiedException("Hostname " + address.url().host() + " not verified (no certificates)");
                }
                CertificatePinner certificatePinner = address.certificatePinner();
                if (certificatePinner == null) {
                    Intrinsics.throwNpe();
                }
                CertificatePinner certificatePinner2 = certificatePinner;
                this.handshake = new Handshake(unverifiedHandshake.tlsVersion(), unverifiedHandshake.cipherSuite(), unverifiedHandshake.localCertificates(), (Function0<? extends List<? extends Certificate>>)((Function0)new Function0<List<? extends Certificate>>(certificatePinner2, unverifiedHandshake, address){
                    final /* synthetic */ CertificatePinner $certificatePinner;
                    final /* synthetic */ Handshake $unverifiedHandshake;
                    final /* synthetic */ Address $address;

                    @NotNull
                    public final List<Certificate> invoke() {
                        CertificateChainCleaner certificateChainCleaner = this.$certificatePinner.getCertificateChainCleaner$okhttp();
                        if (certificateChainCleaner == null) {
                            Intrinsics.throwNpe();
                        }
                        return certificateChainCleaner.clean(this.$unverifiedHandshake.peerCertificates(), this.$address.url().host());
                    }
                    {
                        this.$certificatePinner = certificatePinner;
                        this.$unverifiedHandshake = handshake2;
                        this.$address = address;
                        super(0);
                    }
                }));
                certificatePinner2.check$okhttp(address.url().host(), (Function0<? extends List<? extends X509Certificate>>)((Function0)new Function0<List<? extends X509Certificate>>(this){
                    final /* synthetic */ RealConnection this$0;

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final List<X509Certificate> invoke() {
                        void $this$mapTo$iv$iv;
                        Handshake handshake2 = RealConnection.access$getHandshake$p(this.this$0);
                        if (handshake2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Iterable $this$map$iv = handshake2.peerCertificates();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Certificate certificate = (Certificate)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            void v1 = it;
                            if (v1 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                            }
                            X509Certificate x509Certificate = (X509Certificate)v1;
                            collection.add(x509Certificate);
                        }
                        return (List)destination$iv$iv;
                    }
                    {
                        this.this$0 = realConnection;
                        super(0);
                    }
                }));
                String maybeProtocol = connectionSpec.supportsTlsExtensions() ? Platform.Companion.get().getSelectedProtocol(sslSocket) : null;
                this.socket = sslSocket;
                this.source = Okio.buffer((Source)Okio.source((Socket)sslSocket));
                this.sink = Okio.buffer((Sink)Okio.sink((Socket)sslSocket));
                this.protocol = maybeProtocol != null ? Protocol.Companion.get(maybeProtocol) : Protocol.HTTP_1_1;
                success = true;
                if (sslSocket == null) break block12;
                Platform.Companion.get().afterHandshake(sslSocket);
            }
            catch (Throwable throwable) {
                if (sslSocket != null) {
                    Platform.Companion.get().afterHandshake(sslSocket);
                }
                SSLSocket sSLSocket = sslSocket;
                if (sSLSocket != null) {
                    Util.closeQuietly(sSLSocket);
                }
                throw throwable;
            }
        }
    }

    private final Request createTunnel(int readTimeout, int writeTimeout, Request tunnelRequest, HttpUrl url) throws IOException {
        Response response;
        Request nextRequest = tunnelRequest;
        String requestLine = "CONNECT " + Util.toHostHeader(url, true) + " HTTP/1.1";
        block4: while (true) {
            BufferedSink sink;
            BufferedSource source;
            if (this.source == null) {
                Intrinsics.throwNpe();
            }
            if (this.sink == null) {
                Intrinsics.throwNpe();
            }
            Http1ExchangeCodec tunnelCodec = new Http1ExchangeCodec(null, null, source, sink);
            source.timeout().timeout((long)readTimeout, TimeUnit.MILLISECONDS);
            sink.timeout().timeout((long)writeTimeout, TimeUnit.MILLISECONDS);
            tunnelCodec.writeRequest(nextRequest.headers(), requestLine);
            tunnelCodec.finishRequest();
            Response.Builder builder = tunnelCodec.readResponseHeaders(false);
            if (builder == null) {
                Intrinsics.throwNpe();
            }
            response = builder.request(nextRequest).build();
            tunnelCodec.skipConnectBody(response);
            switch (response.code()) {
                case 200: {
                    if (!source.getBuffer().exhausted() || !sink.getBuffer().exhausted()) {
                        throw (Throwable)new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return null;
                }
                case 407: {
                    if (this.route.address().proxyAuthenticator().authenticate(this.route, response) != null) continue block4;
                    throw (Throwable)new IOException("Failed to authenticate with proxy");
                    if (!StringsKt.equals((String)"close", (String)Response.header$default(response, "Connection", null, 2, null), (boolean)true)) continue block4;
                    return nextRequest;
                }
            }
            break;
        }
        throw (Throwable)new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private final Request createTunnelRequest() throws IOException {
        Request proxyConnectRequest = new Request.Builder().url(this.route.address().url()).method("CONNECT", null).header("Host", Util.toHostHeader(this.route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/4.3.1").build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request authenticatedRequest = this.route.address().proxyAuthenticator().authenticate(this.route, fakeAuthChallengeResponse);
        Request request = authenticatedRequest;
        if (request == null) {
            request = proxyConnectRequest;
        }
        return request;
    }

    public final boolean isEligible$okhttp(@NotNull Address address, @Nullable List<Route> routes) {
        Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
        if (this.transmitters.size() >= this.allocationLimit || this.noNewExchanges) {
            return false;
        }
        if (!this.route.address().equalsNonHost$okhttp(address)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)address.url().host(), (Object)this.route().address().url().host())) {
            return true;
        }
        if (this.http2Connection == null) {
            return false;
        }
        if (routes == null || !this.routeMatchesAny(routes)) {
            return false;
        }
        if (address.hostnameVerifier() != OkHostnameVerifier.INSTANCE) {
            return false;
        }
        if (!this.supportsUrl(address.url())) {
            return false;
        }
        try {
            CertificatePinner certificatePinner = address.certificatePinner();
            if (certificatePinner == null) {
                Intrinsics.throwNpe();
            }
            String string = address.url().host();
            Handshake handshake2 = this.handshake();
            if (handshake2 == null) {
                Intrinsics.throwNpe();
            }
            certificatePinner.check(string, handshake2.peerCertificates());
        }
        catch (SSLPeerUnverifiedException _) {
            return false;
        }
        return true;
    }

    private final boolean routeMatchesAny(List<Route> candidates) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = candidates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Route it = (Route)element$iv;
                    boolean bl2 = false;
                    if (!(it.proxy().type() == Proxy.Type.DIRECT && this.route.proxy().type() == Proxy.Type.DIRECT && Intrinsics.areEqual((Object)this.route.socketAddress(), (Object)it.socketAddress()))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean supportsUrl(@NotNull HttpUrl url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        HttpUrl routeUrl = this.route.address().url();
        if (url.port() != routeUrl.port()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)url.host(), (Object)routeUrl.host())) {
            return true;
        }
        if (this.handshake == null) return false;
        String string = url.host();
        Handshake handshake2 = this.handshake;
        if (handshake2 == null) {
            Intrinsics.throwNpe();
        }
        Certificate certificate = handshake2.peerCertificates().get(0);
        if (certificate == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.cert.X509Certificate");
        }
        if (!OkHostnameVerifier.INSTANCE.verify(string, (X509Certificate)certificate)) return false;
        return true;
    }

    @NotNull
    public final ExchangeCodec newCodec$okhttp(@NotNull OkHttpClient client, @NotNull Interceptor.Chain chain) throws SocketException {
        ExchangeCodec exchangeCodec;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwNpe();
        }
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        if (bufferedSource == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        if (bufferedSink == null) {
            Intrinsics.throwNpe();
        }
        BufferedSink sink = bufferedSink;
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            exchangeCodec = new Http2ExchangeCodec(client, this, chain, http2Connection);
        } else {
            socket2.setSoTimeout(chain.readTimeoutMillis());
            source.timeout().timeout((long)chain.readTimeoutMillis(), TimeUnit.MILLISECONDS);
            sink.timeout().timeout((long)chain.writeTimeoutMillis(), TimeUnit.MILLISECONDS);
            exchangeCodec = new Http1ExchangeCodec(client, this, source, sink);
        }
        return exchangeCodec;
    }

    @NotNull
    public final RealWebSocket.Streams newWebSocketStreams$okhttp(@NotNull Exchange exchange) throws SocketException {
        Intrinsics.checkParameterIsNotNull((Object)exchange, (String)"exchange");
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwNpe();
        }
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        if (bufferedSource == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource source = bufferedSource;
        BufferedSink bufferedSink = this.sink;
        if (bufferedSink == null) {
            Intrinsics.throwNpe();
        }
        BufferedSink sink = bufferedSink;
        socket2.setSoTimeout(0);
        this.noNewExchanges();
        return new RealWebSocket.Streams(exchange, source, sink, true, source, sink){
            final /* synthetic */ Exchange $exchange;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ BufferedSink $sink;

            public void close() {
                this.$exchange.bodyComplete(-1L, true, true, null);
            }
            {
                this.$exchange = $captured_local_variable$0;
                this.$source = $captured_local_variable$1;
                this.$sink = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    @Override
    @NotNull
    public Route route() {
        return this.route;
    }

    public final void cancel() {
        block0: {
            Socket socket = this.rawSocket;
            if (socket == null) break block0;
            Util.closeQuietly(socket);
        }
    }

    @Override
    @NotNull
    public Socket socket() {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwNpe();
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isHealthy(boolean doExtensiveChecks) {
        Socket socket = this.socket;
        if (socket == null) {
            Intrinsics.throwNpe();
        }
        Socket socket2 = socket;
        BufferedSource bufferedSource = this.source;
        if (bufferedSource == null) {
            Intrinsics.throwNpe();
        }
        BufferedSource source = bufferedSource;
        if (socket2.isClosed() || socket2.isInputShutdown() || socket2.isOutputShutdown()) {
            return false;
        }
        Http2Connection http2Connection = this.http2Connection;
        if (http2Connection != null) {
            return http2Connection.isHealthy(System.nanoTime());
        }
        if (doExtensiveChecks) {
            try {
                int readTimeout = socket2.getSoTimeout();
                try {
                    socket2.setSoTimeout(1);
                    boolean bl = !source.exhausted();
                    return bl;
                }
                finally {
                    socket2.setSoTimeout(readTimeout);
                }
            }
            catch (SocketTimeoutException readTimeout) {
            }
            catch (IOException _) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void onStream(@NotNull Http2Stream stream) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        stream.close(ErrorCode.REFUSED_STREAM, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettings(@NotNull Http2Connection connection, @NotNull Settings settings) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            boolean bl3 = false;
            this.allocationLimit = settings.getMaxConcurrentStreams();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @Nullable
    public Handshake handshake() {
        return this.handshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackFailure$okhttp(@Nullable IOException e) {
        RealConnectionPool $this$assertThreadDoesntHoldLock$iv = this.connectionPool;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
        }
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            block13: {
                block12: {
                    boolean bl3 = false;
                    if (!(e instanceof StreamResetException)) break block12;
                    switch (RealConnection$WhenMappings.$EnumSwitchMapping$1[((StreamResetException)e).errorCode.ordinal()]) {
                        case 1: {
                            int n = this.refusedStreamCount;
                            this.refusedStreamCount = n + 1;
                            if (this.refusedStreamCount > 1) {
                                this.noNewExchanges = true;
                                n = this.routeFailureCount;
                                this.routeFailureCount = n + 1;
                                break;
                            }
                            break block13;
                        }
                        case 2: {
                            break;
                        }
                        default: {
                            this.noNewExchanges = true;
                            int n = this.routeFailureCount;
                            this.routeFailureCount = n + 1;
                            break;
                        }
                    }
                    break block13;
                }
                if (!this.isMultiplexed() || e instanceof ConnectionShutdownException) {
                    this.noNewExchanges = true;
                    if (this.successCount == 0) {
                        if (e != null) {
                            this.connectionPool.connectFailed(this.route, e);
                        }
                        int n = this.routeFailureCount;
                        this.routeFailureCount = n + 1;
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Protocol protocol() {
        Protocol protocol = this.protocol;
        if (protocol == null) {
            Intrinsics.throwNpe();
        }
        return protocol;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Connection{").append(this.route.address().url().host()).append(':').append(this.route.address().url().port()).append(',').append(" proxy=").append(this.route.proxy()).append(" hostAddress=").append(this.route.socketAddress()).append(" cipherSuite=");
        Object object = this.handshake;
        if (object == null || (object = ((Handshake)object).cipherSuite()) == null) {
            object = "none";
        }
        return stringBuilder.append(object).append(" protocol=").append((Object)this.protocol).append('}').toString();
    }

    @NotNull
    public final RealConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public RealConnection(@NotNull RealConnectionPool connectionPool, @NotNull Route route) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
        this.connectionPool = connectionPool;
        this.route = route;
        this.allocationLimit = 1;
        RealConnection realConnection = this;
        boolean bl = false;
        realConnection.transmitters = list = (List)new ArrayList();
        this.idleAtNanos = Long.MAX_VALUE;
    }

    public static final /* synthetic */ Handshake access$getHandshake$p(RealConnection $this) {
        return $this.handshake;
    }

    public static final /* synthetic */ void access$setHandshake$p(RealConnection $this, Handshake handshake2) {
        $this.handshake = handshake2;
    }

    public static final /* synthetic */ Socket access$getSocket$p(RealConnection $this) {
        return $this.socket;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/connection/RealConnection$Companion;", "", "()V", "MAX_TUNNEL_ATTEMPTS", "", "NPE_THROW_WITH_NULL", "", "newTestConnection", "Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "route", "Lokhttp3/Route;", "socket", "Ljava/net/Socket;", "idleAtNanos", "", "okhttp"})
    public static final class Companion {
        @NotNull
        public final RealConnection newTestConnection(@NotNull RealConnectionPool connectionPool, @NotNull Route route, @NotNull Socket socket, long idleAtNanos) {
            Intrinsics.checkParameterIsNotNull((Object)connectionPool, (String)"connectionPool");
            Intrinsics.checkParameterIsNotNull((Object)route, (String)"route");
            Intrinsics.checkParameterIsNotNull((Object)socket, (String)"socket");
            RealConnection result = new RealConnection(connectionPool, route);
            result.socket = socket;
            result.setIdleAtNanos$okhttp(idleAtNanos);
            return result;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

