/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.html;

import com.vladsch.flexmark.util.html.Attribute;
import com.vladsch.flexmark.util.html.MutableAttribute;
import com.vladsch.flexmark.util.html.MutableAttributeImpl;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.SubSequence;

public class AttributeImpl
implements Attribute {
    private final String myName;
    private final char myValueListDelimiter;
    private final char myValueNameDelimiter;
    private final String myValue;

    private AttributeImpl(CharSequence name, CharSequence value, char valueListDelimiter, char valueNameDelimiter) {
        this.myName = name instanceof String ? (String)name : String.valueOf(name);
        this.myValueListDelimiter = valueListDelimiter;
        this.myValueNameDelimiter = valueNameDelimiter;
        this.myValue = value == null ? "" : (value instanceof String ? (String)value : String.valueOf(value));
    }

    @Override
    public MutableAttribute toMutable() {
        return MutableAttributeImpl.of(this);
    }

    @Override
    public char getValueListDelimiter() {
        return this.myValueListDelimiter;
    }

    @Override
    public char getValueNameDelimiter() {
        return this.myValueNameDelimiter;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public String getValue() {
        return this.myValue;
    }

    @Override
    public boolean isNonRendering() {
        return this.myName.indexOf(32) != -1 || this.myValue.isEmpty() && NON_RENDERING_WHEN_EMPTY.contains(this.myName);
    }

    public static int indexOfValue(CharSequence value, CharSequence valueName, char valueListDelimiter, char valueNameDelimiter) {
        int pos;
        if (valueName.length() == 0 || value.length() == 0) {
            return -1;
        }
        if (valueListDelimiter == '\u0000') {
            return value.equals(valueName) ? 0 : -1;
        }
        int lastPos = 0;
        BasedSequence subSeq = SubSequence.of(value);
        while (lastPos < value.length() && (pos = subSeq.indexOf(valueName, lastPos)) != -1) {
            int endPos = pos + valueName.length();
            if ((pos == 0 || value.charAt(pos - 1) == valueListDelimiter || valueNameDelimiter != '\u0000' && value.charAt(pos - 1) == valueNameDelimiter) && (endPos >= value.length() || value.charAt(endPos) == valueListDelimiter || valueNameDelimiter != '\u0000' && value.charAt(endPos) == valueNameDelimiter)) {
                return pos;
            }
            lastPos = endPos + 1;
        }
        return -1;
    }

    @Override
    public boolean containsValue(CharSequence value) {
        return AttributeImpl.indexOfValue(this.myValue, value, this.myValueListDelimiter, this.myValueNameDelimiter) != -1;
    }

    @Override
    public Attribute replaceValue(CharSequence value) {
        return this.myValue.equals(value) ? this : AttributeImpl.of(this.myName, value, this.myValueListDelimiter, this.myValueNameDelimiter);
    }

    @Override
    public Attribute setValue(CharSequence value) {
        MutableAttribute mutable = this.toMutable().setValue(value);
        return mutable.equals(this) ? this : (Attribute)mutable.toImmutable();
    }

    @Override
    public Attribute removeValue(CharSequence value) {
        MutableAttribute mutable = this.toMutable().removeValue(value);
        return mutable.equals(this) ? this : (Attribute)mutable.toImmutable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (!this.myName.equals(attribute.getName())) {
            return false;
        }
        return this.myValue.equals(attribute.getValue());
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myValue.hashCode();
        return result;
    }

    public String toString() {
        return "AttributeImpl { myName='" + this.myName + '\'' + ", myValue='" + this.myValue + '\'' + " }";
    }

    public static AttributeImpl of(Attribute other) {
        return AttributeImpl.of(other.getName(), other.getValue(), other.getValueListDelimiter(), other.getValueNameDelimiter());
    }

    public static AttributeImpl of(CharSequence attrName) {
        return AttributeImpl.of(attrName, attrName, '\u0000', '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value) {
        return AttributeImpl.of(attrName, value, '\u0000', '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value, char valueListDelimiter) {
        return AttributeImpl.of(attrName, value, valueListDelimiter, '\u0000');
    }

    public static AttributeImpl of(CharSequence attrName, CharSequence value, char valueListDelimiter, char valueNameDelimiter) {
        if ("class".equals(attrName)) {
            return new AttributeImpl(attrName, value, ' ', '\u0000');
        }
        if ("style".equals(attrName)) {
            return new AttributeImpl(attrName, value, ';', ':');
        }
        return new AttributeImpl(attrName, value, valueListDelimiter, valueNameDelimiter);
    }
}

