/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler.reporting.html;

import com.github.jknack.handlebars.Handlebars;
import fr.jcgay.maven.profiler.reporting.Files;
import fr.jcgay.maven.profiler.reporting.ReportDirectory;
import fr.jcgay.maven.profiler.reporting.ReportFormat;
import fr.jcgay.maven.profiler.reporting.Reporter;
import fr.jcgay.maven.profiler.reporting.template.Data;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlReporter
implements Reporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlReporter.class);

    @Override
    public void write(Data data, ReportDirectory directory) {
        String report;
        try {
            report = new Handlebars().compile("report-template").apply((Object)data);
        }
        catch (IOException e) {
            LOGGER.error("Cannot render profiler report.", (Throwable)e);
            return;
        }
        Files.write(directory.fileName(data.getDate(), ReportFormat.HTML), report);
    }
}

