/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc;

import io.gatling.recorder.internal.bouncycastle.pqc.crypto.hqc.Utils;
import io.gatling.recorder.internal.bouncycastle.util.Arrays;

class ReedMuller {
    ReedMuller() {
    }

    static void encodeSub(Codeword codeword, int n) {
        int n2 = ReedMuller.Bit0Mask(n >> 7);
        n2 ^= ReedMuller.Bit0Mask(n >> 0) & 0xAAAAAAAA;
        n2 ^= ReedMuller.Bit0Mask(n >> 1) & 0xCCCCCCCC;
        n2 ^= ReedMuller.Bit0Mask(n >> 2) & 0xF0F0F0F0;
        n2 ^= ReedMuller.Bit0Mask(n >> 3) & 0xFF00FF00;
        codeword.type32[0] = n2 ^= ReedMuller.Bit0Mask(n >> 4) & 0xFFFF0000;
        codeword.type32[1] = n2 ^= ReedMuller.Bit0Mask(n >> 5);
        codeword.type32[3] = n2 ^= ReedMuller.Bit0Mask(n >> 6);
        codeword.type32[2] = n2 ^= ReedMuller.Bit0Mask(n >> 5);
    }

    private static void hadamardTransform(int[] nArray, int[] nArray2) {
        int[] nArray3 = Arrays.clone(nArray);
        int[] nArray4 = Arrays.clone(nArray2);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 64; ++j) {
                nArray4[j] = nArray3[2 * j] + nArray3[2 * j + 1];
                nArray4[j + 64] = nArray3[2 * j] - nArray3[2 * j + 1];
            }
            int[] nArray5 = Arrays.clone(nArray3);
            nArray3 = Arrays.clone(nArray4);
            nArray4 = Arrays.clone(nArray5);
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray.length);
        System.arraycopy(nArray3, 0, nArray2, 0, nArray2.length);
    }

    private static void expandThenSum(int[] nArray, Codeword[] codewordArray, int n, int n2) {
        int n3;
        int n4;
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < 32; ++n3) {
                long l = codewordArray[0 + n].type32[n4] >> n3 & 1;
                nArray[n4 * 32 + n3] = codewordArray[0 + n].type32[n4] >> n3 & 1;
            }
        }
        for (n4 = 1; n4 < n2; ++n4) {
            for (n3 = 0; n3 < 4; ++n3) {
                for (int i = 0; i < 32; ++i) {
                    int n5 = n3 * 32 + i;
                    nArray[n5] = nArray[n5] + (codewordArray[n4 + n].type32[n3] >> i & 1);
                }
            }
        }
    }

    private static int findPeaks(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < 128; ++n) {
            int n5 = nArray[n];
            int n6 = n5 > 0 ? -1 : 0;
            int n7 = n6 & n5 | ~n6 & -n5;
            n3 = n7 > n2 ? n5 : n3;
            n4 = n7 > n2 ? n : n4;
            n2 = n7 > n2 ? n7 : n2;
        }
        n = n3 > 0 ? 1 : 0;
        return n4 |= 128 * n;
    }

    private static int Bit0Mask(int n) {
        return -(n & 1) & 0xFFFFFFFF;
    }

    public static void encode(long[] lArray, long[] lArray2, int n, int n2) {
        int n3;
        int n4;
        int n5;
        byte[] byArray = new byte[n];
        Utils.fromLongArrayToByteArray(byArray, lArray2, n * 8);
        Codeword[] codewordArray = new Codeword[n * n2];
        for (n5 = 0; n5 < codewordArray.length; ++n5) {
            codewordArray[n5] = new Codeword();
        }
        for (n5 = 0; n5 < n; ++n5) {
            n4 = n5 * n2;
            ReedMuller.encodeSub(codewordArray[n4], byArray[n5]);
            for (n3 = 1; n3 < n2; ++n3) {
                codewordArray[n4 + n3] = codewordArray[n4];
            }
        }
        int[] nArray = new int[codewordArray.length * 4];
        n4 = 0;
        for (n3 = 0; n3 < codewordArray.length; ++n3) {
            System.arraycopy(codewordArray[n3].type32, 0, nArray, n4, codewordArray[n3].type32.length);
            n4 += 4;
        }
        Utils.fromByte32ArrayToLongArray(lArray, nArray);
    }

    public static void decode(long[] lArray, long[] lArray2, int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = new byte[n];
        Utils.fromLongArrayToByteArray(byArray, lArray, n * 8);
        Codeword[] codewordArray = new Codeword[lArray2.length / 2];
        int[] nArray = new int[lArray2.length * 2];
        Utils.fromLongArrayToByte32Array(nArray, lArray2);
        for (int i = 0; i < codewordArray.length; ++i) {
            codewordArray[i] = new Codeword();
            for (n4 = 0; n4 < 4; ++n4) {
                codewordArray[i].type32[n4] = nArray[i * 4 + n4];
            }
        }
        int[] nArray2 = new int[128];
        for (n4 = 0; n4 < n; ++n4) {
            ReedMuller.expandThenSum(nArray2, codewordArray, n4 * n2, n2);
            int[] nArray3 = new int[128];
            ReedMuller.hadamardTransform(nArray2, nArray3);
            nArray3[0] = nArray3[0] - 64 * n2;
            n3 = ReedMuller.findPeaks(nArray3);
            byArray[n4] = (byte)ReedMuller.findPeaks(nArray3);
        }
        int[] nArray4 = new int[codewordArray.length * 4];
        int n5 = 0;
        for (n3 = 0; n3 < codewordArray.length; ++n3) {
            System.arraycopy(codewordArray[n3].type32, 0, nArray4, n5, codewordArray[n3].type32.length);
            n5 += 4;
        }
        Utils.fromByte32ArrayToLongArray(lArray2, nArray4);
        Utils.fromByteArrayToLongArray(lArray, byArray);
    }

    static class Codeword {
        int[] type32 = new int[4];
        int[] type8 = new int[16];
    }
}

