/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkus.arc.Subclass;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class QuarkusJaxWsServiceFactoryBean
extends JaxWsServiceFactoryBean {
    private static final org.jboss.logging.Logger LOGGER = org.jboss.logging.Logger.getLogger(QuarkusJaxWsServiceFactoryBean.class);
    private Set<Class<?>> wrapperClasses;
    private static final Logger LOG = LogUtils.getLogger(QuarkusJaxWsServiceFactoryBean.class);

    public QuarkusJaxWsServiceFactoryBean(List<String> classNames) {
        this.wrapperClasses = classNames.stream().distinct().map(className -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.error((Object)"Generated Wrapper class not found", (Throwable)e);
                    return null;
                }
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void reset() {
        super.reset();
        this.wrapperClasses = null;
    }

    protected Set<Class<?>> getExtraClass() {
        XmlSeeAlso xmlSeeAlsoAnno;
        HashSet classes = new HashSet();
        if (this.wrapperClasses != null) {
            classes.addAll(this.wrapperClasses);
        }
        if ((xmlSeeAlsoAnno = this.getServiceClass().getAnnotation(XmlSeeAlso.class)) != null && xmlSeeAlsoAnno.value() != null) {
            for (int i = 0; i < xmlSeeAlsoAnno.value().length; ++i) {
                Class value = xmlSeeAlsoAnno.value()[i];
                if (value == null) {
                    LOG.log(Level.WARNING, "XMLSEEALSO_NULL_CLASS", new Object[]{this.getServiceClass().getName(), i});
                    continue;
                }
                classes.add(value);
            }
        }
        return classes;
    }

    public void setServiceClass(Class<?> serviceClass) {
        if (serviceClass == null) {
            Message message = new Message("SERVICECLASS_MUST_BE_SET", LOG, new Object[0]);
            throw new ServiceConstructionException(message);
        }
        if (Subclass.class.isAssignableFrom(serviceClass)) {
            serviceClass = serviceClass.getSuperclass();
        }
        this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        super.setServiceClass(this.getJaxWsImplementorInfo().getEndpointClass());
        super.setServiceType(this.getJaxWsImplementorInfo().getSEIType());
    }
}

