/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment.visitors;

import io.quarkus.deployment.util.AsmUtil;
import io.quarkus.deployment.util.JandexUtil;
import io.quarkus.panache.common.deployment.ByteCodeType;
import io.quarkus.panache.common.deployment.PanacheEntityEnhancer;
import io.quarkus.panache.common.deployment.PanacheMethodCustomizer;
import io.quarkus.panache.common.deployment.TypeBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class KotlinPanacheClassVisitor
extends ClassVisitor {
    public static final ByteCodeType OBJECT = new ByteCodeType(Object.class);
    protected static final ByteCodeType NOT_NULL = new ByteCodeType(NotNull.class);
    protected static final ByteCodeType CLASS = new ByteCodeType(Class.class);
    protected final Function<String, String> argMapper;
    protected final ClassInfo classInfo;
    protected final ByteCodeType entityUpperBound;
    protected final Map<String, ByteCodeType> typeArguments = new HashMap<String, ByteCodeType>();
    private final ByteCodeType baseType;
    private final Map<String, MethodInfo> definedMethods = new TreeMap<String, MethodInfo>();
    private final Map<String, String> erasures = new HashMap<String, String>();
    private final IndexView indexView;
    protected List<PanacheMethodCustomizer> methodCustomizers;
    protected TypeBundle typeBundle;

    public KotlinPanacheClassVisitor(ClassVisitor outputClassVisitor, ClassInfo classInfo, IndexView indexView, TypeBundle typeBundle, ByteCodeType baseType, List<PanacheMethodCustomizer> methodCustomizers) {
        super(589824, outputClassVisitor);
        this.classInfo = classInfo;
        this.indexView = indexView;
        this.typeBundle = typeBundle;
        this.baseType = baseType;
        this.methodCustomizers = methodCustomizers;
        List typeVariables = indexView.getClassByName(baseType.dotName()).typeParameters();
        this.entityUpperBound = !typeVariables.isEmpty() ? new ByteCodeType((Type)((TypeVariable)typeVariables.get(0)).bounds().get(0)) : OBJECT;
        this.discoverTypeParameters(classInfo, indexView, typeBundle, baseType);
        this.argMapper = type -> {
            ByteCodeType byteCodeType = this.typeArguments.get(type);
            return byteCodeType != null ? byteCodeType.descriptor() : type;
        };
        this.collectMethods(classInfo);
        this.filterNonOverrides();
    }

    protected void discoverTypeParameters(ClassInfo classInfo, IndexView indexView, TypeBundle types, ByteCodeType baseType) {
        List<ByteCodeType> foundTypeArguments = KotlinPanacheClassVisitor.recursivelyFindEntityTypeArguments(indexView, classInfo.name(), baseType.dotName());
        ByteCodeType entityType = foundTypeArguments.size() > 0 ? foundTypeArguments.get(0) : OBJECT;
        ByteCodeType idType = foundTypeArguments.size() > 1 ? foundTypeArguments.get(1).unbox() : OBJECT;
        this.typeArguments.put("Entity", entityType);
        this.typeArguments.put("Id", idType);
        this.typeArguments.keySet().stream().filter(k -> !k.equals("Id")).forEach(k -> this.erasures.put((String)k, OBJECT.descriptor()));
        try {
            this.erasures.put(this.typeArguments.get("Entity").dotName().toString(), this.entityUpperBound.descriptor());
            this.erasures.put(types.queryType().dotName().toString(), OBJECT.descriptor());
            this.erasures.put(types.updateType().dotName().toString(), OBJECT.descriptor());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static List<ByteCodeType> recursivelyFindEntityTypeArguments(IndexView indexView, DotName clazz, DotName repositoryDotName) {
        if (clazz.equals((Object)JandexUtil.DOTNAME_OBJECT)) {
            return Collections.emptyList();
        }
        return JandexUtil.resolveTypeParameters((DotName)clazz, (DotName)repositoryDotName, (IndexView)indexView).stream().map(t -> new ByteCodeType((Type)t)).collect(Collectors.toList());
    }

    private void collectMethods(ClassInfo classInfo) {
        if (classInfo != null && !classInfo.name().equals((Object)this.baseType.dotName())) {
            classInfo.methods().forEach(method -> {
                String descriptor = AsmUtil.getDescriptor((MethodInfo)method, m -> {
                    ByteCodeType byteCodeType = this.typeArguments.get(m);
                    return byteCodeType != null ? byteCodeType.descriptor() : OBJECT.descriptor();
                });
                MethodInfo prior = this.definedMethods.put(method.name() + descriptor, (MethodInfo)method);
                if (prior != null && !this.isBridgeMethod((MethodInfo)method)) {
                    throw new IllegalStateException(String.format("Should not run in to duplicate mappings: \n\t%s\n\t%s\n\t%s", method, descriptor, prior));
                }
            });
            this.collectMethods(this.indexView.getClassByName(classInfo.superName()));
        }
    }

    private void filterNonOverrides() {
        new ArrayList<MethodInfo>(this.definedMethods.values()).forEach(method -> {
            AnnotationInstance generateBridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE);
            if (generateBridge != null) {
                this.definedMethods.remove(method.name() + AsmUtil.getDescriptor((MethodInfo)method, m -> m));
                AnnotationValue typeErased = generateBridge.value("targetReturnTypeErased");
                if (typeErased != null && typeErased.asBoolean()) {
                    this.definedMethods.remove(method.name() + this.bridgeMethodDescriptor((MethodInfo)method, type -> type));
                }
            }
        });
    }

    private void generate(MethodInfo method) {
        MethodVisitor mv = this.cv.visitMethod(1, method.name(), AsmUtil.getDescriptor((MethodInfo)method, this.argMapper), AsmUtil.getSignature((MethodInfo)method, this.argMapper), null);
        List parameters = method.parameters();
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        for (PanacheMethodCustomizer customizer : this.methodCustomizers) {
            org.objectweb.asm.Type thisClass = org.objectweb.asm.Type.getType((String)("L" + this.classInfo.name().toString().replace('.', '/') + ";"));
            customizer.customize(thisClass, method, mv);
        }
        this.addNullityChecks(mv, parameters);
        this.loadOperationsReference(mv);
        this.loadArguments(mv, parameters);
        this.invokeOperation(mv, method);
        mv.visitMaxs(parameters.size() + 1, parameters.size());
        for (int i = 0; i < parameters.size(); ++i) {
            Type argument = (Type)parameters.get(i);
            for (AnnotationInstance annotation : argument.annotations()) {
                mv.visitParameterAnnotation(i, "L" + annotation.name() + ";", true);
            }
        }
    }

    private void generateBridge(MethodInfo method) {
        String descriptor = this.bridgeMethodDescriptor(method, type -> {
            ByteCodeType mapped = this.typeArguments.get(type);
            return mapped != null ? mapped.descriptor() : type;
        });
        MethodVisitor mv = this.cv.visitMethod(4161, method.name(), descriptor, null, null);
        List parameters = method.parameters();
        AsmUtil.copyParameterNames((MethodVisitor)mv, (MethodInfo)method);
        mv.visitCode();
        mv.visitIntInsn(25, 0);
        for (int i = 0; i < parameters.size(); ++i) {
            Type paramType = (Type)parameters.get(i);
            if (paramType.kind() == Type.Kind.PRIMITIVE) {
                throw new IllegalStateException("BUG: Don't know how to generate JVM bridge method for " + method + ": has primitive parameters");
            }
            mv.visitIntInsn(25, i + 1);
            if (paramType.kind() != Type.Kind.TYPE_VARIABLE) continue;
            String typeParamName = paramType.asTypeVariable().identifier();
            org.objectweb.asm.Type type2 = org.objectweb.asm.Type.getType((String)this.typeArguments.get(typeParamName).descriptor());
            if (type2.getSort() > 8) {
                mv.visitTypeInsn(192, type2.getInternalName());
                continue;
            }
            AsmUtil.unboxIfRequired((MethodVisitor)mv, (org.objectweb.asm.Type)type2);
        }
        String targetDescriptor = AsmUtil.getDescriptor((MethodInfo)method, name -> this.typeArguments.get(name).descriptor());
        mv.visitMethodInsn(182, this.classInfo.name().toString().replace('.', '/'), method.name(), targetDescriptor, false);
        String targetReturnTypeDescriptor = targetDescriptor.substring(targetDescriptor.indexOf(41) + 1);
        mv.visitInsn(AsmUtil.getReturnInstruction((String)targetReturnTypeDescriptor));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private void invokeOperation(MethodVisitor mv, MethodInfo method) {
        StringJoiner joiner = new StringJoiner("", "(", ")");
        joiner.add(CLASS.descriptor());
        this.descriptors(method, joiner);
        Type returnType = method.returnType();
        String descriptor = AsmUtil.getDescriptor((Type)returnType, this.argMapper);
        String key = returnType.kind() == Type.Kind.TYPE_VARIABLE ? returnType.asTypeVariable().identifier() : returnType.name().toString();
        String operationDescriptor = joiner + this.erasures.getOrDefault(key, descriptor);
        mv.visitMethodInsn(182, this.typeBundle.operations().internalName(), method.name(), operationDescriptor, false);
        if (returnType.kind() != Type.Kind.PRIMITIVE) {
            String cast;
            if (returnType.kind() == Type.Kind.TYPE_VARIABLE) {
                ByteCodeType type = this.typeArguments.getOrDefault(returnType.asTypeVariable().identifier(), this.entityUpperBound);
                cast = type.internalName();
            } else {
                cast = returnType.name().toString().replace('.', '/');
            }
            mv.visitTypeInsn(192, cast);
        }
        mv.visitInsn(AsmUtil.getReturnInstruction((Type)returnType));
    }

    private boolean isBridgeMethod(MethodInfo method) {
        return (method.flags() & 0x40) != 64;
    }

    private void loadArguments(MethodVisitor mv, List<Type> parameters) {
        mv.visitLdcInsn((Object)this.typeArguments.get("Entity").type());
        int index = 1;
        for (Type methodParameter : parameters) {
            org.objectweb.asm.Type parameter = methodParameter.kind() == Type.Kind.TYPE_VARIABLE ? this.typeArguments.get(methodParameter.asTypeVariable().identifier()).type() : org.objectweb.asm.Type.getType((String)AsmUtil.getDescriptor((Type)methodParameter, s -> null));
            mv.visitVarInsn(parameter.getOpcode(21), index);
            index += parameter.getSize();
            if (parameter.getSort() >= 9) continue;
            org.objectweb.asm.Type wrapper = AsmUtil.autobox((org.objectweb.asm.Type)parameter);
            mv.visitMethodInsn(184, wrapper.getInternalName(), "valueOf", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)wrapper, (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{parameter}), false);
        }
    }

    protected String bridgeMethodDescriptor(MethodInfo method, Function<String, String> mapper) {
        AnnotationValue value;
        StringJoiner joiner = new StringJoiner("", "(", ")");
        this.descriptors(method, joiner);
        AnnotationInstance annotation = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE);
        boolean erased = annotation != null ? (value = annotation.value("targetReturnTypeErased")) != null && value.asBoolean() : false;
        String returnType = erased ? this.entityUpperBound.descriptor() : AsmUtil.getDescriptor((Type)method.returnType(), mapper);
        return joiner.toString() + returnType;
    }

    private void descriptors(MethodInfo method, StringJoiner joiner) {
        for (Type parameter : method.parameters()) {
            if (parameter.kind() == Type.Kind.TYPE_VARIABLE || method.name().endsWith("ById") && parameter.name().equals((Object)this.typeArguments.get("Id").dotName())) {
                joiner.add(OBJECT.descriptor());
                continue;
            }
            joiner.add(this.mapType(parameter));
        }
    }

    private String mapType(Type parameter) {
        String descriptor;
        switch (parameter.kind()) {
            case PRIMITIVE: 
            case TYPE_VARIABLE: {
                descriptor = OBJECT.descriptor();
                break;
            }
            default: {
                String value = AsmUtil.getDescriptor((Type)parameter, this.argMapper);
                descriptor = this.erasures.getOrDefault(value, value);
            }
        }
        return descriptor;
    }

    protected void addNullityChecks(MethodVisitor mv, List<Type> parameters) {
        for (int i = 0; i < parameters.size(); ++i) {
            Type parameter = parameters.get(i);
            if (!parameter.hasAnnotation(NOT_NULL.dotName())) continue;
            mv.visitVarInsn(25, i + 1);
            mv.visitLdcInsn((Object)parameter.name());
            mv.visitMethodInsn(184, "kotlin/jvm/internal/Intrinsics", "checkParameterIsNotNull", "(Ljava/lang/Object;Ljava/lang/String;)V", false);
        }
    }

    protected void loadOperationsReference(MethodVisitor mv) {
        mv.visitFieldInsn(178, this.typeBundle.operations().internalName(), "INSTANCE", this.typeBundle.operations().descriptor());
    }

    private boolean needsJvmBridge(MethodInfo method) {
        if (this.needsJvmBridge(method.returnType())) {
            return true;
        }
        for (Type paramType : method.parameters()) {
            if (!this.needsJvmBridge(paramType)) continue;
            return true;
        }
        return false;
    }

    private boolean needsJvmBridge(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE) {
            String typeParamName = type.asTypeVariable().identifier();
            return this.typeArguments.containsKey(typeParamName);
        }
        return false;
    }

    public String toString() {
        return new StringJoiner(", ", ((Object)((Object)this)).getClass().getSimpleName() + "[", "]").add(this.classInfo.name().toString()).toString();
    }

    public void visitEnd() {
        for (MethodInfo method : this.indexView.getClassByName(this.baseType.dotName()).methods()) {
            AnnotationInstance bridge;
            String descriptor = AsmUtil.getDescriptor((MethodInfo)method, type -> this.typeArguments.getOrDefault(type, OBJECT).descriptor());
            if (this.definedMethods.containsKey(method.name() + descriptor) || (bridge = method.annotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) == null) continue;
            bridge.value("targetReturnTypeErased");
            this.generate(method);
            if (!this.needsJvmBridge(method)) continue;
            String bridgeDescriptor = this.bridgeMethodDescriptor(method, type -> {
                ByteCodeType mapped = this.typeArguments.get(type);
                return mapped != null ? mapped.descriptor() : type;
            });
            if (this.definedMethods.containsKey(method.name() + bridgeDescriptor)) continue;
            this.generateBridge(method);
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodInfo methodInfo = this.definedMethods.entrySet().stream().filter(e -> ((String)e.getKey()).equals(name + descriptor)).map(e -> (MethodInfo)e.getValue()).findFirst().orElse(null);
        if (methodInfo != null && !methodInfo.hasAnnotation(PanacheEntityEnhancer.DOTNAME_GENERATE_BRIDGE)) {
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
        return null;
    }
}

