/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.reactivemessaging.runtime;

import io.quarkus.smallrye.reactivemessaging.runtime.DuplicatedContextConnectorFactory;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import java.util.Optional;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;

@Interceptor
@DuplicatedContextConnectorFactory
@Priority(value=5)
public class DuplicatedContextConnectorFactoryInterceptor {
    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        if (ctx.getMethod().getName().equals("getPublisherBuilder")) {
            PublisherBuilder result = (PublisherBuilder)ctx.proceed();
            return result.map(message -> {
                Context context;
                Optional metadata = message.getMetadata(LocalContextMetadata.class);
                if (metadata.isPresent() && (context = ((LocalContextMetadata)metadata.get()).context()) != null && VertxContext.isDuplicatedContext((Context)context)) {
                    VertxContextSafetyToggle.setContextSafe((Context)context, (boolean)true);
                }
                return message;
            });
        }
        return ctx.proceed();
    }
}

