/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jboss.resteasy.reactive.server.core.parameters.converters.DelegatingParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverterSupplier;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;

public class SortedSetConverter
implements ParameterConverter {
    private final ParameterConverter delegate;

    public SortedSetConverter(ParameterConverter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object convert(Object parameter) {
        if (parameter instanceof List) {
            TreeSet<Object> ret = new TreeSet<Object>();
            List values = (List)parameter;
            for (String val : values) {
                if (this.delegate == null) {
                    ret.add(val);
                    continue;
                }
                ret.add(this.delegate.convert(val));
            }
            return ret;
        }
        if (parameter == null) {
            return Collections.emptySortedSet();
        }
        if (this.delegate != null) {
            TreeSet<Object> ret = new TreeSet<Object>();
            ret.add(this.delegate.convert(parameter));
            return ret;
        }
        TreeSet<Object> ret = new TreeSet<Object>();
        ret.add(parameter);
        return ret;
    }

    @Override
    public void init(ParamConverterProviders deployment, Class<?> rawType, Type genericType, Annotation[] annotations) {
        this.delegate.init(deployment, rawType, genericType, annotations);
    }

    public static class SortedSetSupplier
    implements DelegatingParameterConverterSupplier {
        private ParameterConverterSupplier delegate;

        public SortedSetSupplier() {
        }

        public SortedSetSupplier(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public ParameterConverter get() {
            return this.delegate == null ? new SortedSetConverter(null) : new SortedSetConverter((ParameterConverter)this.delegate.get());
        }

        @Override
        public ParameterConverterSupplier getDelegate() {
            return this.delegate;
        }

        public SortedSetSupplier setDelegate(ParameterConverterSupplier delegate) {
            this.delegate = delegate;
            return this;
        }

        @Override
        public String getClassName() {
            return SortedSetConverter.class.getName();
        }
    }
}

