/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.streams.stages;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.streams.Engine;
import io.smallrye.mutiny.streams.operators.ProcessingStage;
import io.smallrye.mutiny.streams.operators.ProcessingStageFactory;
import io.smallrye.mutiny.streams.utils.CouplingProcessor;
import java.util.Objects;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.reactivestreams.Publisher;

public class CoupledStageFactory
implements ProcessingStageFactory<Stage.Coupled> {
    @Override
    public <I, O> ProcessingStage<I, O> create(Engine engine, Stage.Coupled stage) {
        Graph source = Objects.requireNonNull(stage.getPublisher());
        Graph sink = Objects.requireNonNull(stage.getSubscriber());
        Publisher publisher = engine.buildPublisher(source);
        SubscriberWithCompletionStage subscriber = engine.buildSubscriber(sink);
        return upstream -> Multi.createFrom().publisher(new CouplingProcessor(upstream, subscriber.getSubscriber(), publisher));
    }
}

