/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.reactivestreams.Subscription;

public class MultiRepeatUntilOp<T>
extends AbstractMultiOperator<T, T>
implements Multi<T> {
    private final Predicate<T> predicate;
    private final long times;
    private final Uni<?> delay;

    public MultiRepeatUntilOp(Multi<T> upstream, long times, Uni<?> delay) {
        super(upstream);
        this.times = times;
        this.predicate = x -> false;
        this.delay = delay;
    }

    public MultiRepeatUntilOp(Multi<T> upstream, Predicate<T> predicate, Uni<?> delay) {
        super(upstream);
        this.predicate = predicate;
        this.times = Long.MAX_VALUE;
        this.delay = delay;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        ParameterValidation.nonNullNpe(downstream, "downstream");
        RepeatUntilProcessor<? super T> processor = new RepeatUntilProcessor<T>(this.upstream, downstream, this.times != Long.MAX_VALUE ? this.times - 1L : Long.MAX_VALUE, this.predicate, this.delay);
        downstream.onSubscribe(processor);
        this.upstream.subscribe(processor);
    }

    static final class RepeatUntilProcessor<T>
    extends RepeatProcessor<T> {
        private boolean passed = true;

        public RepeatUntilProcessor(Multi<? extends T> upstream, MultiSubscriber<? super T> downstream, long times, Predicate<T> predicate, Uni<?> delay) {
            super(upstream, downstream, times, predicate, delay);
        }

        @Override
        public void onItem(T t) {
            try {
                this.passed = !this.predicate.test(t);
            }
            catch (Throwable failure) {
                this.cancel();
                this.downstream.onFailure(failure);
                return;
            }
            if (this.passed) {
                ++this.emitted;
                this.downstream.onNext(t);
            }
        }

        @Override
        public void onCompletion() {
            long r = this.remaining;
            if (r != Long.MAX_VALUE) {
                this.remaining = r - 1L;
            }
            if (r != 0L && this.passed) {
                this.subscribeNext();
            } else {
                this.downstream.onComplete();
            }
        }
    }

    public static abstract class RepeatProcessor<T>
    extends SwitchableSubscriptionSubscriber<T> {
        protected final Multi<? extends T> upstream;
        protected final Predicate<T> predicate;
        protected final AtomicInteger wip = new AtomicInteger();
        private final Uni<?> delay;
        protected long remaining;
        protected long emitted;

        public RepeatProcessor(Multi<? extends T> upstream, MultiSubscriber<? super T> downstream, long times, Predicate<T> predicate, Uni<?> delay) {
            super(downstream);
            this.upstream = upstream;
            this.predicate = predicate;
            this.remaining = times;
            this.delay = delay;
        }

        @Override
        public void onSubscribe(Subscription s) {
            this.setOrSwitchUpstream(s);
        }

        protected void subscribeNext() {
            if (this.delay == null) {
                this.drainLoop();
            } else {
                this.delay.subscribe().with(ignored -> this.drainLoop(), f -> {
                    this.cancel();
                    this.downstream.onFailure((Throwable)f);
                });
            }
        }

        private void drainLoop() {
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                while (!this.isCancelled()) {
                    long p = this.emitted;
                    if (p != 0L) {
                        this.emitted = 0L;
                        this.emitted(p);
                    }
                    this.upstream.subscribe(this);
                    if ((missed = this.wip.addAndGet(-missed)) != 0) continue;
                    break;
                }
            }
        }
    }
}

