/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.gdalframework;

import it.geosolutions.imageio.core.CoreCommonIIOStreamMetadata;
import it.geosolutions.imageio.core.GCP;
import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALImageReaderSpi;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.gdal.gdal.Band;
import org.gdal.gdal.Dataset;
import org.gdal.gdal.gdal;
import org.gdal.gdalconst.gdalconst;
import org.gdal.gdalconst.gdalconstConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GDALImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger(GDALImageReader.class.toString());
    private String[] datasetNames;
    private int nSubdatasets = -1;
    private ImageInputStream imageInputStream;
    private ImageTypeSpecifier imageType = null;
    private File datasetSource = null;
    private URI uriSource = null;
    private ConcurrentHashMap<String, GDALCommonIIOImageMetadata> datasetMetadataMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Dataset> datasetsMap = new ConcurrentHashMap();

    public GDALCommonIIOImageMetadata getDatasetMetadata(int imageIndex) {
        this.checkImageIndex(imageIndex);
        String datasetName = this.datasetNames[imageIndex];
        GDALCommonIIOImageMetadata retVal = this.datasetMetadataMap.get(datasetName);
        if (retVal == null) {
            GDALCommonIIOImageMetadata datasetMetadataNew;
            Dataset dsOld;
            Dataset ds = this.datasetsMap.get(datasetName);
            if (ds == null && (dsOld = this.datasetsMap.putIfAbsent(datasetName, ds = GDALUtilities.acquireDataSet(datasetName, gdalconst.GA_ReadOnly))) != null) {
                GDALUtilities.closeDataSet(ds);
                ds = dsOld;
            }
            if ((retVal = this.datasetMetadataMap.put(datasetName, datasetMetadataNew = this.createDatasetMetadata(ds, datasetName))) == null) {
                retVal = datasetMetadataNew;
            }
        }
        return retVal;
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public GDALImageReader(GDALImageReaderSpi originatingProvider, int numSubdatasets) {
        super(originatingProvider);
        if (numSubdatasets < 0) {
            throw new IllegalArgumentException("The provided number of sub datasets is invalid");
        }
        this.nSubdatasets = numSubdatasets;
    }

    protected void checkImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex > this.nSubdatasets) {
            int maxImageIndex = this.nSubdatasets;
            StringBuilder sb = new StringBuilder("Illegal imageIndex specified = ").append(imageIndex).append(", while the valid imageIndex");
            if (maxImageIndex > 0) {
                sb.append(" range should be (0,").append(maxImageIndex).append(")!!");
            } else {
                sb.append(" should be 0!");
            }
            throw new IndexOutOfBoundsException(sb.toString());
        }
    }

    protected GDALCommonIIOImageMetadata createDatasetMetadata(Dataset mainDataset, String mainDatasetFileName) {
        return new GDALCommonIIOImageMetadata(mainDataset, mainDatasetFileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster readDatasetRaster(GDALCommonIIOImageMetadata itemMetadata, Rectangle srcRegion, Rectangle dstRegion, int[] selectedBands, SampleModel destSampleModel) throws IOException {
        SampleModel destSm = destSampleModel != null ? destSampleModel : itemMetadata.getSampleModel();
        Dataset dataset = this.datasetsMap.get(itemMetadata.getDatasetName());
        if (dataset == null) {
            throw new IOException("Error while acquiring the input dataset " + itemMetadata.getDatasetName());
        }
        ComponentSampleModel sampleModel = null;
        DataBuffer imgBuffer = null;
        Band pBand = null;
        try {
            int dstWidth = dstRegion.width;
            int dstHeight = dstRegion.height;
            int srcRegionXOffset = srcRegion.x;
            int srcRegionYOffset = srcRegion.y;
            int srcRegionWidth = srcRegion.width;
            int srcRegionHeight = srcRegion.height;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("SourceRegion = " + srcRegion.toString());
            }
            int nBands = selectedBands != null ? selectedBands.length : destSm.getNumBands();
            int[] banks = new int[nBands];
            int[] offsets = new int[nBands];
            int pixels = dstWidth * dstHeight;
            int bufferType = 0;
            int bufferSize = 0;
            int typeSizeInBytes = 0;
            pBand = dataset.GetRasterBand(1);
            bufferType = pBand.getDataType();
            typeSizeInBytes = gdal.GetDataTypeSize((int)bufferType) / 8;
            bufferSize = nBands * pixels * typeSizeInBytes;
            boolean splitBands = false;
            if (bufferSize < 0 || destSm instanceof BandedSampleModel) {
                bufferSize = pixels * typeSizeInBytes;
                splitBands = true;
            }
            int dataBufferType = -1;
            byte[][] byteBands = new byte[nBands][];
            for (int k = 0; k < nBands && (k <= 0 || splitBands); ++k) {
                int returnVal;
                byte[] dataBuffer = new byte[bufferSize];
                if (!splitBands) {
                    int i;
                    int[] bandsMap = new int[nBands];
                    if (selectedBands != null) {
                        for (i = 0; i < nBands; ++i) {
                            bandsMap[i] = selectedBands[i] + 1;
                        }
                    } else {
                        for (i = 0; i < nBands; ++i) {
                            bandsMap[i] = i + 1;
                        }
                    }
                    returnVal = dataset.ReadRaster(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, dataBuffer, bandsMap, nBands * typeSizeInBytes, dstWidth * nBands * typeSizeInBytes, typeSizeInBytes);
                    byteBands[k] = dataBuffer;
                } else {
                    Band rBand = null;
                    try {
                        rBand = dataset.GetRasterBand(k + 1);
                        returnVal = rBand.ReadRaster(srcRegionXOffset, srcRegionYOffset, srcRegionWidth, srcRegionHeight, dstWidth, dstHeight, bufferType, dataBuffer);
                        byteBands[k] = dataBuffer;
                    }
                    finally {
                        block53: {
                            if (rBand != null) {
                                try {
                                    rBand.delete();
                                }
                                catch (Throwable e) {
                                    if (!LOGGER.isLoggable(Level.FINEST)) break block53;
                                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                                }
                            }
                        }
                    }
                }
                if (returnVal == gdalconstConstants.CE_None) {
                    if (!splitBands) {
                        for (int band = 0; band < nBands; ++band) {
                            banks[band] = band;
                            offsets[band] = band;
                        }
                        continue;
                    }
                    banks[k] = k;
                    offsets[k] = 0;
                    continue;
                }
                LOGGER.info("Last error: " + gdal.GetLastErrorMsg());
                LOGGER.info("Last error number: " + gdal.GetLastErrorNo());
                LOGGER.info("Last error type: " + gdal.GetLastErrorType());
                throw new RuntimeException(gdal.GetLastErrorMsg());
            }
            if (bufferType == gdalconstConstants.GDT_Byte) {
                imgBuffer = !splitBands ? new DataBufferByte(byteBands[0], nBands * pixels) : new DataBufferByte(byteBands, pixels);
                dataBufferType = 0;
            } else {
                int i;
                ByteBuffer[] bands = new ByteBuffer[nBands];
                for (int k = 0; splitBands && k < nBands || k < 1 && !splitBands; ++k) {
                    bands[k] = ByteBuffer.wrap(byteBands[k], 0, byteBands[k].length);
                }
                if (bufferType == gdalconstConstants.GDT_Int16 || bufferType == gdalconstConstants.GDT_UInt16) {
                    if (!splitBands) {
                        short[] shorts = new short[nBands * pixels];
                        bands[0].order(ByteOrder.nativeOrder());
                        ShortBuffer buff = bands[0].asShortBuffer();
                        buff.get(shorts, 0, nBands * pixels);
                        imgBuffer = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, nBands * pixels) : new DataBufferUShort(shorts, nBands * pixels);
                    } else {
                        short[][] shorts = new short[nBands][];
                        for (i = 0; i < nBands; ++i) {
                            shorts[i] = new short[pixels];
                            bands[i].order(ByteOrder.nativeOrder());
                            bands[i].asShortBuffer().get(shorts[i], 0, pixels);
                        }
                        imgBuffer = bufferType == gdalconstConstants.GDT_Int16 ? new DataBufferShort(shorts, pixels) : new DataBufferUShort(shorts, pixels);
                    }
                    dataBufferType = bufferType == gdalconstConstants.GDT_UInt16 ? 1 : 2;
                } else if (bufferType == gdalconstConstants.GDT_Int32 || bufferType == gdalconstConstants.GDT_UInt32) {
                    if (!splitBands) {
                        int[] ints = new int[nBands * pixels];
                        bands[0].order(ByteOrder.nativeOrder());
                        IntBuffer buff = bands[0].asIntBuffer();
                        buff.get(ints, 0, nBands * pixels);
                        imgBuffer = new DataBufferInt(ints, nBands * pixels);
                    } else {
                        int[][] ints = new int[nBands][];
                        for (i = 0; i < nBands; ++i) {
                            ints[i] = new int[pixels];
                            bands[i].order(ByteOrder.nativeOrder());
                            bands[i].asIntBuffer().get(ints[i], 0, pixels);
                        }
                        imgBuffer = new DataBufferInt(ints, pixels);
                    }
                    dataBufferType = 3;
                } else if (bufferType == gdalconstConstants.GDT_Float32) {
                    if (!splitBands) {
                        float[] floats = new float[nBands * pixels];
                        bands[0].order(ByteOrder.nativeOrder());
                        FloatBuffer buff = bands[0].asFloatBuffer();
                        buff.get(floats, 0, nBands * pixels);
                        imgBuffer = new DataBufferFloat(floats, nBands * pixels);
                    } else {
                        float[][] floats = new float[nBands][];
                        for (i = 0; i < nBands; ++i) {
                            floats[i] = new float[pixels];
                            bands[i].order(ByteOrder.nativeOrder());
                            bands[i].asFloatBuffer().get(floats[i], 0, pixels);
                        }
                        imgBuffer = new DataBufferFloat(floats, pixels);
                    }
                    dataBufferType = 4;
                } else if (bufferType == gdalconstConstants.GDT_Float64) {
                    if (!splitBands) {
                        double[] doubles = new double[nBands * pixels];
                        bands[0].order(ByteOrder.nativeOrder());
                        DoubleBuffer buff = bands[0].asDoubleBuffer();
                        buff.get(doubles, 0, nBands * pixels);
                        imgBuffer = new DataBufferDouble(doubles, nBands * pixels);
                    } else {
                        double[][] doubles = new double[nBands][];
                        for (i = 0; i < nBands; ++i) {
                            doubles[i] = new double[pixels];
                            bands[i].order(ByteOrder.nativeOrder());
                            bands[i].asDoubleBuffer().get(doubles[i], 0, pixels);
                        }
                        imgBuffer = new DataBufferDouble(doubles, pixels);
                    }
                    dataBufferType = 5;
                } else {
                    LOGGER.info("The specified data type is actually unsupported: " + bufferType);
                }
            }
            sampleModel = splitBands ? new BandedSampleModel(dataBufferType, dstWidth, dstHeight, dstWidth, banks, offsets) : new PixelInterleavedSampleModel(dataBufferType, dstWidth, dstHeight, nBands, dstWidth * nBands, offsets);
        }
        finally {
            block55: {
                if (pBand != null) {
                    try {
                        pBand.delete();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block55;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return Raster.createWritableRaster(sampleModel, imgBuffer, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getDatasetSource(Object myInput) {
        if (this.datasetSource != null) return this.datasetSource;
        if (myInput instanceof File) {
            this.datasetSource = (File)myInput;
            return this.datasetSource;
        } else if (myInput instanceof FileImageInputStreamExt) {
            this.datasetSource = ((FileImageInputStreamExt)myInput).getFile();
            return this.datasetSource;
        } else {
            if (!(this.input instanceof URL)) throw new RuntimeException("Unable to retrieve the Data Source for the provided input");
            URL tempURL = (URL)this.input;
            if (!tempURL.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("Not a supported Input");
            this.datasetSource = Utilities.urlToFile((URL)tempURL);
        }
        return this.datasetSource;
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        Vector subdatasets;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting Input");
        }
        if (input == null) {
            throw new IllegalArgumentException("The provided input is null!");
        }
        if (!GDALUtilities.isGDALAvailable()) {
            throw new IllegalStateException("GDAL native libraries are not available.");
        }
        if (this.imageInputStream != null) {
            this.reset();
            this.imageInputStream = null;
        }
        if (input instanceof File) {
            this.datasetSource = (File)input;
            try {
                this.imageInputStream = ImageIO.createImageInputStream(input);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create a valid input stream ", e);
            }
        } else if (input instanceof FileImageInputStreamExt) {
            this.datasetSource = ((FileImageInputStreamExt)input).getFile();
            this.imageInputStream = (ImageInputStream)input;
        } else if (input instanceof URL) {
            URL tempURL = (URL)input;
            if (tempURL.getProtocol().equalsIgnoreCase("file")) {
                try {
                    this.datasetSource = ImageIOUtilities.urlToFile((URL)tempURL);
                    this.imageInputStream = ImageIO.createImageInputStream(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create a valid input stream ", e);
                }
            }
        } else if (input instanceof URIImageInputStream) {
            this.imageInputStream = (URIImageInputStream)input;
            this.datasetSource = null;
            this.uriSource = ((URIImageInputStream)input).getUri();
        }
        boolean isInputDecodable = false;
        String mainDatasetName = null;
        Dataset mainDataSet = null;
        if (this.imageInputStream != null) {
            if (this.datasetSource != null) {
                mainDatasetName = this.datasetSource.getAbsolutePath();
                mainDataSet = GDALUtilities.acquireDataSet(this.datasetSource.getAbsolutePath(), gdalconstConstants.GA_ReadOnly);
            } else if (this.uriSource != null) {
                String urisource;
                mainDatasetName = urisource = this.uriSource.toString();
                mainDataSet = GDALUtilities.acquireDataSet(urisource, gdalconstConstants.GA_ReadOnly);
            }
            isInputDecodable = mainDataSet != null ? ((GDALImageReaderSpi)this.getOriginatingProvider()).isDecodable(mainDataSet) : false;
        }
        if (isInputDecodable) {
            this.datasetsMap.put(mainDatasetName, mainDataSet);
            super.setInput(this.imageInputStream, seekForwardOnly, ignoreMetadata);
            subdatasets = mainDataSet.GetMetadata_List("SUBDATASETS");
            this.nSubdatasets = subdatasets.size() / 2;
            if (this.nSubdatasets == 0) {
                this.nSubdatasets = 1;
                this.datasetNames = new String[1];
                this.datasetNames[0] = mainDatasetName;
                this.datasetMetadataMap.put(this.datasetNames[0], this.createDatasetMetadata(mainDataSet, this.datasetNames[0]));
            } else {
                this.datasetNames = new String[this.nSubdatasets + 1];
                for (int i = 0; i < this.nSubdatasets; ++i) {
                    String subdatasetName = ((String)subdatasets.get(i * 2)).toString();
                    int nameStartAt = subdatasetName.lastIndexOf("_NAME=") + 6;
                    this.datasetNames[i] = subdatasetName.substring(nameStartAt);
                }
                this.datasetNames[this.nSubdatasets] = mainDatasetName;
                this.datasetMetadataMap.put(this.datasetNames[this.nSubdatasets], this.createDatasetMetadata(mainDataSet, this.datasetNames[this.nSubdatasets]));
            }
        } else {
            StringBuilder sb = new StringBuilder();
            if (this.imageInputStream == null) {
                sb.append("Unable to create a valid ImageInputStream for the provided input:");
                sb.append(GDALUtilities.NEWLINE);
                sb.append(input.toString());
            } else {
                sb.append("The Provided input is not supported by this reader");
            }
            throw new RuntimeException(sb.toString());
        }
        subdatasets.clear();
    }

    @Override
    public void dispose() {
        block4: {
            super.dispose();
            if (this.imageInputStream != null) {
                try {
                    this.imageInputStream.close();
                }
                catch (IOException ioe) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block4;
                    LOGGER.log(Level.FINE, ioe.getLocalizedMessage(), ioe);
                }
            }
        }
        this.imageInputStream = null;
        this.datasetMetadataMap.clear();
        this.datasetNames = null;
        Set<Map.Entry<String, Dataset>> elements = this.datasetsMap.entrySet();
        for (Map.Entry<String, Dataset> e : elements) {
            GDALUtilities.closeDataSet(e.getValue());
        }
    }

    @Override
    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
        this.nSubdatasets = -1;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(4);
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        this.imageType = new ImageTypeSpecifier(item.getColorModel(), item.getSampleModel());
        l.add(this.imageType);
        return l.iterator();
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        EnhancedImageReadParam eparam;
        Rectangle dstRegion;
        int nDestBands;
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        int width = item.getWidth();
        int height = item.getHeight();
        SampleModel itemSampleModel = item.getSampleModel();
        int itemNBands = itemSampleModel.getNumBands();
        BufferedImage bi = null;
        ImageReadParam imageReadParam = param == null ? this.getDefaultReadParam() : param;
        ImageTypeSpecifier imageType = imageReadParam.getDestinationType();
        SampleModel destSampleModel = null;
        if (imageType != null) {
            destSampleModel = imageType.getSampleModel();
            nDestBands = destSampleModel.getNumBands();
        } else {
            bi = imageReadParam.getDestination();
            nDestBands = bi != null ? bi.getSampleModel().getNumBands() : itemNBands;
        }
        GDALImageReader.checkReadParamBandSettings(imageReadParam, itemNBands, nDestBands);
        int[] srcBands = imageReadParam.getSourceBands();
        Rectangle srcRegion = new Rectangle(0, 0, 0, 0);
        Rectangle destRegion = new Rectangle(0, 0, 0, 0);
        GDALImageReader.computeRegions(imageReadParam, width, height, bi, srcRegion, destRegion);
        if (imageReadParam != null && imageReadParam instanceof EnhancedImageReadParam && (dstRegion = (eparam = (EnhancedImageReadParam)imageReadParam).getDestinationRegion()) != null) {
            destRegion.height = dstRegion.height;
            destRegion.width = dstRegion.width;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Source Region = " + srcRegion.toString());
            LOGGER.fine("Destination Region = " + destRegion.toString());
        }
        if (bi == null) {
            ColorModel cm;
            if (imageType == null) {
                cm = item.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands, null), false, null);
            } else {
                cm = imageType.getColorModel();
                bi = new BufferedImage(cm, (WritableRaster)this.readDatasetRaster(item, srcRegion, destRegion, srcBands, destSampleModel), false, null);
            }
        } else {
            Raster readRaster = this.readDatasetRaster(item, srcRegion, destRegion, srcBands, null);
            WritableRaster raster = bi.getRaster().createWritableChild(0, 0, bi.getWidth(), bi.getHeight(), 0, 0, null);
            raster.setRect(destRegion.x, destRegion.y, readRaster);
        }
        return bi;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        return this.read(imageIndex, param).getData();
    }

    @Override
    public BufferedImage read(int imageIndex) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("read(imageIndex)");
        }
        return this.read(imageIndex, null);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getting NumImages");
        }
        return this.nSubdatasets;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getHeight();
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileHeight();
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex).getTileWidth();
    }

    public String getProjection(int imageIndex) {
        return this.getDatasetMetadata(imageIndex).getProjection();
    }

    public double[] getGeoTransform(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGeoTransformation();
    }

    public List<? extends GCP> getGCPs(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGCPs();
    }

    public String getGCPProjection(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpProjection();
    }

    public int getGCPCount(int imageIndex) {
        this.checkImageIndex(imageIndex);
        return this.getDatasetMetadata(imageIndex).getGcpNumber();
    }

    public double getNoDataValue(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getNoDataValue(band);
    }

    public double getOffset(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getOffset(band);
    }

    public double getScale(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getScale(band);
    }

    public double getMinimum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMinimum(band);
    }

    public double getMaximum(int imageIndex, int band) {
        GDALCommonIIOImageMetadata item = this.getDatasetMetadata(imageIndex);
        return item.getMaximum(band);
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return new CoreCommonIIOStreamMetadata(this.datasetNames);
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return this.getDatasetMetadata(imageIndex);
    }
}

