/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.guerlab.loadbalancer.AbstractLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;

public class SmoothWeightRoundRobinLoadBalancer<T, C>
extends AbstractLoadBalancer<T, C> {
    private final Map<T, Integer> originWeightMap = new ConcurrentHashMap<T, Integer>();
    private final Map<T, Integer> currentWeightMap = new ConcurrentHashMap<T, Integer>();
    private final Lock lock = new ReentrantLock();

    public SmoothWeightRoundRobinLoadBalancer() {
    }

    public SmoothWeightRoundRobinLoadBalancer(List<TargetWrapper<T>> targetList) {
        super(targetList);
    }

    @Override
    protected void afterAdd(TargetWrapper<T> wrapper) {
        this.originWeightMap.put(wrapper.getTarget(), 1);
        this.currentWeightMap.put(wrapper.getTarget(), 1);
    }

    @Override
    protected void afterRemove(TargetWrapper<T> wrapper) {
        this.originWeightMap.remove(wrapper.getTarget());
        this.currentWeightMap.remove(wrapper.getTarget());
    }

    @Override
    public void setWeight(T target, int weight) {
        if (target == null) {
            return;
        }
        this.originWeightMap.put(target, Math.max(weight, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T choose0(List<TargetWrapper<T>> activeTargetList, C chooseReferenceObject) {
        this.lock.lock();
        try {
            Iterator<TargetWrapper<T>> iterator;
            int currentWeight;
            int originWeight;
            int originWeightSum = 0;
            int currentMaxWeight = Integer.MIN_VALUE;
            TargetWrapper<T> currentMaxWeightWrapper = null;
            for (TargetWrapper<T> wrapper : activeTargetList) {
                originWeight = this.originWeightMap.getOrDefault(wrapper.getTarget(), 1);
                currentWeight = this.currentWeightMap.getOrDefault(wrapper.getTarget(), originWeight);
                originWeightSum += originWeight;
                if (currentWeight <= currentMaxWeight) continue;
                currentMaxWeight = currentWeight;
                currentMaxWeightWrapper = wrapper;
            }
            if (currentMaxWeightWrapper == null) {
                iterator = null;
                return (T)iterator;
            }
            this.currentWeightMap.put(currentMaxWeightWrapper.getTarget(), currentMaxWeight - originWeightSum);
            for (TargetWrapper<T> wrapper : activeTargetList) {
                originWeight = this.originWeightMap.getOrDefault(wrapper.getTarget(), 1);
                currentWeight = this.currentWeightMap.getOrDefault(wrapper.getTarget(), 1);
                this.currentWeightMap.put(wrapper.getTarget(), currentWeight + originWeight);
            }
            iterator = currentMaxWeightWrapper.getTarget();
            return (T)iterator;
        }
        finally {
            this.lock.unlock();
        }
    }
}

