/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.guerlab.loadbalancer.AbstractLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;

public class WeightRandomLoadBalancer<T, C>
extends AbstractLoadBalancer<T, C> {
    private final Map<T, Integer> weightMap = new ConcurrentHashMap<T, Integer>();

    public WeightRandomLoadBalancer() {
    }

    public WeightRandomLoadBalancer(List<TargetWrapper<T>> targetList) {
        super(targetList);
    }

    @Override
    protected void afterAdd(TargetWrapper<T> wrapper) {
        this.weightMap.put(wrapper.getTarget(), 1);
    }

    @Override
    protected void afterRemove(TargetWrapper<T> wrapper) {
        this.weightMap.remove(wrapper.getTarget());
    }

    @Override
    public void setWeight(T target, int weight) {
        if (target == null) {
            return;
        }
        this.weightMap.put(target, Math.max(weight, 1));
    }

    @Override
    protected T choose0(List<TargetWrapper<T>> activeTargetList, C chooseReferenceObject) {
        ArrayList<TargetWrapper<T>> targetList = new ArrayList<TargetWrapper<T>>();
        for (TargetWrapper<T> wrapper : activeTargetList) {
            int weight = this.weightMap.getOrDefault(wrapper.getTarget(), 1);
            for (int i = 0; i < weight; ++i) {
                targetList.add(wrapper);
            }
        }
        TargetWrapper wrapper = (TargetWrapper)targetList.get(new Random().nextInt(targetList.size()));
        return wrapper == null ? null : (T)wrapper.getTarget();
    }
}

