/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;

public class ClassExpressionTranslator
extends OWLEntityTranslator<OWLClass, ConceptExpression>
implements OWLClassExpressionVisitorEx<ConceptExpression> {
    private static final long serialVersionUID = 11000L;

    public ClassExpressionTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr) {
        super(em, df, tr);
    }

    @Override
    protected ConceptExpression getTopEntityPointer() {
        return ExpressionManager.top();
    }

    @Override
    protected ConceptExpression getBottomEntityPointer() {
        return ExpressionManager.bottom();
    }

    @Override
    protected OWLClass getTopEntity() {
        return this.df.getOWLThing();
    }

    @Override
    protected OWLClass getBottomEntity() {
        return this.df.getOWLNothing();
    }

    @Override
    protected ConceptExpression createPointerForEntity(OWLClass entity) {
        return this.em.concept(entity.getIRI());
    }

    @Override
    protected DefaultNode<OWLClass> createDefaultNode() {
        return new OWLClassNode();
    }

    @Override
    protected DefaultNodeSet<OWLClass> createDefaultNodeSet() {
        return new OWLClassNodeSet();
    }

    public ConceptExpression visit(OWLClass desc) {
        return (ConceptExpression)this.getPointerFromEntity(desc);
    }

    public ConceptExpression visit(OWLObjectIntersectionOf desc) {
        return ExpressionManager.and(this.translateClassExpressionSet(desc.getOperands()));
    }

    private List<ConceptExpression> translateClassExpressionSet(Set<OWLClassExpression> classExpressions) {
        ArrayList<ConceptExpression> l = new ArrayList<ConceptExpression>();
        for (OWLClassExpression ce : classExpressions) {
            l.add((ConceptExpression)ce.accept((OWLClassExpressionVisitorEx)this));
        }
        return l;
    }

    public ConceptExpression visit(OWLObjectUnionOf desc) {
        return ExpressionManager.or(this.translateClassExpressionSet(desc.getOperands()));
    }

    public ConceptExpression visit(OWLObjectComplementOf desc) {
        return ExpressionManager.not((ConceptExpression)desc.getOperand().accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectSomeValuesFrom desc) {
        return ExpressionManager.exists(this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectAllValuesFrom desc) {
        return ExpressionManager.forall(this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectHasValue desc) {
        return ExpressionManager.value(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLIndividual)desc.getFiller()));
    }

    public ConceptExpression visit(OWLObjectMinCardinality desc) {
        return ExpressionManager.minCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectExactCardinality desc) {
        return ExpressionManager.cardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectMaxCardinality desc) {
        return ExpressionManager.maxCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), (ConceptExpression)((OWLClassExpression)desc.getFiller()).accept((OWLClassExpressionVisitorEx)this));
    }

    public ConceptExpression visit(OWLObjectHasSelf desc) {
        return ExpressionManager.selfReference(this.tr.pointer(desc.getProperty()));
    }

    public ConceptExpression visit(OWLObjectOneOf desc) {
        return this.em.oneOf(this.tr.translate(desc.getIndividuals()));
    }

    public ConceptExpression visit(OWLDataSomeValuesFrom desc) {
        return ExpressionManager.exists(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataAllValuesFrom desc) {
        return ExpressionManager.forall(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataHasValue desc) {
        return ExpressionManager.value(this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLLiteral)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataMinCardinality desc) {
        return ExpressionManager.minCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataExactCardinality desc) {
        return ExpressionManager.cardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }

    public ConceptExpression visit(OWLDataMaxCardinality desc) {
        return ExpressionManager.maxCardinality(desc.getCardinality(), this.tr.pointer(desc.getProperty()), this.tr.pointer((OWLDataRange)desc.getFiller()));
    }
}

