/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataRangeVisitorEx;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.reasoner.impl.DefaultNode;
import org.semanticweb.owlapi.reasoner.impl.DefaultNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNode;
import org.semanticweb.owlapi.reasoner.impl.OWLDatatypeNodeSet;
import uk.ac.manchester.cs.jfact.OWLEntityTranslator;
import uk.ac.manchester.cs.jfact.TranslationMachinery;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataExpression;

public class DataRangeTranslator
extends OWLEntityTranslator<OWLDatatype, DataExpression>
implements OWLDataRangeVisitorEx<DataExpression> {
    private static final long serialVersionUID = 11000L;
    private final DatatypeFactory f;

    public DataRangeTranslator(ExpressionCache em, OWLDataFactory df, TranslationMachinery tr, DatatypeFactory f) {
        super(em, df, tr);
        this.f = f;
    }

    @Override
    protected DataExpression getTopEntityPointer() {
        return ExpressionManager.dataTop();
    }

    @Override
    protected DataExpression getBottomEntityPointer() {
        return null;
    }

    @Override
    protected DefaultNode<OWLDatatype> createDefaultNode() {
        return new OWLDatatypeNode();
    }

    @Override
    protected OWLDatatype getTopEntity() {
        return this.df.getTopDatatype();
    }

    @Override
    protected OWLDatatype getBottomEntity() {
        return null;
    }

    @Override
    protected DefaultNodeSet<OWLDatatype> createDefaultNodeSet() {
        return new OWLDatatypeNodeSet();
    }

    @Override
    protected DataExpression createPointerForEntity(OWLDatatype entity) {
        return this.f.getKnownDatatype(entity.getIRI());
    }

    public Datatype<?> visit(OWLDatatype node) {
        return this.f.getKnownDatatype(node.getIRI());
    }

    public DataExpression visit(OWLDataOneOf node) {
        ArrayList l = new ArrayList();
        for (OWLLiteral literal : node.getValues()) {
            l.add(this.tr.pointer(literal));
        }
        return ExpressionManager.dataOneOf(l);
    }

    public DataExpression visit(OWLDataComplementOf node) {
        return ExpressionManager.dataNot((DataExpression)node.getDataRange().accept((OWLDataRangeVisitorEx)this));
    }

    public DataExpression visit(OWLDataIntersectionOf node) {
        return ExpressionManager.dataAnd(this.translateDataRangeSet(node.getOperands()));
    }

    private List<DataExpression> translateDataRangeSet(Set<OWLDataRange> dataRanges) {
        ArrayList<DataExpression> l = new ArrayList<DataExpression>();
        for (OWLDataRange op : dataRanges) {
            l.add((DataExpression)op.accept((OWLDataRangeVisitorEx)this));
        }
        return l;
    }

    public DataExpression visit(OWLDataUnionOf node) {
        return ExpressionManager.dataOr(this.translateDataRangeSet(node.getOperands()));
    }

    public DataExpression visit(OWLDatatypeRestriction node) {
        Datatype<?> type = this.f.getKnownDatatype(node.getDatatype().getIRI());
        Set facetRestrictions = node.getFacetRestrictions();
        if (facetRestrictions.isEmpty()) {
            return type;
        }
        DatatypeExpression<?> toReturn = null;
        toReturn = type.isNumericDatatype() ? DatatypeFactory.getNumericDatatypeExpression(type.asNumericDatatype()) : (type.isOrderedDatatype() ? DatatypeFactory.getOrderedDatatypeExpression(type) : DatatypeFactory.getDatatypeExpression(type));
        for (OWLFacetRestriction restriction : facetRestrictions) {
            Literal<?> dv = this.tr.pointer(restriction.getFacetValue());
            Facet facet = Facets.parse(restriction.getFacet());
            if (facet.isNumberFacet()) {
                toReturn = toReturn.addNumericFacet(facet, (Comparable<?>)dv.typedValue());
                continue;
            }
            toReturn = toReturn.addNonNumericFacet(facet, (Comparable<?>)dv.typedValue());
        }
        return toReturn;
    }
}

