/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.LiteralImpl;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.NumericLiteralImpl;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.cardinality;
import uk.ac.manchester.cs.jfact.datatypes.ordered;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitor;
import uk.ac.manchester.cs.jfact.visitors.DLExpressionVisitorEx;

public abstract class ABSTRACT_DATATYPE<R extends Comparable<R>>
implements Datatype<R>,
Serializable {
    private static final long serialVersionUID = 11000L;
    @Nonnull
    protected final Set<Facet> facets;
    @Nonnull
    protected final Set<Datatype<?>> ancestors;
    protected final Map<Facet, Comparable> knownNumericFacetValues = new HashMap<Facet, Comparable>();
    protected final Map<Facet, Comparable> knownNonNumericFacetValues = new HashMap<Facet, Comparable>();
    @Nonnull
    protected final IRI uri;

    @Nonnull
    protected static <O extends Comparable<O>> Datatype<O> host(Datatype<O> o) {
        if (o.isExpression()) {
            return o.asExpression().getHostType();
        }
        return o;
    }

    public ABSTRACT_DATATYPE(@Nonnull IRI u, @Nonnull Set<Facet> f, @Nonnull Set<Datatype<?>> ancestors) {
        this.facets = f;
        this.uri = u;
        this.ancestors = ancestors;
    }

    @Override
    public IRI getDatatypeIRI() {
        return this.uri;
    }

    @Override
    public IRI getName() {
        return IRI.create((String)this.toString());
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Datatype) {
            return this.uri.equals((Object)((Datatype)obj).getDatatypeIRI());
        }
        return false;
    }

    @Override
    public Collection<Datatype<?>> getAncestors() {
        return this.ancestors;
    }

    @Override
    public Set<Facet> getFacets() {
        return this.facets;
    }

    @Override
    public Map<Facet, Comparable> getKnownNumericFacetValues() {
        return this.knownNumericFacetValues;
    }

    @Override
    public Map<Facet, Comparable> getKnownNonNumericFacetValues() {
        return this.knownNonNumericFacetValues;
    }

    @Override
    public Comparable getFacetValue(Facet f) {
        if (f.isNumberFacet()) {
            return this.getNumericFacetValue(f);
        }
        return this.knownNonNumericFacetValues.get(f);
    }

    @Override
    public Comparable getNumericFacetValue(Facet f) {
        return this.knownNumericFacetValues.get(f);
    }

    @Override
    public boolean isSubType(Datatype<?> type) {
        return this.ancestors.contains(type) || this.equals(type);
    }

    @Nonnull
    public String toString() {
        return this.getDatatypeIRI().getShortForm();
    }

    @Override
    public boolean isCompatible(Datatype<?> type) {
        if (type.isExpression()) {
            type = type.asExpression().getHostType();
        }
        return type.equals(this) || type.equals(DatatypeFactory.LITERAL) || type.isSubType(this) || this.isSubType(type);
    }

    @Override
    public boolean isCompatible(Literal<?> l) {
        if (!this.isCompatible(l.getDatatypeExpression())) {
            return false;
        }
        try {
            Object value = this.parseValue(l.value());
            return this.isInValueSpace(value);
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isContradictory(Datatype<?> type) {
        return !this.isCompatible(type);
    }

    @Override
    public boolean isInValueSpace(R l) {
        return true;
    }

    @Override
    public void accept(DLExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(DLExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public DatatypeExpression<R> asExpression() {
        if (!this.isExpression()) {
            throw new UnsupportedOperationException("Type: " + this.getDatatypeIRI() + " is not an expression");
        }
        return (DatatypeExpression)((Object)this);
    }

    @Override
    public Literal<R> buildLiteral(String s) {
        if (this.getNumeric()) {
            return new NumericLiteralImpl<R>(this.asNumericDatatype(), s);
        }
        return new LiteralImpl(this, s);
    }

    @Override
    public Collection<Literal<R>> listValues() {
        return Collections.emptyList();
    }

    @Override
    public boolean getBounded() {
        return false;
    }

    @Override
    public boolean getNumeric() {
        return false;
    }

    @Override
    public ordered getOrdered() {
        return ordered.FALSE;
    }

    @Override
    public cardinality getCardinality() {
        return cardinality.COUNTABLYINFINITE;
    }

    protected <T extends Comparable<T>> boolean overlapping(OrderedDatatype<T> first, OrderedDatatype<T> second) {
        T max = first.getMax();
        T min = second.getMin();
        if (first.hasMaxInclusive() && second.hasMinInclusive()) {
            return max.compareTo(min) >= 0;
        }
        if (first.hasMaxExclusive() && second.hasMinInclusive()) {
            return max.compareTo(min) > 0;
        }
        return false;
    }

    @Override
    public boolean isNumericDatatype() {
        return false;
    }

    @Override
    public NumericDatatype<R> asNumericDatatype() {
        throw new ReasonerInternalException(this + " is not a numeric datatype");
    }

    @Override
    public boolean isOrderedDatatype() {
        return false;
    }

    @Override
    public OrderedDatatype<R> asOrderedDatatype() {
        throw new ReasonerInternalException(this + " is not an ordered datatype");
    }

    @Override
    public boolean emptyValueSpace() {
        return false;
    }
}

