/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.jfact.datatypes.DataTypeReasoner;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeClashes;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeEnumeration;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeNegation;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.dep.DepSet;

public class DataTypeSituation<R extends Comparable<R>>
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private DepSet pType;
    private DepSet nType;
    private Set<DepInterval<R>> constraints = new HashSet<DepInterval<R>>();
    private final DepSet accDep = DepSet.create();
    private final DataTypeReasoner reasoner;
    @Nonnull
    private final Datatype<R> type;
    private final List<Literal<?>> literals = new ArrayList();

    protected DataTypeSituation(@Nonnull Datatype<R> p, @Nonnull DataTypeReasoner dep) {
        this.type = (Datatype)OWLAPIPreconditions.checkNotNull(p);
        this.reasoner = dep;
        this.constraints.add(new DepInterval());
    }

    private boolean addUpdatedInterval(DepInterval<R> i, Datatype<R> interval, DepSet localDep) {
        if (!i.consistent(interval)) {
            localDep.add(i.locDep);
            this.reasoner.reportClash(localDep, DatatypeClashes.DT_C_IT);
            return true;
        }
        if (!i.update(interval, localDep)) {
            this.constraints.add(i);
        }
        if (!this.hasPType()) {
            this.constraints.add(i);
        }
        if (!i.checkMinMaxClash()) {
            this.constraints.add(i);
        } else {
            this.accDep.add(i.locDep);
        }
        return false;
    }

    @Nonnull
    public Datatype<?> getType() {
        return this.type;
    }

    public boolean addInterval(boolean pos, Datatype<R> interval, DepSet dep) {
        if (interval.emptyValueSpace()) {
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_Empty_interval);
            return true;
        }
        if (interval instanceof DatatypeEnumeration) {
            this.literals.addAll(interval.listValues());
        }
        DatatypeNegation realInterval = pos ? interval : new DatatypeNegation(interval);
        Set<DepInterval<R>> c = this.constraints;
        this.constraints = new HashSet<DepInterval<R>>();
        for (DepInterval<R> d : c) {
            if (!this.addUpdatedInterval(d, realInterval, DepSet.create(dep))) continue;
            return true;
        }
        if (this.constraints.isEmpty()) {
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_C_MM);
            return true;
        }
        return false;
    }

    public boolean checkPNTypeClash() {
        if (this.hasNType() && this.hasPType() && this.getNType().equals(this.getPType())) {
            this.reasoner.reportClash(this.pType, this.nType, DatatypeClashes.DT_TNT);
            return true;
        }
        for (DepInterval<R> d : this.constraints) {
            boolean checkMinMaxClash = d.checkMinMaxClash();
            if (!checkMinMaxClash) continue;
            d.checkMinMaxClash();
            this.accDep.add(d.locDep);
            this.reasoner.reportClash(this.accDep, DatatypeClashes.DT_C_MM);
            return checkMinMaxClash;
        }
        return false;
    }

    private boolean emptyConstraints() {
        return this.constraints.isEmpty() || this.constraints.iterator().next().e == null;
    }

    public boolean checkCompatibleValue(DataTypeSituation<?> other) {
        if (this.type.equals(DatatypeFactory.LITERAL) && this.emptyConstraints() || other.type.equals(DatatypeFactory.LITERAL) && super.emptyConstraints()) {
            return true;
        }
        if (!this.type.isCompatible(other.type)) {
            return false;
        }
        if (this.emptyConstraints() && super.emptyConstraints()) {
            return true;
        }
        if (other.literals.isEmpty() && super.emptyConstraints()) {
            return true;
        }
        if (this.literals.isEmpty() && this.emptyConstraints()) {
            return true;
        }
        ArrayList allLiterals = new ArrayList(this.literals);
        allLiterals.addAll(other.literals);
        ArrayList allRestrictions = new ArrayList();
        for (DepInterval<R> d : other.constraints) {
            if (d.e == null) continue;
            allRestrictions.add(d.e);
        }
        for (DepInterval<R> d : this.constraints) {
            if (d.e == null) continue;
            allRestrictions.add(d.e);
        }
        boolean toReturn = this.compareLiterals(other, allLiterals, allRestrictions);
        if (this.hasNType() == other.hasNType() || this.hasPType() == other.hasPType()) {
            return toReturn;
        }
        if (!allRestrictions.isEmpty()) {
            return toReturn;
        }
        return !toReturn;
    }

    private boolean compareLiterals(DataTypeSituation<?> other, List<Literal<?>> allLiterals, List<Datatype<?>> allRestrictions) {
        boolean toReturn = true;
        for (Literal<?> l : allLiterals) {
            if (!this.type.isCompatible(l) || !other.type.isCompatible(l)) {
                toReturn = false;
            }
            for (Datatype<?> d : allRestrictions) {
                if (d.isCompatible(l)) continue;
                toReturn = false;
            }
        }
        return toReturn;
    }

    public boolean hasPType() {
        return this.pType != null;
    }

    public boolean hasNType() {
        return this.nType != null;
    }

    public void setPType(DepSet type) {
        this.pType = type;
    }

    public void setNType(DepSet t) {
        this.nType = t;
    }

    public DepSet getPType() {
        return this.pType;
    }

    public DepSet getNType() {
        return this.nType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.type + ' ' + this.constraints;
    }

    static class DepInterval<R extends Comparable<R>>
    implements Serializable {
        private static final long serialVersionUID = 11000L;
        protected DatatypeExpression<R> e;
        protected DepSet locDep;

        DepInterval() {
        }

        public String toString() {
            return "depInterval{" + this.e + '}';
        }

        public boolean update(Datatype<R> value, DepSet dep) {
            if (this.e == null) {
                this.e = value.isExpression() ? value.asExpression() : DatatypeFactory.getDatatypeExpression(value);
                if (this.locDep == null) {
                    this.locDep = dep;
                } else if (dep != null) {
                    this.locDep.add(dep);
                }
                return false;
            }
            if (this.e instanceof DatatypeEnumeration || this.e instanceof DatatypeNegation) {
                return false;
            }
            for (Map.Entry<Facet, Comparable> f : value.getKnownNumericFacetValues().entrySet()) {
                this.e = this.e.addNumericFacet(f.getKey(), f.getValue());
            }
            for (Map.Entry<Facet, Comparable> f : value.getKnownNonNumericFacetValues().entrySet()) {
                this.e = this.e.addNonNumericFacet(f.getKey(), f.getValue());
            }
            if (this.locDep == null) {
                this.locDep = dep;
            } else if (dep != null) {
                this.locDep.add(dep);
            }
            return true;
        }

        public boolean updateable(Datatype<R> interval) {
            if (this.e == null) {
                return true;
            }
            if (this.e instanceof DatatypeNegation) {
                return false;
            }
            if (this.e instanceof DatatypeEnumeration && interval instanceof DatatypeEnumeration) {
                return true;
            }
            return true;
        }

        boolean consistent(Datatype<R> type) {
            return this.e == null || this.e.isCompatible(type);
        }

        public boolean checkMinMaxClash() {
            if (this.e == null) {
                return false;
            }
            return this.e.emptyValueSpace();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            if (obj instanceof DepInterval) {
                return (this.e == null ? ((DepInterval)obj).e == null : this.e.equals(((DepInterval)obj).e)) && this.locDep == null ? ((DepInterval)obj).locDep == null : this.locDep.equals(((DepInterval)obj).locDep);
            }
            return false;
        }

        public int hashCode() {
            return (this.e == null ? 0 : this.e.hashCode()) + (this.locDep == null ? 0 : this.locDep.hashCode());
        }
    }
}

