/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.datatypes;

import java.math.BigDecimal;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import uk.ac.manchester.cs.jfact.datatypes.Datatype;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeExpression;
import uk.ac.manchester.cs.jfact.datatypes.DatatypeFactory;
import uk.ac.manchester.cs.jfact.datatypes.Facet;
import uk.ac.manchester.cs.jfact.datatypes.Facets;
import uk.ac.manchester.cs.jfact.datatypes.Literal;
import uk.ac.manchester.cs.jfact.datatypes.NumericDatatype;
import uk.ac.manchester.cs.jfact.datatypes.OrderedDatatype;
import uk.ac.manchester.cs.jfact.datatypes.Utils;

class DatatypeNumericExpressionImpl<O extends Comparable<O>>
extends DatatypeFactory.ABSTRACT_NUMERIC_DATATYPE<O>
implements DatatypeExpression<O> {
    private static final long serialVersionUID = 11000L;
    @Nonnull
    private final Datatype<O> host;

    public DatatypeNumericExpressionImpl(Datatype<O> b) {
        super(IRI.create((String)(b.getDatatypeIRI() + "_" + DatatypeFactory.getIndex())), b.getFacets(), Utils.generateAncestors(DatatypeNumericExpressionImpl.host(b)));
        this.host = DatatypeNumericExpressionImpl.host(b);
        this.knownNumericFacetValues.putAll(b.getKnownNumericFacetValues());
        this.knownNonNumericFacetValues.putAll(b.getKnownNonNumericFacetValues());
    }

    @Override
    public O parseValue(String s) {
        return this.host.parseValue(s);
    }

    @Override
    public Datatype<O> getHostType() {
        return this.host;
    }

    @Override
    public DatatypeExpression<O> addNumericFacet(Facet f, Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value instanceof Literal && !this.host.isCompatible((Literal)value)) {
            throw new IllegalArgumentException("Not a valid value for this expression: " + f + '\t' + value + " for: " + this);
        }
        DatatypeNumericExpressionImpl<O> toReturn = new DatatypeNumericExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        if (f.equals(Facets.minExclusive) || f.equals(Facets.minInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.minExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.minInclusive);
        }
        if (f.equals(Facets.maxExclusive) || f.equals(Facets.maxInclusive)) {
            toReturn.knownNumericFacetValues.remove(Facets.maxExclusive);
            toReturn.knownNumericFacetValues.remove(Facets.maxInclusive);
        }
        if (value instanceof Number) {
            toReturn.knownNumericFacetValues.put(f, new BigDecimal(value.toString()));
        } else {
            toReturn.knownNumericFacetValues.put(f, value);
        }
        return toReturn;
    }

    @Override
    public DatatypeExpression<O> addNonNumericFacet(Facet f, Comparable<?> value) {
        if (!this.facets.contains(f)) {
            throw new IllegalArgumentException("Facet " + f + " not allowed tor datatype " + this.getHostType());
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (value instanceof Literal && !this.host.isCompatible((Literal)value)) {
            throw new IllegalArgumentException("Not a valid value for this expression: " + f + '\t' + value + " for: " + this);
        }
        DatatypeNumericExpressionImpl<O> toReturn = new DatatypeNumericExpressionImpl<O>(this.host);
        toReturn.knownNumericFacetValues.putAll(this.knownNumericFacetValues);
        toReturn.knownNonNumericFacetValues.putAll(this.knownNonNumericFacetValues);
        toReturn.knownNonNumericFacetValues.put(f, value);
        return toReturn;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean emptyValueSpace() {
        if (this.getNumeric()) {
            Comparable max;
            int excluded = 0;
            Comparable min = this.getNumericFacetValue(Facets.minInclusive);
            if (min == null) {
                min = this.getNumericFacetValue(Facets.minExclusive);
                ++excluded;
            }
            if ((max = this.getNumericFacetValue(Facets.maxInclusive)) == null) {
                max = this.getNumericFacetValue(Facets.maxExclusive);
                ++excluded;
            }
            return !DatatypeFactory.intervalWithValues(min, max, excluded);
        }
        return false;
    }

    @Override
    public boolean isNumericDatatype() {
        return this.host.isNumericDatatype();
    }

    @Override
    public NumericDatatype<O> asNumericDatatype() {
        return this;
    }

    @Override
    public boolean isOrderedDatatype() {
        return this.host.isOrderedDatatype();
    }

    @Override
    public OrderedDatatype<O> asOrderedDatatype() {
        return this;
    }

    @Override
    public String toString() {
        return "numeric(" + this.host.toString() + "(extra facets:" + this.getMin() + ' ' + this.getMax() + "))";
    }
}

