/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.helpers.LEAFDLTree;
import uk.ac.manchester.cs.jfact.helpers.NDLTree;
import uk.ac.manchester.cs.jfact.helpers.ONEDLTree;
import uk.ac.manchester.cs.jfact.helpers.ReverseCloningVisitor;
import uk.ac.manchester.cs.jfact.helpers.TWODLTree;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Lexeme;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.Token;

public class DLTreeFactory
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private static final EnumSet<Token> snfCalls = EnumSet.of(Token.TOP, new Token[]{Token.BOTTOM, Token.CNAME, Token.INAME, Token.RNAME, Token.DNAME, Token.DATAEXPR, Token.NOT, Token.INV, Token.AND, Token.FORALL, Token.LE, Token.SELF, Token.RCOMPOSITION, Token.PROJFROM, Token.PROJINTO});

    @Nonnull
    public static DLTree createBottom() {
        return new LEAFDLTree(new Lexeme(Token.BOTTOM));
    }

    @Nonnull
    public static DLTree createInverse(DLTree R) {
        assert (R != null);
        if (R.token() == Token.INV) {
            return R.getChild().copy();
        }
        if (R.token() == Token.RNAME) {
            if (DLTreeFactory.isTopRole(R) || DLTreeFactory.isBotRole(R)) {
                return R;
            }
            return new ONEDLTree(new Lexeme(Token.INV), R);
        }
        throw new UnreachableSituationException();
    }

    public static boolean isSemanticallyDataTop(DLTree dr) {
        return dr.elem().getToken() == Token.TOP;
    }

    public static boolean isSemanticallyDataBottom(DLTree dr) {
        return dr.elem().getToken() == Token.BOTTOM;
    }

    public static boolean isDataRangeBigEnough(DLTree dr, int n) {
        return true;
    }

    @Nonnull
    public static DLTree simplifyDataTopForall(DLTree dr) {
        if (DLTreeFactory.isSemanticallyDataTop(dr)) {
            return DLTreeFactory.createTop();
        }
        return DLTreeFactory.createBottom();
    }

    @Nonnull
    public static DLTree simplifyDataTopLE(int n, DLTree dr) {
        if (DLTreeFactory.isSemanticallyDataBottom(dr)) {
            return DLTreeFactory.createTop();
        }
        if (!DLTreeFactory.isDataRangeBigEnough(dr, n)) {
            return DLTreeFactory.createTop();
        }
        return DLTreeFactory.createBottom();
    }

    @Nonnull
    public static DLTree buildDisjAux(List<DLTree> arguments) {
        ArrayList<DLTree> args = new ArrayList<DLTree>(arguments.size());
        for (DLTree i : arguments) {
            args.add(DLTreeFactory.createSNFNot(i.copy()));
        }
        return DLTreeFactory.createSNFAnd(args);
    }

    @Nonnull
    public static DLTree createSNFAnd(DLTree C, DLTree D) {
        if (C == null) {
            assert (D != null);
            return D;
        }
        if (D == null) {
            assert (C != null);
            return C;
        }
        if (C.isTOP() || D.isBOTTOM()) {
            return D;
        }
        if (D.isTOP() || C.isBOTTOM()) {
            return C;
        }
        return new NDLTree(new Lexeme(Token.AND), C, D);
    }

    @Nonnull
    public static DLTree createSNFAnd(Collection<DLTree> collection) {
        if (collection.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (collection.size() == 1) {
            DLTree next = collection.iterator().next();
            assert (next != null);
            return next;
        }
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (DLTree d : collection) {
            if (d == null) continue;
            if (d.isBOTTOM()) {
                return DLTreeFactory.createBottom();
            }
            if (d.isAND()) {
                l.addAll(d.getChildren());
                continue;
            }
            l.add(d);
        }
        if (l.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (l.size() == 1) {
            DLTree dlTree = (DLTree)l.get(0);
            assert (dlTree != null);
            return dlTree;
        }
        return new NDLTree(new Lexeme(Token.AND), l);
    }

    public static boolean containsC(DLTree C, DLTree D) {
        if (C.isCName()) {
            return DLTree.equalTrees(C, D);
        }
        if (C.isAND()) {
            for (DLTree p : C.getChildren()) {
                if (!DLTreeFactory.containsC(p, D)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static DLTree createSNFReducedAnd(DLTree C, DLTree D) {
        if (C == null || D == null) {
            return DLTreeFactory.createSNFAnd(C, D);
        }
        if (D.isCName() && DLTreeFactory.containsC(C, D)) {
            return C;
        }
        if (D.isAND()) {
            for (DLTree d : D.getChildren()) {
                C = DLTreeFactory.createSNFReducedAnd(C, d.copy());
            }
            return C;
        }
        return DLTreeFactory.createSNFAnd(C, D);
    }

    @Nonnull
    public static DLTree createSNFAnd(Collection<DLTree> collection, @Nonnull DLTree ancestor) {
        if (collection.size() == 1) {
            return collection.iterator().next();
        }
        boolean hasTop = false;
        ArrayList<DLTree> l = new ArrayList<DLTree>();
        for (DLTree d : collection) {
            if (d.isTOP()) {
                hasTop = true;
            }
            if (d.isBOTTOM()) {
                return DLTreeFactory.createBottom();
            }
            if (d.isAND()) {
                l.addAll(d.getChildren());
                continue;
            }
            l.add(d);
        }
        if (hasTop && l.isEmpty()) {
            return DLTreeFactory.createTop();
        }
        if (l.size() == collection.size()) {
            return ancestor;
        }
        return new NDLTree(new Lexeme(Token.AND), l);
    }

    @Nonnull
    public static DLTree createSNFExists(DLTree R, DLTree C) {
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFForall(R, DLTreeFactory.createSNFNot(C)));
    }

    @Nonnull
    public static DLTree createSNFForall(DLTree R, DLTree C) {
        if (C.isTOP()) {
            return C;
        }
        if (DLTreeFactory.isBotRole(R)) {
            return DLTreeFactory.createTop();
        }
        if (DLTreeFactory.isTopRole(R) && Role.resolveRole(R).isDataRole()) {
            return DLTreeFactory.simplifyDataTopForall(C);
        }
        return new TWODLTree(new Lexeme(Token.FORALL), R, C);
    }

    @Nonnull
    public static DLTree createRole(Role R) {
        return DLTreeFactory.createEntry(R.isDataRole() ? Token.DNAME : Token.RNAME, R);
    }

    @Nonnull
    public static DLTree createEntry(Token tag, NamedEntry entry) {
        return new LEAFDLTree(new Lexeme(tag, entry));
    }

    @Nonnull
    public static DLTree createSNFLE(int n, DLTree R, DLTree C) {
        if (C.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (n == 0) {
            return DLTreeFactory.createSNFForall(R, DLTreeFactory.createSNFNot(C));
        }
        if (DLTreeFactory.isBotRole(R)) {
            return DLTreeFactory.createTop();
        }
        if (DLTreeFactory.isTopRole(R) && Role.resolveRole(R).isDataRole()) {
            return DLTreeFactory.simplifyDataTopLE(n, C);
        }
        return new TWODLTree(new Lexeme(Token.LE, n), R, C);
    }

    public static boolean isBotRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isBottom();
    }

    public static boolean isTopRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isTop();
    }

    @Nonnull
    public static DLTree createSNFSelf(DLTree R) {
        if (DLTreeFactory.isBotRole(R)) {
            return DLTreeFactory.createBottom();
        }
        if (DLTreeFactory.isTopRole(R)) {
            return DLTreeFactory.createTop();
        }
        return new ONEDLTree(new Lexeme(Token.SELF), R);
    }

    @Nonnull
    public static DLTree createSNFGE(int n, DLTree R, DLTree C) {
        if (n == 0) {
            return DLTreeFactory.createTop();
        }
        if (C.isBOTTOM()) {
            return C;
        }
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFLE(n - 1, R, C));
    }

    @Nonnull
    public static DLTree createSNFNot(DLTree C) {
        assert (C != null);
        if (C.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (C.isTOP()) {
            return DLTreeFactory.createBottom();
        }
        if (C.token() == Token.NOT) {
            return C.getChild().copy();
        }
        return new ONEDLTree(new Lexeme(Token.NOT), C);
    }

    @Nonnull
    public static DLTree createSNFNot(@Nonnull DLTree C, @Nonnull DLTree ancestor) {
        assert (C != null);
        if (C.isBOTTOM()) {
            return DLTreeFactory.createTop();
        }
        if (C.isTOP()) {
            return DLTreeFactory.createBottom();
        }
        if (C.token() == Token.NOT) {
            return C.getChild().copy();
        }
        return ancestor;
    }

    @Nonnull
    public static DLTree createSNFOr(Collection<DLTree> C) {
        ArrayList<DLTree> list = new ArrayList<DLTree>();
        for (DLTree d : C) {
            list.add(DLTreeFactory.createSNFNot(d));
        }
        return DLTreeFactory.createSNFNot(DLTreeFactory.createSNFAnd(list));
    }

    @Nonnull
    public static DLTree createTop() {
        return new LEAFDLTree(new Lexeme(Token.TOP));
    }

    @Nonnull
    public static DLTree inverseComposition(DLTree tree) {
        if (tree.token() == Token.RCOMPOSITION) {
            return tree.accept(new ReverseCloningVisitor());
        }
        return new LEAFDLTree(new Lexeme(Token.RNAME, Role.resolveRole(tree).inverse()));
    }

    @Nonnull
    public static DLTree wrap(NamedEntry t) {
        return new LEAFDLTree(new Lexeme(Token.DATAEXPR, t));
    }

    @Nonnull
    public static NamedEntry unwrap(DLTree t) {
        return t.elem().getNE();
    }

    @Nonnull
    public static DLTree buildTree(Lexeme t, DLTree t1, DLTree t2) {
        return new TWODLTree(t, t1, t2);
    }

    @Nonnull
    public static DLTree buildTree(Lexeme t, Collection<DLTree> l) {
        return new NDLTree(t, l);
    }

    @Nonnull
    public static DLTree buildTree(Lexeme t, DLTree t1) {
        return new ONEDLTree(t, t1);
    }

    @Nonnull
    public static DLTree buildTree(Lexeme t) {
        return new LEAFDLTree(t);
    }

    private static boolean isRName(DLTree t) {
        if (t == null) {
            return false;
        }
        return t.token() == Token.RNAME || t.token() == Token.DNAME;
    }

    public static boolean isFunctionalExpr(DLTree t, NamedEntry R) {
        return t != null && t.token() == Token.LE && R.equals(t.getLeft().elem().getNE()) && t.elem().getData() == 1 && t.getRight().isTOP();
    }

    public static boolean isSNF(DLTree t) {
        if (t == null) {
            return true;
        }
        if (snfCalls.contains((Object)t.token())) {
            return DLTreeFactory.isSNF(t.getLeft()) && DLTreeFactory.isSNF(t.getRight());
        }
        return false;
    }

    public static boolean isSubTree(DLTree t1, DLTree t2) {
        if (t1 == null || t1.isTOP()) {
            return true;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.isAND()) {
            for (DLTree t : t1.getChildren()) {
                if (DLTreeFactory.isSubTree(t, t2)) continue;
                return false;
            }
            return true;
        }
        if (t2.isAND()) {
            for (DLTree t : t2.getChildren()) {
                if (!DLTreeFactory.isSubTree(t1, t)) continue;
                return true;
            }
            return false;
        }
        return t1.equals(t2);
    }

    public static boolean isUniversalRole(DLTree t) {
        return DLTreeFactory.isRName(t) && t.elem().getNE().isTop();
    }

    public static boolean replaceSynonymsFromTree(DLTree desc) {
        if (desc == null) {
            return false;
        }
        if (desc.isName()) {
            ClassifiableEntry entry = (ClassifiableEntry)desc.elem.getNE();
            if (entry.isSynonym()) {
                desc.elem = (entry = ClassifiableEntry.resolveSynonym(entry)).isTop() ? new Lexeme(Token.TOP) : (entry.isBottom() ? new Lexeme(Token.BOTTOM) : new Lexeme(((Concept)entry).isSingleton() ? Token.INAME : Token.CNAME, entry));
                return true;
            }
            return false;
        }
        boolean ret = false;
        for (DLTree d : desc.getChildren()) {
            ret |= DLTreeFactory.replaceSynonymsFromTree(d);
        }
        return ret;
    }
}

