/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.kernel.Axiom;
import uk.ac.manchester.cs.jfact.kernel.AxiomSet;

public enum AbsorptionActions {
    B('B'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return ax.absorbIntoBottom();
        }
    }
    ,
    T('T'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return ax.absorbIntoTop(tb.tboxHost);
        }
    }
    ,
    E('E'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return tb.processNewAxiom(ax.simplifyCN(tb.tboxHost));
        }
    }
    ,
    C('C'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return ax.absorbIntoConcept(tb.tboxHost);
        }
    }
    ,
    N('N'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return ax.absorbIntoNegConcept(tb.tboxHost);
        }
    }
    ,
    FA('f'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return tb.processNewAxiom(ax.simplifySForall(tb.tboxHost));
        }
    }
    ,
    F('F'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return tb.processNewAxiom(ax.simplifyForall(tb.tboxHost));
        }
    }
    ,
    R('R'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return ax.absorbIntoDomain(tb.tboxHost);
        }
    }
    ,
    S('S'){

        @Override
        public boolean execute(Axiom ax, AxiomSet tb) {
            return tb.split(ax);
        }
    };

    private char c;

    private AbsorptionActions(char ch) {
        this.c = ch;
    }

    public static AbsorptionActions get(char ch) {
        for (AbsorptionActions v : AbsorptionActions.values()) {
            if (v.c != ch) continue;
            return v;
        }
        throw new ReasonerInternalException("Incorrect absorption flags given: " + ch);
    }

    public abstract boolean execute(Axiom var1, AxiomSet var2);
}

