/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.helpers.ArrayIntMap;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.kernel.CWDArray;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DagTag;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.kernel.state.SaveState;

@PortedFrom(file="CGLabel.h", name="CGLabel")
public class CGLabel
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @Original
    private static int idcounter = 0;
    @PortedFrom(file="CGLabel.h", name="scLabel")
    private final CWDArray scLabel;
    @PortedFrom(file="CGLabel.h", name="ccLabel")
    private final CWDArray ccLabel;
    @Original
    private final int id;
    @Original
    private final Set<CGLabel> lesserEquals = Collections.newSetFromMap(new IdentityHashMap());

    @Original
    private static int getnewId() {
        return idcounter++;
    }

    public CGLabel(JFactReasonerConfiguration config) {
        this.scLabel = new CWDArray(config, 8);
        this.ccLabel = new CWDArray(config, 4);
        this.id = CGLabel.getnewId();
    }

    @Original
    public List<ConceptWDep> get_sc() {
        return this.scLabel.getBase();
    }

    @Original
    public List<ConceptWDep> get_cc() {
        return this.ccLabel.getBase();
    }

    @Original
    public ArrayIntMap get_sc_concepts() {
        return this.scLabel.getContainedConcepts();
    }

    @Original
    public ArrayIntMap get_cc_concepts() {
        return this.ccLabel.getContainedConcepts();
    }

    @PortedFrom(file="CGLabel.h", name="getLabel")
    public CWDArray getLabel(DagTag tag) {
        return tag.isComplexConcept() ? this.ccLabel : this.scLabel;
    }

    @Original
    public void add(DagTag tag, ConceptWDep p) {
        this.getLabel(tag).private_add(p);
        this.clearMyCache();
    }

    @Original
    protected void clearMyCache() {
        this.lesserEquals.clear();
    }

    @Original
    protected void clearOthersCache() {
        for (CGLabel c : this.lesserEquals) {
            c.lesserEquals.remove(this);
        }
    }

    @PortedFrom(file="CGLabel.h", name="containsCC")
    public boolean containsCC(int p) {
        return this.ccLabel.contains(p);
    }

    public int hashCode() {
        return this.id;
    }

    @PortedFrom(file="CGLabel.h", name="<=")
    public boolean lesserequal(CGLabel label) {
        boolean toReturn;
        if (this == label) {
            return true;
        }
        if (this.lesserEquals.contains(label)) {
            return true;
        }
        boolean bl = toReturn = this.scLabel.lesserequal(label.scLabel) && this.ccLabel.lesserequal(label.ccLabel);
        if (toReturn) {
            this.lesserEquals.add(label);
        }
        return toReturn;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof CGLabel) {
            CGLabel obj2 = (CGLabel)obj;
            boolean toReturn = this.scLabel.equals(obj2.scLabel) && this.ccLabel.equals(obj2.ccLabel);
            return toReturn;
        }
        return false;
    }

    @PortedFrom(file="CGLabel.h", name="save")
    public void save(SaveState ss) {
        ss.setSc(this.scLabel.save());
        ss.setCc(this.ccLabel.save());
    }

    @PortedFrom(file="CGLabel.h", name="restore")
    public void restore(SaveState ss, int level) {
        this.scLabel.restore(ss.getSc(), level);
        this.ccLabel.restore(ss.getCc(), level);
        this.clearOthersCache();
    }

    public String toString() {
        return this.scLabel.toString() + this.ccLabel.toString();
    }

    @PortedFrom(file="CGLabel.h", name="init")
    public void init() {
        this.clearOthersCache();
        this.clearMyCache();
        this.scLabel.init();
        this.ccLabel.init();
    }

    @PortedFrom(file="CGLabel.h", name="contains")
    public boolean contains(int p) {
        assert (Helper.isCorrect(p));
        if (p == 1) {
            return true;
        }
        if (p == -1) {
            return false;
        }
        return this.scLabel.contains(p) || this.ccLabel.contains(p);
    }

    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getConceptWithBP(int bp) {
        ConceptWDep toReturn = this.getSCConceptWithBP(bp);
        if (toReturn != null) {
            return toReturn;
        }
        return this.getCCConceptWithBP(bp);
    }

    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getSCConceptWithBP(int bp) {
        return this.scLabel.getConceptWithBP(bp);
    }

    @PortedFrom(file="CGLabel.h", name="getConcept")
    public ConceptWDep getCCConceptWithBP(int bp) {
        return this.ccLabel.getConceptWithBP(bp);
    }
}

