/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import uk.ac.manchester.cs.jfact.helpers.DLTree;
import uk.ac.manchester.cs.jfact.kernel.Concept;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.TBox;
import uk.ac.manchester.cs.jfact.kernel.Token;

@PortedFrom(file="tAxiom.h", name="InAx")
public class InAx
implements Serializable {
    private static final long serialVersionUID = 11000L;
    private static final Map<String, AtomicInteger> created = new HashMap<String, AtomicInteger>();

    public static Concept getConcept(DLTree p) {
        return (Concept)p.elem().getNE();
    }

    @PortedFrom(file="tAxiom.cpp", name="isNP")
    public static boolean isNP(Concept C, TBox t) {
        return C.isNonPrimitive() && !InAx.hasDefCycle(C);
    }

    @PortedFrom(file="tAxiom.cpp", name="hasDefCycle")
    static boolean hasDefCycle(Concept C) {
        if (C.isPrimitive()) {
            return false;
        }
        return InAx.hasDefCycle(C, new HashSet<Concept>());
    }

    @PortedFrom(file="tAxiom.cpp", name="hasDefCycle")
    static boolean hasDefCycle(Concept C, Set<Concept> visited) {
        if (C.isPrimitive()) {
            return false;
        }
        if (visited.contains(C)) {
            return true;
        }
        DLTree p = C.getDescription();
        if (!p.isNOT()) {
            return false;
        }
        if ((p = p.getChild()).token() != Token.FORALL) {
            return false;
        }
        if (!(p = p.getRight()).isNOT()) {
            return false;
        }
        if (!(p = p.getChild()).isName()) {
            return false;
        }
        visited.add(C);
        return InAx.hasDefCycle(InAx.getConcept(p), visited);
    }

    public static boolean isTop(DLTree p) {
        return p.isBOTTOM();
    }

    public static boolean isBot(DLTree p) {
        return p.isTOP();
    }

    public static boolean isPosCN(DLTree p) {
        return p.isNOT() && p.getChild().isName();
    }

    public static boolean isPosNP(DLTree p, TBox t) {
        return InAx.isPosCN(p) && InAx.isNP(InAx.getConcept(p.getChild()), t);
    }

    public static boolean isPosPC(DLTree p) {
        return InAx.isPosCN(p) && InAx.getConcept(p.getChild()).isPrimitive();
    }

    public static boolean isNegCN(DLTree p) {
        return p.isName();
    }

    public static boolean isNegNP(DLTree p, TBox t) {
        return InAx.isNegCN(p) && InAx.isNP(InAx.getConcept(p), t);
    }

    public static boolean isNegPC(DLTree p) {
        return InAx.isNegCN(p) && InAx.getConcept(p).isPrimitive();
    }

    public static boolean isAnd(DLTree p) {
        return p.isNOT() && p.getChild().isAND();
    }

    public static boolean isOr(DLTree p) {
        return p.isAND();
    }

    public static boolean isForall(DLTree p) {
        return p.isNOT() && p.getChild().token() == Token.FORALL;
    }

    public static boolean isOForall(DLTree p) {
        return InAx.isForall(p) && !Role.resolveRole(p.getChild().getLeft()).isDataRole();
    }

    public static boolean isAbsForall(DLTree p) {
        if (!InAx.isOForall(p)) {
            return false;
        }
        DLTree C = p.getChild().getRight();
        if (InAx.isTop(C)) {
            return false;
        }
        return !C.isName() || !InAx.getConcept(C).isSystem();
    }

    private static void add(String s) {
        AtomicInteger i = created.get(s);
        if (i == null) {
            i = new AtomicInteger(1);
            created.put(s, i);
        } else {
            i.incrementAndGet();
        }
    }

    private static int get(String s) {
        AtomicInteger i = created.get(s);
        return i == null ? 0 : i.get();
    }

    public static void SAbsRepCN() {
        InAx.add("SAbsRepCN");
    }

    public static void SAbsRepForall() {
        InAx.add("SAbsRepForall");
    }

    public static void SAbsBApply() {
        InAx.add("SAbsBApply");
    }

    public static void SAbsSplit() {
        InAx.add("SAbsSplit");
    }

    public static void SAbsTApply() {
        InAx.add("SAbsTApply");
    }

    public static void SAbsCApply() {
        InAx.add("SAbsCApply");
    }

    public static void SAbsCAttempt() {
        InAx.add("SAbsCAttempt");
    }

    public static void SAbsRApply() {
        InAx.add("SAbsRApply");
    }

    public static void SAbsRAttempt() {
        InAx.add("SAbsRAttempt");
    }

    public static void SAbsInput() {
        InAx.add("SAbsInput");
    }

    public static void SAbsAction() {
        InAx.add("SAbsAction");
    }

    public static void SAbsNApply() {
        InAx.add("SAbsNApply");
    }

    public static void SAbsNAttempt() {
        InAx.add("SAbsNAttempt");
    }

    public static boolean containsSAbsRepCN() {
        return created.containsKey("SAbsRepCN");
    }

    public static boolean containsSAbsRepForall() {
        return created.containsKey("SAbsRepForall");
    }

    public static boolean containsSAbsBApply() {
        return created.containsKey("SAbsBApply");
    }

    public static boolean containsSAbsSplit() {
        return created.containsKey("SAbsSplit");
    }

    public static boolean containsSAbsTApply() {
        return created.containsKey("SAbsTApply");
    }

    public static boolean containsSAbsCApply() {
        return created.containsKey("SAbsCApply");
    }

    public static boolean containsSAbsCAttempt() {
        return created.containsKey("SAbsCAttempt");
    }

    public static boolean containsSAbsRApply() {
        return created.containsKey("SAbsRApply");
    }

    public static boolean containsSAbsRAttempt() {
        return created.containsKey("SAbsRAttempt");
    }

    public static boolean containsSAbsInput() {
        return created.containsKey("SAbsInput");
    }

    public static boolean containsSAbsAction() {
        return created.containsKey("SAbsAction");
    }

    public static boolean containsSAbsNApply() {
        return created.containsKey("SAbsNApply");
    }

    public static boolean containsSAbsNAttempt() {
        return created.containsKey("SAbsNAttempt");
    }

    public static int getSAbsRepCN() {
        return InAx.get("SAbsRepCN");
    }

    public static int getSAbsRepForall() {
        return InAx.get("SAbsRepForall");
    }

    public static int getSAbsBApply() {
        return InAx.get("SAbsBApply");
    }

    public static int getSAbsSplit() {
        return InAx.get("SAbsSplit");
    }

    public static int getSAbsTApply() {
        return InAx.get("SAbsTApply");
    }

    public static int getSAbsCApply() {
        return InAx.get("SAbsCApply");
    }

    public static int getSAbsCAttempt() {
        return InAx.get("SAbsCAttempt");
    }

    public static int getSAbsRApply() {
        return InAx.get("SAbsRApply");
    }

    public static int getSAbsRAttempt() {
        return InAx.get("SAbsRAttempt");
    }

    public static int getSAbsInput() {
        return InAx.get("SAbsInput");
    }

    public static int getSAbsAction() {
        return InAx.get("SAbsAction");
    }

    public static int getSAbsNApply() {
        return InAx.get("SAbsNApply");
    }

    public static int getSAbsNAttempt() {
        return InAx.get("SAbsNAttempt");
    }

    @PortedFrom(file="tAxiom.h", name="isSimpleForall")
    public static boolean isSimpleForall(DLTree p) {
        if (!InAx.isAbsForall(p)) {
            return false;
        }
        DLTree C = p.getChild().getRight();
        return C.isName() && InAx.getConcept(C).getDescription() == null;
    }
}

