/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="tOntology.h", name="TOntology")
public class Ontology
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="tOntology.h", name="Axioms")
    private final List<AxiomInterface> axioms = new ArrayList<AxiomInterface>();
    @PortedFrom(file="tOntology.h", name="Retracted")
    private final List<AxiomInterface> retracted = new ArrayList<AxiomInterface>();
    @PortedFrom(file="tOntology.h", name="EManager")
    private final ExpressionCache expressionCache = new ExpressionCache();
    @PortedFrom(file="tOntology.h", name="axiomId")
    private int axiomId = 0;
    @PortedFrom(file="tOntology.h", name="changed")
    private boolean changed = false;

    @PortedFrom(file="tOntology.h", name="get")
    public AxiomInterface get(int i) {
        return this.axioms.get(i);
    }

    @PortedFrom(file="tOntology.h", name="isChanged")
    public boolean isChanged() {
        return this.changed;
    }

    @PortedFrom(file="tOntology.h", name="setProcessed")
    public void setProcessed() {
        this.retracted.clear();
        this.changed = false;
    }

    @PortedFrom(file="tOntology.h", name="add")
    @Nonnull
    public AxiomInterface add(AxiomInterface p) {
        p.setId(++this.axiomId);
        this.axioms.add(p);
        this.changed = true;
        return p;
    }

    @PortedFrom(file="tOntology.h", name="retract")
    public void retract(AxiomInterface p) {
        this.changed = true;
        this.retracted.add(p);
        p.setUsed(false);
    }

    @PortedFrom(file="tOntology.h", name="clear")
    public void clear() {
        this.safeClear();
        this.retracted.clear();
        this.expressionCache.clear();
        this.changed = false;
    }

    @PortedFrom(file="tOntology.h", name="safeClear")
    public void safeClear() {
        this.axioms.clear();
    }

    @PortedFrom(file="tOntology.h", name="getExpressionManager")
    public ExpressionCache getExpressionManager() {
        return this.expressionCache;
    }

    @PortedFrom(file="tOntology.h", name="getAxioms")
    public List<AxiomInterface> getAxioms() {
        return this.axioms;
    }

    @PortedFrom(file="tOntology.h", name="size")
    public int size() {
        return this.axioms.size();
    }

    @Original
    public List<AxiomInterface> getRetracted() {
        return this.retracted;
    }

    @PortedFrom(file="tOntology.h", name="getSignature")
    public TSignature getSignature() {
        TSignature sig = new TSignature();
        for (AxiomInterface p : this.axioms) {
            if (!p.isUsed()) continue;
            sig.add(p.getSignature());
        }
        return sig;
    }
}

