/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.Helper;
import uk.ac.manchester.cs.jfact.helpers.LogAdapter;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;

@PortedFrom(file="RAutomaton.h", name="RoleAutomaton")
public class RoleAutomaton
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="RAutomaton.h", name="Base")
    private final List<RAStateTransitions> base = new ArrayList<RAStateTransitions>();
    @PortedFrom(file="RAutomaton.h", name="map")
    private int[] map = new int[0];
    @PortedFrom(file="RAutomaton.h", name="iRA")
    private int initialRA = 0;
    @PortedFrom(file="RAutomaton.h", name="ISafe")
    private boolean inputSafe = true;
    @PortedFrom(file="RAutomaton.h", name="OSafe")
    private boolean outputSafe = true;
    @Original
    public static final int initial = 0;
    @PortedFrom(file="RAutomaton.h", name="final")
    public static final int final_state = 1;
    @PortedFrom(file="RAutomaton.h", name="Complete")
    private boolean Complete;

    @PortedFrom(file="RAutomaton.h", name="ensureState")
    private void ensureState(int state) {
        if (state >= this.base.size()) {
            Helper.resize(this.base, state + 1);
        }
        for (int i = 0; i < this.base.size(); ++i) {
            if (this.base.get(i) != null) continue;
            this.base.set(i, new RAStateTransitions());
        }
    }

    public RoleAutomaton() {
        this.ensureState(1);
    }

    @PortedFrom(file="RAutomaton.h", name="initChain")
    public void initChain(int from) {
        this.initialRA = from;
    }

    @PortedFrom(file="RAutomaton.h", name="addToChain")
    public boolean addToChain(RoleAutomaton RA, boolean oSafe) {
        return this.addToChain(RA, oSafe, this.size() + 1);
    }

    @PortedFrom(file="RAutomaton.h", name="isISafe")
    public boolean isISafe() {
        return this.inputSafe;
    }

    @PortedFrom(file="RAutomaton.h", name="isOSafe")
    public boolean isOSafe() {
        return this.outputSafe;
    }

    @PortedFrom(file="RAutomaton.h", name="addRA")
    public void addRA(RoleAutomaton RA) {
        if (this.isCompleted()) {
            return;
        }
        if (RA.isSimple()) {
            boolean ok = this.base.get(0).addToExisting(RA.get(0).begin().get(0));
            assert (ok);
        } else {
            this.initChain(0);
            this.addToChain(RA, false, 1);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addTransitionSafe")
    public void addTransitionSafe(int state, RATransition trans) {
        this.ensureState(state);
        this.ensureState(trans.final_state());
        this.addTransition(state, trans);
    }

    @PortedFrom(file="RAutomaton.h", name="setIUnsafe")
    public void setIUnsafe() {
        this.inputSafe = false;
    }

    @PortedFrom(file="RAutomaton.h", name="setOUnsafe")
    public void setOUnsafe() {
        this.outputSafe = false;
    }

    @PortedFrom(file="RAutomaton.h", name="checkTransition")
    public void checkTransition(int from, int to) {
        if (from == 1) {
            this.setOUnsafe();
        }
        if (to == 0) {
            this.setIUnsafe();
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addTransition")
    public void addTransition(int from, RATransition trans) {
        this.checkTransition(from, trans.final_state());
        this.base.get(from).add(trans);
    }

    @PortedFrom(file="RAutomaton.h", name="nextChainTransition")
    public void nextChainTransition(int to) {
        this.addTransition(this.initialRA, new RATransition(to));
        this.initialRA = to;
    }

    @PortedFrom(file="RAutomaton.h", name="newState")
    public int newState() {
        int ret = this.base.size();
        this.ensureState(ret);
        return ret;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public RAStateTransitions getRAStateTransitions(int state) {
        return this.base.get(state);
    }

    @PortedFrom(file="RAutomaton.h", name="size")
    public int size() {
        return this.base.size();
    }

    @PortedFrom(file="RAutomaton.h", name="setup")
    public void setup(int nRoles, boolean data) {
        for (int i = 0; i < this.base.size(); ++i) {
            this.base.get(i).setup(i, nRoles, data);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="print")
    public void print(LogAdapter o) {
        for (int state = 0; state < this.base.size(); ++state) {
            this.base.get(state).print(o);
        }
    }

    @PortedFrom(file="RAutomaton.h", name="addCopy")
    public void addCopy(RoleAutomaton RA) {
        for (int i = 0; i < RA.size(); ++i) {
            int from = this.map[i];
            RAStateTransitions RST = this.base.get(from);
            RAStateTransitions RSTOrig = RA.base.get(i);
            if (RSTOrig.empty()) continue;
            List<RATransition> begin = RSTOrig.begin();
            for (int j = 0; j < begin.size(); ++j) {
                RATransition p = begin.get(j);
                int to = p.final_state();
                RATransition trans = new RATransition(this.map[to]);
                this.checkTransition(from, trans.final_state());
                trans.add(p);
                if (to == 1 && RST.addToExisting(trans)) continue;
                RST.add(trans);
            }
        }
    }

    @PortedFrom(file="RAutomaton.h", name="initMap")
    public void initMap(int RASize, int fRA) {
        this.map = Arrays.copyOf(this.map, RASize);
        int newState = this.size() - 1;
        this.map[0] = this.initialRA;
        if (fRA >= this.size()) {
            fRA = this.size();
            ++newState;
        }
        this.map[1] = fRA;
        this.checkTransition(this.initialRA, fRA);
        this.initialRA = fRA;
        for (int i = 2; i < RASize; ++i) {
            this.map[i] = ++newState;
        }
        this.ensureState(newState);
    }

    @PortedFrom(file="RAutomaton.h", name="addToChain")
    public boolean addToChain(RoleAutomaton RA, boolean oSafe, int fRA) {
        boolean needFinalTrans;
        boolean bl = needFinalTrans = fRA < this.size() && !RA.isOSafe();
        if (!oSafe && !RA.isISafe()) {
            this.nextChainTransition(this.newState());
        }
        this.initMap(RA.size(), needFinalTrans ? this.size() : fRA);
        this.addCopy(RA);
        if (needFinalTrans) {
            this.nextChainTransition(fRA);
        }
        return RA.isOSafe();
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public List<RAStateTransitions> getBase() {
        return this.base;
    }

    @PortedFrom(file="RAutomaton.h", name="begin")
    public RAStateTransitions get(int i) {
        return this.base.get(i);
    }

    @PortedFrom(file="RAutomaton.h", name="setCompleted")
    public void setCompleted(boolean b) {
        this.Complete = b;
    }

    @PortedFrom(file="RAutomaton.h", name="isCompleted")
    public boolean isCompleted() {
        return this.Complete;
    }

    @PortedFrom(file="RAutomaton.h", name="isSimple")
    public boolean isSimple() {
        return this.size() == 2 && this.inputSafe && this.outputSafe;
    }
}

