/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLObject;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.TaxonomyVertex;
import uk.ac.manchester.cs.jfact.kernel.actors.Actor;
import uk.ac.manchester.cs.jfact.kernel.actors.SupConceptActor;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;

@PortedFrom(file="Taxonomy.h", name="Taxonomy")
public class Taxonomy
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="Taxonomy.h", name="Graph")
    private final List<TaxonomyVertex> graph = new ArrayList<TaxonomyVertex>();
    @PortedFrom(file="Taxonomy.h", name="Current")
    protected TaxonomyVertex current = new TaxonomyVertex();
    @PortedFrom(file="Taxonomy.h", name="willInsertIntoTaxonomy")
    protected boolean willInsertIntoTaxonomy = true;
    @PortedFrom(file="Taxonomy.h", name="FreshNode")
    protected final TaxonomyVertex FreshNode = new TaxonomyVertex();
    @PortedFrom(file="Taxonomy.h", name="checkLabel")
    protected long visitedLabel = 1L;
    @Original
    private final JFactReasonerConfiguration options;

    @PortedFrom(file="Taxonomy.h", name="getCurrent")
    public TaxonomyVertex getCurrent() {
        return this.current;
    }

    @PortedFrom(file="Taxonomy.h", name="setCurrent")
    public void setCurrent(TaxonomyVertex cur) {
        this.current = cur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PortedFrom(file="Taxonomy.h", name="getRelativesInfo")
    public boolean getRelativesInfo(TaxonomyVertex node, SupConceptActor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        try {
            if (needCurrent) {
                if (!actor.apply(node)) {
                    boolean bl = false;
                    return bl;
                }
                if (onlyDirect) {
                    boolean bl = true;
                    return bl;
                }
            }
            LinkedList<Iterable<TaxonomyVertex>> queue = new LinkedList<Iterable<TaxonomyVertex>>();
            queue.add(node.neigh(upDirection));
            while (queue.size() > 0) {
                Iterable neigh = (Iterable)queue.remove();
                for (TaxonomyVertex _node : neigh) {
                    if (this.isVisited(_node)) continue;
                    this.setVisited(_node);
                    if (!actor.apply(_node) && onlyDirect) {
                        boolean bl = false;
                        return bl;
                    }
                    if (onlyDirect) continue;
                    queue.add(_node.neigh(upDirection));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.clearVisited();
        }
    }

    @PortedFrom(file="Taxonomy.h", name="getRelativesInfo")
    public void getRelativesInfo(TaxonomyVertex node, Actor actor, boolean needCurrent, boolean onlyDirect, boolean upDirection) {
        if (needCurrent && actor.apply(node) && onlyDirect) {
            return;
        }
        LinkedList<TaxonomyVertex> queue = new LinkedList<TaxonomyVertex>();
        for (TaxonomyVertex v : node.neigh(upDirection)) {
            queue.add(v);
        }
        HashSet<TaxonomyVertex> pastBoundary = new HashSet<TaxonomyVertex>();
        while (queue.size() > 0) {
            TaxonomyVertex _node = (TaxonomyVertex)queue.remove(0);
            if (this.isVisited(_node)) continue;
            this.setVisited(_node);
            boolean applied = actor.apply(_node);
            if (applied && onlyDirect) {
                for (TaxonomyVertex boundary : _node.neigh(upDirection)) {
                    this.setAllVisited(boundary, upDirection, pastBoundary);
                }
                continue;
            }
            for (TaxonomyVertex v : _node.neigh(upDirection)) {
                if (!actor.applicable(v) && onlyDirect) continue;
                queue.add(v);
            }
        }
        actor.removePastBoundaries(pastBoundary);
        this.clearVisited();
    }

    @PortedFrom(file="Taxonomy.h", name="setVisited")
    public void setVisited(TaxonomyVertex node) {
        node.setChecked(this.visitedLabel);
    }

    public void setAllVisited(TaxonomyVertex node, boolean direction, Set<TaxonomyVertex> pastBoundary) {
        pastBoundary.add(node);
        this.setVisited(node);
        for (TaxonomyVertex v : node.neigh(direction)) {
            this.setVisited(v);
            this.setAllVisited(v, direction, pastBoundary);
        }
    }

    @PortedFrom(file="Taxonomy.h", name="isVisited")
    public boolean isVisited(TaxonomyVertex node) {
        return node.isChecked(this.visitedLabel);
    }

    @PortedFrom(file="Taxonomy.h", name="clearCheckedLabel")
    protected void clearVisited() {
        ++this.visitedLabel;
    }

    public Taxonomy(ClassifiableEntry pTop, ClassifiableEntry pBottom, JFactReasonerConfiguration c) {
        this.options = c;
        this.graph.add(new TaxonomyVertex(pBottom));
        this.graph.add(new TaxonomyVertex(pTop));
        this.FreshNode.addNeighbour(true, this.getTopVertex());
        this.FreshNode.addNeighbour(false, this.getBottomVertex());
    }

    public JFactReasonerConfiguration getOptions() {
        return this.options;
    }

    @PortedFrom(file="Taxonomy.h", name="getTopVertex")
    public TaxonomyVertex getTopVertex() {
        return this.graph.get(1);
    }

    @PortedFrom(file="Taxonomy.h", name="getBottomVertex")
    public TaxonomyVertex getBottomVertex() {
        return this.graph.get(0);
    }

    @PortedFrom(file="Taxonomy.h", name="getFreshVertex")
    public TaxonomyVertex getFreshVertex(ClassifiableEntry e) {
        this.FreshNode.setSample(e, false);
        return this.FreshNode;
    }

    public String toString() {
        StringBuilder o = new StringBuilder();
        o.append("All entries are in format:\n\"entry\" {n: parent_1 ... parent_n} {m: child_1 child_m}\n\n");
        TreeSet<TaxonomyVertex> sorted = new TreeSet<TaxonomyVertex>(new Comparator<TaxonomyVertex>(){

            @Override
            public int compare(TaxonomyVertex o1, TaxonomyVertex o2) {
                return o1.getPrimer().getName().compareTo((OWLObject)o2.getPrimer().getName());
            }
        });
        sorted.addAll(this.graph.subList(1, this.graph.size()));
        for (TaxonomyVertex p : sorted) {
            o.append(p);
        }
        o.append(this.getBottomVertex());
        return o.toString();
    }

    @PortedFrom(file="Taxonomy.h", name="removeNode")
    public void removeNode(TaxonomyVertex node) {
        node.setInUse(false);
    }

    @PortedFrom(file="Taxonomy.h", name="queryMode")
    public boolean queryMode() {
        return !this.willInsertIntoTaxonomy;
    }

    @PortedFrom(file="Taxonomy.h", name="finalise")
    public void finalise() {
        boolean upDirection = false;
        for (int i = 1; i < this.graph.size(); ++i) {
            TaxonomyVertex p = this.graph.get(i);
            if (!p.noNeighbours(upDirection)) continue;
            p.addNeighbour(upDirection, this.getBottomVertex());
            this.getBottomVertex().addNeighbour(!upDirection, p);
        }
        this.willInsertIntoTaxonomy = false;
    }

    @PortedFrom(file="Taxonomy.h", name="deFinalise")
    public void deFinalise() {
        boolean upDirection = true;
        TaxonomyVertex bot = this.getBottomVertex();
        for (TaxonomyVertex p : bot.neigh(upDirection)) {
            p.removeLink(!upDirection, bot);
        }
        bot.clearLinks(upDirection);
        this.willInsertIntoTaxonomy = true;
    }

    @PortedFrom(file="Taxonomy.h", name="addCurrentToSynonym")
    public void addCurrentToSynonym(TaxonomyVertex syn) {
        ClassifiableEntry currentEntry = this.current.getPrimer();
        if (this.queryMode()) {
            syn.setVertexAsHost(currentEntry);
        } else {
            syn.addSynonym(currentEntry);
            this.options.getLog().print((Object)"\nTAX:set ", (Object)currentEntry.getName(), (Object)" equal ", (Object)syn.getPrimer().getName());
        }
    }

    @PortedFrom(file="Taxonomy.h", name="finishCurrentNode")
    public void finishCurrentNode() {
        TaxonomyVertex syn = this.current.getSynonymNode();
        if (syn != null) {
            this.addCurrentToSynonym(syn);
        } else if (!this.queryMode()) {
            this.current.incorporate(this.options);
            this.graph.add(this.current);
            this.current = new TaxonomyVertex();
        }
    }

    @PortedFrom(file="TaxonomyCreator.cpp", name="processSynonym")
    protected boolean processSynonym() {
        ClassifiableEntry currentEntry = this.current.getPrimer();
        ClassifiableEntry syn = ClassifiableEntry.resolveSynonym(currentEntry);
        if (syn.equals(currentEntry)) {
            return false;
        }
        if (syn.isClassified()) {
            this.addCurrentToSynonym(syn.getTaxVertex());
            return true;
        }
        return false;
    }

    public void clearLabels() {
        ++this.visitedLabel;
    }
}

