/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.PortedFrom;
import java.io.Serializable;
import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.SemanticLocalityChecker;
import uk.ac.manchester.cs.jfact.split.SyntacticLocalityChecker;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TSignature;

@PortedFrom(file="OntologyBasedModularizer.h", name="OntologyBasedModularizer")
public class OntologyBasedModularizer
implements Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="OntologyBasedModularizer.h", name="Ontology")
    private final Ontology ontology;
    private final TModularizer Modularizer;

    @PortedFrom(file="OntologyBasedModularizer.h", name="OntologyBasedModularizer")
    public OntologyBasedModularizer(Ontology ontology, TModularizer mod) {
        this.ontology = ontology;
        this.Modularizer = mod;
    }

    public static TModularizer buildTModularizer(boolean useSemantic, ReasoningKernel kernel) {
        TModularizer Mod = null;
        if (useSemantic) {
            Mod = new TModularizer(kernel.getOptions(), new SemanticLocalityChecker(kernel));
            Mod.preprocessOntology(kernel.getOntology().getAxioms());
        } else {
            Mod = new TModularizer(kernel.getOptions(), new SyntacticLocalityChecker());
            Mod.preprocessOntology(kernel.getOntology().getAxioms());
        }
        return Mod;
    }

    @PortedFrom(file="OntologyBasedModularizer.h", name="getModule")
    public List<AxiomInterface> getModule(TSignature sig, ModuleType type) {
        return this.getModule(this.ontology.getAxioms(), sig, type);
    }

    @PortedFrom(file="OntologyBasedModularizer.h", name="getModule")
    public List<AxiomInterface> getModule(List<AxiomInterface> axioms, TSignature sig, ModuleType type) {
        this.Modularizer.extract(axioms, sig, type);
        return this.Modularizer.getModule();
    }

    @PortedFrom(file="OntologyBasedModularizer.h", name="getModularizer")
    public TModularizer getModularizer() {
        return this.Modularizer;
    }
}

