/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.Original;
import conformance.PortedFrom;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.manchester.cs.jfact.kernel.ExpressionCache;
import uk.ac.manchester.cs.jfact.kernel.ExpressionManager;
import uk.ac.manchester.cs.jfact.kernel.ReasoningKernel;
import uk.ac.manchester.cs.jfact.kernel.dl.ObjectRoleChain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDeclaration;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomFairnessConstraint;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.AxiomInterface;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.NamedEntity;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.RoleExpression;
import uk.ac.manchester.cs.jfact.split.ExpressionFromAxiomBuilder;
import uk.ac.manchester.cs.jfact.split.LocalityChecker;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.visitors.DLAxiomVisitor;

@PortedFrom(file="SemanticLocalityChecker.h", name="SemanticLocalityChecker")
public class SemanticLocalityChecker
implements DLAxiomVisitor,
LocalityChecker,
Serializable {
    private static final long serialVersionUID = 11000L;
    @PortedFrom(file="SemanticLocalityChecker.h", name="Kernel")
    private final ReasoningKernel Kernel;
    @PortedFrom(file="SemanticLocalityChecker.h", name="pEM")
    private final ExpressionCache pEM;
    @PortedFrom(file="SemanticLocalityChecker.h", name="ExprMap")
    private final Map<AxiomInterface, ConceptExpression> ExprMap = new HashMap<AxiomInterface, ConceptExpression>();
    @PortedFrom(file="LocalityChecker.h", name="sig")
    private TSignature sig;
    @PortedFrom(file="SemanticLocalityChecker.h", name="isLocal")
    private boolean isLocal;

    @PortedFrom(file="SemanticLocalityChecker.h", name="getExpr")
    protected ConceptExpression getExpr(AxiomInterface axiom) {
        return axiom.accept(new ExpressionFromAxiomBuilder(null));
    }

    @Override
    @Original
    public TSignature getSignature() {
        return this.sig;
    }

    @Override
    @Original
    public void setSignatureValue(TSignature Sig) {
        this.sig = Sig;
        this.Kernel.setSignature(this.sig);
    }

    public SemanticLocalityChecker(ReasoningKernel k) {
        this.Kernel = k;
        this.isLocal = true;
        this.pEM = this.Kernel.getExpressionManager();
    }

    @Override
    @Original
    public boolean local(AxiomInterface axiom) {
        axiom.accept(this);
        return this.isLocal;
    }

    @Override
    @PortedFrom(file="SemanticLocalityChecker.h", name="preprocessOntology")
    public void preprocessOntology(Collection<AxiomInterface> axioms) {
        TSignature s = new TSignature();
        this.ExprMap.clear();
        for (AxiomInterface q : axioms) {
            this.ExprMap.put(q, this.getExpr(q));
            s.add(q.getSignature());
        }
        this.Kernel.clearKB();
        for (NamedEntity p : s.begin()) {
            this.Kernel.getOntology().add(new AxiomDeclaration(null, (Expression)((Object)p)));
        }
        this.Kernel.realiseKB();
        this.Kernel.setSignature(this.getSignature());
        this.Kernel.setIgnoreExprCache(true);
    }

    @Override
    public void visit(AxiomDeclaration axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentConcepts axiom) {
        this.isLocal = false;
        List arguments = axiom.getArguments();
        int size = arguments.size();
        ConceptExpression C = (ConceptExpression)arguments.get(0);
        for (int i = 1; i < size; ++i) {
            ConceptExpression p = (ConceptExpression)arguments.get(i);
            if (this.Kernel.isEquivalent(C, p)) continue;
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointConcepts axiom) {
        this.isLocal = false;
        List arguments = axiom.getArguments();
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            ConceptExpression p = (ConceptExpression)arguments.get(i);
            for (int j = i + 1; j < size; ++j) {
                ConceptExpression q = (ConceptExpression)arguments.get(j);
                if (this.Kernel.isDisjoint(p, q)) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointUnion axiom) {
        this.isLocal = false;
        List<ConceptExpression> arguments = axiom.getArguments();
        if (!this.Kernel.isEquivalent(axiom.getConcept(), ExpressionManager.or(arguments))) {
            return;
        }
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (this.Kernel.isDisjoint(arguments.get(i), arguments.get(j))) continue;
                return;
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentORoles axiom) {
        this.isLocal = false;
        List arguments = axiom.getArguments();
        int size = arguments.size();
        ObjectRoleExpression R = (ObjectRoleExpression)arguments.get(0);
        for (int i = 1; i < size; ++i) {
            if (this.Kernel.isSubRoles(R, (RoleExpression)arguments.get(i)) && this.Kernel.isSubRoles((RoleExpression)arguments.get(i), R)) continue;
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentDRoles axiom) {
        this.isLocal = false;
        List arguments = axiom.getArguments();
        DataRoleExpression R = (DataRoleExpression)arguments.get(0);
        for (int i = 1; i < arguments.size(); ++i) {
            if (this.Kernel.isSubRoles(R, (RoleExpression)arguments.get(i)) && this.Kernel.isSubRoles((RoleExpression)arguments.get(i), R)) continue;
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointORoles axiom) {
        this.isLocal = this.Kernel.isDisjointRoles(axiom.getArguments());
    }

    @Override
    public void visit(AxiomDisjointDRoles axiom) {
        this.isLocal = this.Kernel.isDisjointRoles(axiom.getArguments());
    }

    @Override
    public void visit(AxiomSameIndividuals axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(AxiomDifferentIndividuals axiom) {
        this.isLocal = false;
    }

    @Override
    public void visit(AxiomFairnessConstraint axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomRoleInverse axiom) {
        this.isLocal = this.Kernel.isSubRoles(axiom.getRole(), this.pEM.inverse(axiom.getInvRole())) && this.Kernel.isSubRoles(axiom.getInvRole(), this.pEM.inverse(axiom.getRole()));
    }

    @Override
    public void visit(AxiomORoleSubsumption axiom) {
        if (axiom.getSubRole() instanceof ObjectRoleChain) {
            this.isLocal = this.Kernel.isSubChain(axiom.getRole(), ((ObjectRoleChain)axiom.getSubRole()).getArguments());
            return;
        }
        if (axiom.getSubRole() instanceof ObjectRoleExpression) {
            this.isLocal = this.Kernel.isSubRoles(axiom.getSubRole(), axiom.getRole());
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDRoleSubsumption axiom) {
        this.isLocal = this.Kernel.isSubRoles(axiom.getSubRole(), axiom.getRole());
    }

    @Override
    public void visit(AxiomORoleDomain axiom) {
        this.isLocal = this.Kernel.isSubsumedBy(this.ExprMap.get(axiom), axiom.getDomain());
    }

    @Override
    public void visit(AxiomDRoleDomain axiom) {
        this.isLocal = this.Kernel.isSubsumedBy(this.ExprMap.get(axiom), axiom.getDomain());
    }

    @Override
    public void visit(AxiomORoleRange axiom) {
        this.isLocal = !this.Kernel.isSatisfiable(this.ExprMap.get(axiom));
    }

    @Override
    public void visit(AxiomDRoleRange axiom) {
        this.isLocal = !this.Kernel.isSatisfiable(this.ExprMap.get(axiom));
    }

    @Override
    public void visit(AxiomRoleTransitive axiom) {
        this.isLocal = this.Kernel.isTransitive(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleReflexive axiom) {
        this.isLocal = this.Kernel.isReflexive(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleIrreflexive axiom) {
        this.isLocal = this.Kernel.isIrreflexive(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleSymmetric axiom) {
        this.isLocal = this.Kernel.isSymmetric(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleAsymmetric axiom) {
        this.isLocal = this.Kernel.isAsymmetric(axiom.getRole());
    }

    @Override
    public void visit(AxiomORoleFunctional axiom) {
        this.isLocal = this.Kernel.isFunctional(axiom.getRole());
    }

    @Override
    public void visit(AxiomDRoleFunctional axiom) {
        this.isLocal = this.Kernel.isFunctional(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleInverseFunctional axiom) {
        this.isLocal = this.Kernel.isInverseFunctional(axiom.getRole());
    }

    @Override
    public void visit(AxiomConceptInclusion axiom) {
        this.isLocal = this.Kernel.isSubsumedBy(axiom.getSubConcept(), axiom.getSupConcept());
    }

    @Override
    public void visit(AxiomInstanceOf axiom) {
        this.isLocal = this.Kernel.isInstance(axiom.getIndividual(), axiom.getC());
    }

    @Override
    public void visit(AxiomRelatedTo axiom) {
        this.isLocal = this.Kernel.isInstance(axiom.getIndividual(), this.ExprMap.get(axiom));
    }

    @Override
    public void visit(AxiomRelatedToNot axiom) {
        this.isLocal = this.Kernel.isInstance(axiom.getIndividual(), this.ExprMap.get(axiom));
    }

    @Override
    public void visit(AxiomValueOf axiom) {
        this.isLocal = this.Kernel.isInstance(axiom.getIndividual(), this.ExprMap.get(axiom));
    }

    @Override
    public void visit(AxiomValueOfNot axiom) {
        this.isLocal = this.Kernel.isInstance(axiom.getIndividual(), this.ExprMap.get(axiom));
    }
}

