/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import conformance.PortedFrom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.options.JFactReasonerConfiguration;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.SyntacticLocalityChecker;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSplitVar;

@PortedFrom(file="AxiomSplitter.h", name="TAxiomSplitter")
public class TAxiomSplitter {
    @PortedFrom(file="AxiomSplitter.h", name="SubNames")
    protected Set<ConceptName> SubNames = new HashSet<ConceptName>();
    @PortedFrom(file="AxiomSplitter.h", name="Rejects")
    protected Set<ConceptName> Rejects = new HashSet<ConceptName>();
    @PortedFrom(file="AxiomSplitter.h", name="Renames")
    protected List<TRecord> Renames = new ArrayList<TRecord>();
    @PortedFrom(file="AxiomSplitter.h", name="R2")
    protected List<TRecord> R2 = new ArrayList<TRecord>();
    @PortedFrom(file="AxiomSplitter.h", name="ImpRens")
    protected Map<ConceptName, TRecord> ImpRens = new HashMap<ConceptName, TRecord>();
    @PortedFrom(file="AxiomSplitter.h", name="ImplNames")
    protected Map<ConceptName, Set<AxiomConceptInclusion>> ImplNames = new HashMap<ConceptName, Set<AxiomConceptInclusion>>();
    @PortedFrom(file="AxiomSplitter.h", name="newNameId")
    private int newNameId = 0;
    @PortedFrom(file="AxiomSplitter.h", name="sig")
    protected TSignature sig = new TSignature();
    @PortedFrom(file="AxiomSplitter.h", name="mod")
    protected TModularizer mod = null;
    @PortedFrom(file="AxiomSplitter.h", name="RejSplits")
    protected Set<TSplitVar> RejSplits = new HashSet<TSplitVar>();
    @PortedFrom(file="AxiomSplitter.h", name="O")
    protected Ontology O;

    @PortedFrom(file="AxiomSplitter.h", name="rename")
    protected ConceptName rename(ConceptName oldName) {
        ConceptExpression c = this.O.getExpressionManager().concept(oldName.getName() + "+" + ++this.newNameId);
        if (c instanceof ConceptName) {
            return (ConceptName)c;
        }
        return null;
    }

    @PortedFrom(file="AxiomSplitter.h", name="processRec")
    public void processRec(TRecord rec) {
        this.mod.getSigIndex().preprocessOntology(rec.oldAxioms);
        this.mod.getSigIndex().processAx(rec.newAxiom);
    }

    @PortedFrom(file="AxiomSplitter.h", name="registerRec")
    void registerRec(TRecord rec) {
        for (Axiom p : rec.oldAxioms) {
            this.O.retract(p);
        }
        this.O.add(rec.newAxiom);
        this.processRec(rec);
    }

    @PortedFrom(file="AxiomSplitter.h", name="unregisterRec")
    void unregisterRec(TRecord rec) {
        for (Axiom p : rec.oldAxioms) {
            p.setUsed(true);
        }
        rec.newAxiom.setUsed(false);
        this.processRec(rec);
    }

    @PortedFrom(file="AxiomSplitter.h", name="buildSig")
    protected void buildSig(TRecord rec) {
        this.sig = rec.newAxiom.getSignature();
        this.mod.extract(this.O.getAxioms(), this.sig, ModuleType.M_STAR);
        rec.newAxSig = this.mod.getSignature();
        rec.Module.clear();
        rec.Module.addAll(this.mod.getModule());
    }

    @PortedFrom(file="AxiomSplitter.h", name="addSingleCI")
    protected void addSingleCI(AxiomConceptInclusion ci) {
        if (ci != null && !(ci.getSupConcept() instanceof ConceptTop) && ci.getSubConcept() instanceof ConceptName) {
            ConceptName name = (ConceptName)ci.getSubConcept();
            this.SubNames.add(name);
            if (!this.ImplNames.containsKey(name)) {
                this.ImplNames.put(name, new HashSet());
            }
            this.ImplNames.get(name).add(ci);
        }
    }

    @PortedFrom(file="AxiomSplitter.h", name="registerCIs")
    protected void registerCIs() {
        for (Axiom axiom : this.O.getAxioms()) {
            if (!axiom.isUsed() || !(axiom instanceof AxiomConceptInclusion)) continue;
            this.addSingleCI((AxiomConceptInclusion)((Object)axiom));
        }
    }

    @PortedFrom(file="AxiomSplitter.h", name="getEqSplit")
    protected ConceptName getEqSplit(AxiomEquivalentConcepts ce) {
        ConceptName splitName = null;
        ConceptName name = null;
        int size = ce.size();
        for (ConceptExpression q : ce.getArguments()) {
            if (!(q instanceof ConceptName)) continue;
            name = (ConceptName)q;
            if (this.SubNames.contains(name)) {
                if (splitName == null) {
                    splitName = name;
                    continue;
                }
                return splitName;
            }
            --size;
        }
        return size > 1 ? splitName : null;
    }

    @PortedFrom(file="AxiomSplitter.h", name="makeEqSplit")
    protected void makeEqSplit(AxiomEquivalentConcepts ce) {
        if (ce == null) {
            return;
        }
        ConceptName splitName = this.getEqSplit(ce);
        if (splitName == null) {
            return;
        }
        TRecord rec = new TRecord();
        rec.oldName = splitName;
        rec.newName = this.rename(splitName);
        rec.setEqAx(ce);
        this.registerRec(rec);
        this.Renames.add(rec);
    }

    @PortedFrom(file="AxiomSplitter.h", name="registerEQ")
    protected void registerEQ() {
        for (int i = 0; i < this.O.size(); ++i) {
            if (!this.O.get(i).isUsed() || !(this.O.get(i) instanceof AxiomEquivalentConcepts)) continue;
            this.makeEqSplit((AxiomEquivalentConcepts)((Object)this.O.get(i)));
        }
    }

    @PortedFrom(file="AxiomSplitter.h", name="makeImpSplit")
    protected TRecord makeImpSplit(ConceptName oldName) {
        ConceptName newName = this.rename(oldName);
        TRecord rec = new TRecord();
        rec.oldName = oldName;
        rec.newName = newName;
        ArrayList<ConceptExpression> args = new ArrayList<ConceptExpression>();
        for (AxiomConceptInclusion s : this.ImplNames.get(oldName)) {
            rec.oldAxioms.add((Axiom)((Object)s));
            args.add(s.getSupConcept());
        }
        rec.setImpAx(this.O.getExpressionManager().and(args));
        this.registerRec(rec);
        return rec;
    }

    @PortedFrom(file="AxiomSplitter.h", name="getImpRec")
    protected TRecord getImpRec(ConceptName oldName) {
        if (!this.ImpRens.containsKey(oldName)) {
            this.ImpRens.put(oldName, this.makeImpSplit(oldName));
        }
        return this.ImpRens.get(oldName);
    }

    @PortedFrom(file="AxiomSplitter.h", name="createAllImplications")
    protected void createAllImplications() {
        for (TRecord r : this.Renames) {
            this.getImpRec(r.oldName);
        }
    }

    @PortedFrom(file="AxiomSplitter.h", name="clearModules")
    protected void clearModules() {
        for (Map.Entry<ConceptName, TRecord> p : this.ImpRens.entrySet()) {
            p.getValue().newAxSig.clear();
        }
        for (TRecord r : this.Renames) {
            r.newAxSig.clear();
        }
    }

    @PortedFrom(file="AxiomSplitter.h", name="checkSplitCorrectness")
    protected boolean checkSplitCorrectness(TRecord rec) {
        if (this.Rejects.contains(rec.oldName)) {
            this.unregisterRec(rec);
            return true;
        }
        TRecord imp = this.getImpRec(rec.oldName);
        if (imp.newAxSig.size() == 0) {
            this.buildSig(imp);
        }
        this.buildSig(rec);
        if (rec.newAxSig.containsNamedEntity(rec.oldName) || !rec.newAxSig.intersect(imp.newAxSig).isEmpty()) {
            this.Rejects.add(rec.oldName);
            this.unregisterRec(imp);
            this.unregisterRec(rec);
            return true;
        }
        this.R2.add(rec);
        return false;
    }

    @PortedFrom(file="AxiomSplitter.h", name="keepIndependentSplits")
    protected void keepIndependentSplits() {
        boolean change;
        do {
            change = false;
            this.clearModules();
            for (TRecord r : this.Renames) {
                change |= this.checkSplitCorrectness(r);
            }
            this.Renames.clear();
            this.Renames.addAll(this.R2);
            this.R2.clear();
        } while (change);
    }

    @PortedFrom(file="AxiomSplitter.h", name="splitImplicationsFor")
    protected TSplitVar splitImplicationsFor(ConceptName oldName) {
        if (this.O.Splits.hasCN(oldName)) {
            return this.O.Splits.get(oldName);
        }
        TRecord rec = this.getImpRec(oldName);
        TSplitVar split = new TSplitVar();
        split.oldName = oldName;
        split.addEntry(rec.newName, rec.newAxSig, rec.Module);
        this.O.Splits.set(oldName, split);
        return split;
    }

    @PortedFrom(file="AxiomSplitter.h", name="splitImplications")
    protected void splitImplications() {
        for (TRecord r : this.Renames) {
            if (!this.Rejects.contains(r.oldName)) {
                TSplitVar split = this.splitImplicationsFor(r.oldName);
                split.addEntry(r.newName, r.newAxSig, r.Module);
                continue;
            }
            this.unregisterRec(r);
        }
    }

    public TAxiomSplitter(JFactReasonerConfiguration config, Ontology o) {
        this.O = o;
        this.mod = new TModularizer(config, new SyntacticLocalityChecker());
    }

    @PortedFrom(file="AxiomSplitter.h", name="buildSplit")
    public void buildSplit() {
        this.registerCIs();
        this.registerEQ();
        if (this.Renames.size() == 0) {
            return;
        }
        this.createAllImplications();
        this.keepIndependentSplits();
        this.splitImplications();
    }

    protected class TRecord {
        ConceptName oldName;
        ConceptName newName;
        List<Axiom> oldAxioms = new ArrayList<Axiom>();
        Axiom newAxiom = null;
        TSignature newAxSig = null;
        Set<Axiom> Module = new HashSet<Axiom>();

        protected TRecord() {
        }

        void setEqAx(AxiomEquivalentConcepts ax) {
            this.oldAxioms.add((Axiom)((Object)ax));
            ArrayList<ConceptExpression> copy = new ArrayList<ConceptExpression>();
            for (ConceptExpression p : ax.getArguments()) {
                if (p.equals(this.oldName)) {
                    copy.add(this.newName);
                    continue;
                }
                copy.add(p);
            }
            this.newAxiom = new AxiomEquivalentConcepts(ax.getOWLAxiom(), (List<ConceptExpression>)copy);
        }

        void setImpAx(ConceptExpression Desc) {
            this.newAxiom = new AxiomConceptInclusion(null, this.newName, Desc);
        }
    }
}

