/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.model;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.rdf.model.AbstractTranslator;
import org.semanticweb.owlapi.rdf.model.RDFGraph;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFTranslator
extends AbstractTranslator<RDFNode, RDFResource, RDFResourceIRI, RDFLiteral> {
    @Nonnull
    private RDFGraph graph = new RDFGraph();

    public RDFTranslator(@Nonnull OWLOntologyManager manager, @Nonnull OWLOntology ontology, boolean useStrongTyping) {
        super(manager, ontology, useStrongTyping);
    }

    public RDFGraph getGraph() {
        return this.graph;
    }

    @Override
    protected void addTriple(@Nonnull RDFResource subject, @Nonnull RDFResourceIRI pred, @Nonnull RDFNode object) {
        this.graph.addTriple(new RDFTriple(OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null"), OWLAPIPreconditions.checkNotNull(pred, "pred cannot be null"), OWLAPIPreconditions.checkNotNull(object, "object cannot be null")));
    }

    @Override
    protected RDFResourceBlankNode getAnonymousNode(Object key) {
        OWLAPIPreconditions.checkNotNull(key, "key cannot be null");
        if (key instanceof OWLAnonymousIndividual) {
            return new RDFResourceBlankNode(System.identityHashCode(((OWLAnonymousIndividual)key).getID().getID()));
        }
        return new RDFResourceBlankNode(System.identityHashCode(key));
    }

    @Override
    protected RDFLiteral getLiteralNode(@Nonnull OWLLiteral literal) {
        return new RDFLiteral(literal);
    }

    @Override
    protected RDFResourceIRI getPredicateNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }

    @Override
    protected RDFResourceIRI getResourceNode(@Nonnull IRI iri) {
        return new RDFResourceIRI(iri);
    }

    public void reset() {
        this.graph = new RDFGraph();
    }
}

