/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class XMLWriterNamespaceManager {
    @Nonnull
    private final Map<String, String> prefixNamespaceMap = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> namespacePrefixMap = new HashMap<String, String>();
    @Nonnull
    private final Map<String, String> wellknownNamespaces = new HashMap<String, String>();
    @Nonnull
    private String defaultNamespace;

    public XMLWriterNamespaceManager(@Nonnull String defaultNamespace) {
        this.defaultNamespace = OWLAPIPreconditions.checkNotNull(defaultNamespace, "defaultNamespace cannot be null");
    }

    public void addWellKnownNamespace(@Nonnull String prefix, @Nonnull String namespace) {
        this.wellknownNamespaces.put(OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null"), OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null"));
    }

    public void setPrefix(@Nonnull String prefix, @Nonnull String namespace) {
        OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null");
        OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
        this.prefixNamespaceMap.put(prefix, namespace);
        this.namespacePrefixMap.put(namespace, prefix);
    }

    @Nullable
    public String getPrefixForNamespace(@Nonnull String namespace) {
        return this.namespacePrefixMap.get(OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null"));
    }

    public void setDefaultNamespace(@Nonnull String namespace) {
        this.defaultNamespace = OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
    }

    @Nullable
    public String getNamespaceForPrefix(@Nonnull String prefix) {
        return this.prefixNamespaceMap.get(OWLAPIPreconditions.checkNotNull(prefix, "prefix cannot be null"));
    }

    @Nullable
    public String getQName(@Nonnull String name) {
        OWLAPIPreconditions.checkNotNull(name, "name cannot be null");
        if (name.startsWith(this.defaultNamespace)) {
            return name.substring(this.defaultNamespace.length(), name.length());
        }
        for (String ns : this.namespacePrefixMap.keySet()) {
            if (!name.startsWith(ns)) continue;
            String localName = name.substring(ns.length(), name.length());
            return this.namespacePrefixMap.get(ns) + ':' + localName;
        }
        return name;
    }

    public String getQName(@Nonnull IRI name) {
        if (name.getNamespace().equals(this.defaultNamespace)) {
            return name.prefixedBy("");
        }
        String candidate = this.namespacePrefixMap.get(name.getNamespace());
        if (candidate != null) {
            return name.prefixedBy(candidate + ':');
        }
        return name.toString();
    }

    public void createPrefixForNamespace(@Nonnull String namespace) {
        OWLAPIPreconditions.checkNotNull(namespace, "namespace cannot be null");
        if (namespace.equals(this.defaultNamespace)) {
            return;
        }
        String prefix = this.wellknownNamespaces.get(namespace);
        if (prefix != null) {
            this.setPrefix(prefix, namespace);
        }
        if (!this.namespacePrefixMap.containsKey(namespace)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace);
        }
    }

    @Nonnull
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Nonnull
    public Iterable<String> getPrefixes() {
        return this.prefixNamespaceMap.keySet();
    }

    @Nonnull
    public Iterable<String> getNamespaces() {
        return this.namespacePrefixMap.keySet();
    }

    @Nonnull
    public String getDefaultPrefix() {
        for (String prefix : this.prefixNamespaceMap.keySet()) {
            String ns;
            if (prefix.isEmpty() || !(ns = this.prefixNamespaceMap.get(prefix)).equals(this.defaultNamespace)) continue;
            return prefix;
        }
        return "";
    }
}

