/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;
import uk.ac.manchester.cs.owl.owlapi.AbstractEntityRegistrationManager;
import uk.ac.manchester.cs.owl.owlapi.ClassAxiomByClassPointer;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;

public class Internals
implements Serializable {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    protected transient MapPointer<OWLClassExpression, OWLClassAssertionAxiom> classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS);
    @Nonnull
    protected transient MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom> annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLSubClassOfAxiom> subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLClassAxiom> classAxiomsByClass = this.buildClassAxiomByClass();
    @Nonnull
    protected transient MapPointer<OWLClass, OWLEquivalentClassesAxiom> equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLDisjointClassesAxiom> disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLDisjointUnionAxiom> disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLClass, OWLHasKeyAxiom> hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLDisjointObjectPropertiesAxiom> disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyDomainAxiom> objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLObjectPropertyRangeAxiom> objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLSymmetricObjectPropertyAxiom> symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLAsymmetricObjectPropertyAxiom> asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLReflexiveObjectPropertyAxiom> reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLIrreflexiveObjectPropertyAxiom> irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLTransitiveObjectPropertyAxiom> transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLObjectPropertyExpression, OWLInverseObjectPropertiesAxiom> inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLEquivalentDataPropertiesAxiom> equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLDisjointDataPropertiesAxiom> disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyDomainAxiom> dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLDataPropertyRangeAxiom> dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLDataPropertyExpression, OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLClassAssertionAxiom> classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLObjectPropertyAssertionAxiom> objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLDataPropertyAssertionAxiom> dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLDifferentIndividualsAxiom> differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS);
    @Nonnull
    protected transient MapPointer<OWLIndividual, OWLSameIndividualAxiom> sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS);
    @Nonnull
    protected SetPointer<OWLImportsDeclaration> importsDeclarations = new SetPointer();
    @Nonnull
    protected SetPointer<OWLAnnotation> ontologyAnnotations = new SetPointer();
    @Nonnull
    protected SetPointer<OWLClassAxiom> generalClassAxioms = new SetPointer();
    @Nonnull
    protected SetPointer<OWLSubPropertyChainOfAxiom> propertyChainSubPropertyAxioms = new SetPointer();
    @Nonnull
    protected transient MapPointer<AxiomType<?>, OWLAxiom> axiomsByType = this.build();
    @Nonnull
    protected transient MapPointer<OWLClass, OWLAxiom> owlClassReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLObjectProperty, OWLAxiom> owlObjectPropertyReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLDataProperty, OWLAxiom> owlDataPropertyReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLNamedIndividual, OWLAxiom> owlIndividualReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLAnonymousIndividual, OWLAxiom> owlAnonymousIndividualReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLDatatype, OWLAxiom> owlDatatypeReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLAnnotationProperty, OWLAxiom> owlAnnotationPropertyReferences = this.build();
    @Nonnull
    protected transient MapPointer<OWLEntity, OWLDeclarationAxiom> declarationsByEntity = this.build();
    @Nullable
    private List<OWLAxiom> axiomsForSerialization;
    @Nonnull
    private final AddAxiomVisitor addChangeVisitor = new AddAxiomVisitor();
    @Nonnull
    private final RemoveAxiomVisitor removeChangeVisitor = new RemoveAxiomVisitor();
    @Nonnull
    private final ReferenceChecker refChecker = new ReferenceChecker();
    @Nonnull
    private final ReferencedAxiomsCollector refAxiomsCollector = new ReferencedAxiomsCollector();

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.axiomsByType = this.build();
        this.owlClassReferences = this.build();
        this.owlObjectPropertyReferences = this.build();
        this.owlDataPropertyReferences = this.build();
        this.owlIndividualReferences = this.build();
        this.owlAnonymousIndividualReferences = this.build();
        this.owlDatatypeReferences = this.build();
        this.owlAnnotationPropertyReferences = this.build();
        this.declarationsByEntity = this.build();
        this.classAssertionAxiomsByClass = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.CLASSEXPRESSIONS);
        this.annotationAssertionAxiomsBySubject = this.buildLazy(AxiomType.ANNOTATION_ASSERTION, InitVisitorFactory.ANNOTSUPERNAMED);
        this.subClassAxiomsBySubPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUBNAMED);
        this.subClassAxiomsBySuperPosition = this.buildLazy(AxiomType.SUBCLASS_OF, InitVisitorFactory.CLASSSUPERNAMED);
        this.objectSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.objectSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_OBJECT_PROPERTY, InitVisitorFactory.OPSUPERNAMED);
        this.dataSubPropertyAxiomsBySubPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
        this.dataSubPropertyAxiomsBySuperPosition = this.buildLazy(AxiomType.SUB_DATA_PROPERTY, InitVisitorFactory.DPSUPERNAMED);
        this.classAxiomsByClass = this.buildClassAxiomByClass();
        this.equivalentClassesAxiomsByClass = this.buildLazy(AxiomType.EQUIVALENT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
        this.disjointClassesAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_CLASSES, InitVisitorFactory.CLASSCOLLECTIONS);
        this.disjointUnionAxiomsByClass = this.buildLazy(AxiomType.DISJOINT_UNION, InitVisitorFactory.CLASSCOLLECTIONS);
        this.hasKeyAxiomsByClass = this.buildLazy(AxiomType.HAS_KEY, InitVisitorFactory.CLASSSUPERNAMED);
        this.equivalentObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.disjointObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.objectPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_DOMAIN, InitVisitorFactory.OPSUBNAMED);
        this.objectPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.OBJECT_PROPERTY_RANGE, InitVisitorFactory.OPSUBNAMED);
        this.functionalObjectPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.inverseFunctionalPropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.symmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.SYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.asymmetricPropertyAxiomsByProperty = this.buildLazy(AxiomType.ASYMMETRIC_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.reflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.REFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.irreflexivePropertyAxiomsByProperty = this.buildLazy(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.transitivePropertyAxiomsByProperty = this.buildLazy(AxiomType.TRANSITIVE_OBJECT_PROPERTY, InitVisitorFactory.OPSUBNAMED);
        this.inversePropertyAxiomsByProperty = this.buildLazy(AxiomType.INVERSE_OBJECT_PROPERTIES, InitVisitorFactory.OPCOLLECTIONS);
        this.equivalentDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.EQUIVALENT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
        this.disjointDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.DISJOINT_DATA_PROPERTIES, InitVisitorFactory.DPCOLLECTIONS);
        this.dataPropertyDomainAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_DOMAIN, InitVisitorFactory.DPSUBNAMED);
        this.dataPropertyRangeAxiomsByProperty = this.buildLazy(AxiomType.DATA_PROPERTY_RANGE, InitVisitorFactory.DPSUBNAMED);
        this.functionalDataPropertyAxiomsByProperty = this.buildLazy(AxiomType.FUNCTIONAL_DATA_PROPERTY, InitVisitorFactory.DPSUBNAMED);
        this.classAssertionAxiomsByIndividual = this.buildLazy(AxiomType.CLASS_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.objectPropertyAssertionsByIndividual = this.buildLazy(AxiomType.OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.dataPropertyAssertionsByIndividual = this.buildLazy(AxiomType.DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.negativeObjectPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.negativeDataPropertyAssertionAxiomsByIndividual = this.buildLazy(AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, InitVisitorFactory.INDIVIDUALSUBNAMED);
        this.differentIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.DIFFERENT_INDIVIDUALS, InitVisitorFactory.ICOLLECTIONS);
        this.sameIndividualsAxiomsByIndividual = this.buildLazy(AxiomType.SAME_INDIVIDUAL, InitVisitorFactory.ICOLLECTIONS);
        for (OWLAxiom ax : this.axiomsForSerialization) {
            this.addAxiom(ax);
        }
        this.axiomsForSerialization = null;
    }

    public void trimToSize() {
        this.axiomsByType.trimToSize();
        this.owlClassReferences.trimToSize();
        this.owlObjectPropertyReferences.trimToSize();
        this.owlDataPropertyReferences.trimToSize();
        this.owlIndividualReferences.trimToSize();
        this.owlAnonymousIndividualReferences.trimToSize();
        this.owlDatatypeReferences.trimToSize();
        this.owlAnnotationPropertyReferences.trimToSize();
        this.declarationsByEntity.trimToSize();
        this.classAssertionAxiomsByClass.trimToSize();
        this.annotationAssertionAxiomsBySubject.trimToSize();
        this.subClassAxiomsBySubPosition.trimToSize();
        this.subClassAxiomsBySuperPosition.trimToSize();
        this.objectSubPropertyAxiomsBySubPosition.trimToSize();
        this.objectSubPropertyAxiomsBySuperPosition.trimToSize();
        this.dataSubPropertyAxiomsBySubPosition.trimToSize();
        this.dataSubPropertyAxiomsBySuperPosition.trimToSize();
        this.classAxiomsByClass.trimToSize();
        this.equivalentClassesAxiomsByClass.trimToSize();
        this.disjointClassesAxiomsByClass.trimToSize();
        this.disjointUnionAxiomsByClass.trimToSize();
        this.hasKeyAxiomsByClass.trimToSize();
        this.equivalentObjectPropertyAxiomsByProperty.trimToSize();
        this.disjointObjectPropertyAxiomsByProperty.trimToSize();
        this.objectPropertyDomainAxiomsByProperty.trimToSize();
        this.objectPropertyRangeAxiomsByProperty.trimToSize();
        this.functionalObjectPropertyAxiomsByProperty.trimToSize();
        this.inverseFunctionalPropertyAxiomsByProperty.trimToSize();
        this.symmetricPropertyAxiomsByProperty.trimToSize();
        this.asymmetricPropertyAxiomsByProperty.trimToSize();
        this.reflexivePropertyAxiomsByProperty.trimToSize();
        this.irreflexivePropertyAxiomsByProperty.trimToSize();
        this.transitivePropertyAxiomsByProperty.trimToSize();
        this.inversePropertyAxiomsByProperty.trimToSize();
        this.equivalentDataPropertyAxiomsByProperty.trimToSize();
        this.disjointDataPropertyAxiomsByProperty.trimToSize();
        this.dataPropertyDomainAxiomsByProperty.trimToSize();
        this.dataPropertyRangeAxiomsByProperty.trimToSize();
        this.functionalDataPropertyAxiomsByProperty.trimToSize();
        this.classAssertionAxiomsByIndividual.trimToSize();
        this.objectPropertyAssertionsByIndividual.trimToSize();
        this.dataPropertyAssertionsByIndividual.trimToSize();
        this.negativeObjectPropertyAssertionAxiomsByIndividual.trimToSize();
        this.negativeDataPropertyAssertionAxiomsByIndividual.trimToSize();
        this.differentIndividualsAxiomsByIndividual.trimToSize();
        this.sameIndividualsAxiomsByIndividual.trimToSize();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.axiomsForSerialization = new ArrayList<OWLAxiom>();
        Iterables.addAll(this.axiomsForSerialization, this.axiomsByType.getAllValues());
        stream.defaultWriteObject();
    }

    public boolean containsClassInSignature(IRI i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(IRI i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(IRI i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(IRI i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(IRI i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(IRI i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    public boolean containsClassInSignature(OWLClass i) {
        return this.owlClassReferences.containsReference(i);
    }

    public boolean containsObjectPropertyInSignature(OWLObjectProperty i) {
        return this.owlObjectPropertyReferences.containsReference(i);
    }

    public boolean containsDataPropertyInSignature(OWLDataProperty i) {
        return this.owlDataPropertyReferences.containsReference(i);
    }

    public boolean containsAnnotationPropertyInSignature(OWLAnnotationProperty i) {
        return this.owlAnnotationPropertyReferences.containsReference(i);
    }

    public boolean containsIndividualInSignature(OWLNamedIndividual i) {
        return this.owlIndividualReferences.containsReference(i);
    }

    public boolean containsDatatypeInSignature(OWLDatatype i) {
        return this.owlDatatypeReferences.containsReference(i);
    }

    @Nonnull
    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(@Nonnull Class<T> type, @Nonnull Class<A> axiom) {
        return this.get(type, axiom, Navigation.IN_SUB_POSITION);
    }

    @Nonnull
    <T extends OWLObject, A extends OWLAxiom> Optional<MapPointer<T, A>> get(@Nonnull Class<T> type, @Nonnull Class<A> axiom, Navigation position) {
        if (OWLEntity.class.isAssignableFrom(type) && axiom.equals(OWLDeclarationAxiom.class)) {
            return Optional.of(this.declarationsByEntity);
        }
        if (type.equals(OWLClass.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlClassReferences);
        }
        if (type.equals(OWLObjectProperty.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlObjectPropertyReferences);
        }
        if (type.equals(OWLDataProperty.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlDataPropertyReferences);
        }
        if (type.equals(OWLNamedIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlIndividualReferences);
        }
        if (type.equals(OWLAnonymousIndividual.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlAnonymousIndividualReferences);
        }
        if (type.equals(OWLDatatype.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlDatatypeReferences);
        }
        if (type.equals(OWLAnnotationProperty.class) && axiom.equals(OWLAxiom.class)) {
            return Optional.of(this.owlAnnotationPropertyReferences);
        }
        if (type.equals(OWLClassExpression.class)) {
            return Optional.of(this.classAssertionAxiomsByClass);
        }
        if (type.equals(OWLObjectPropertyExpression.class)) {
            if (axiom.equals(OWLSubObjectPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return Optional.of(this.objectSubPropertyAxiomsBySuperPosition);
                }
                return Optional.of(this.objectSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentObjectPropertiesAxiom.class)) {
                return Optional.of(this.equivalentObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointObjectPropertiesAxiom.class)) {
                return Optional.of(this.disjointObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyDomainAxiom.class)) {
                return Optional.of(this.objectPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLObjectPropertyRangeAxiom.class)) {
                return Optional.of(this.objectPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalObjectPropertyAxiom.class)) {
                return Optional.of(this.functionalObjectPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseFunctionalObjectPropertyAxiom.class)) {
                return Optional.of(this.inverseFunctionalPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLSymmetricObjectPropertyAxiom.class)) {
                return Optional.of(this.symmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLAsymmetricObjectPropertyAxiom.class)) {
                return Optional.of(this.asymmetricPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLReflexiveObjectPropertyAxiom.class)) {
                return Optional.of(this.reflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLIrreflexiveObjectPropertyAxiom.class)) {
                return Optional.of(this.irreflexivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLTransitiveObjectPropertyAxiom.class)) {
                return Optional.of(this.transitivePropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLInverseObjectPropertiesAxiom.class)) {
                return Optional.of(this.inversePropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLDataPropertyExpression.class)) {
            if (axiom.equals(OWLSubDataPropertyOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return Optional.of(this.dataSubPropertyAxiomsBySuperPosition);
                }
                return Optional.of(this.dataSubPropertyAxiomsBySubPosition);
            }
            if (axiom.equals(OWLEquivalentDataPropertiesAxiom.class)) {
                return Optional.of(this.equivalentDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDisjointDataPropertiesAxiom.class)) {
                return Optional.of(this.disjointDataPropertyAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyDomainAxiom.class)) {
                return Optional.of(this.dataPropertyDomainAxiomsByProperty);
            }
            if (axiom.equals(OWLDataPropertyRangeAxiom.class)) {
                return Optional.of(this.dataPropertyRangeAxiomsByProperty);
            }
            if (axiom.equals(OWLFunctionalDataPropertyAxiom.class)) {
                return Optional.of(this.functionalDataPropertyAxiomsByProperty);
            }
        }
        if (type.equals(OWLAnnotationSubject.class) || type.equals(IRI.class)) {
            return Optional.of(this.annotationAssertionAxiomsBySubject);
        }
        if (type.equals(OWLIndividual.class)) {
            if (axiom.equals(OWLClassAssertionAxiom.class)) {
                return Optional.of(this.classAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLObjectPropertyAssertionAxiom.class)) {
                return Optional.of(this.objectPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLDataPropertyAssertionAxiom.class)) {
                return Optional.of(this.dataPropertyAssertionsByIndividual);
            }
            if (axiom.equals(OWLNegativeObjectPropertyAssertionAxiom.class)) {
                return Optional.of(this.negativeObjectPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLNegativeDataPropertyAssertionAxiom.class)) {
                return Optional.of(this.negativeDataPropertyAssertionAxiomsByIndividual);
            }
            if (axiom.equals(OWLDifferentIndividualsAxiom.class)) {
                return Optional.of(this.differentIndividualsAxiomsByIndividual);
            }
            if (axiom.equals(OWLSameIndividualAxiom.class)) {
                return Optional.of(this.sameIndividualsAxiomsByIndividual);
            }
        }
        if (type.equals(OWLClass.class)) {
            if (axiom.equals(OWLSubClassOfAxiom.class)) {
                if (position == Navigation.IN_SUPER_POSITION) {
                    return Optional.of(this.subClassAxiomsBySuperPosition);
                }
                return Optional.of(this.subClassAxiomsBySubPosition);
            }
            if (axiom.equals(OWLClassAxiom.class)) {
                return Optional.of(this.classAxiomsByClass);
            }
            if (axiom.equals(OWLEquivalentClassesAxiom.class)) {
                return Optional.of(this.equivalentClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointClassesAxiom.class)) {
                return Optional.of(this.disjointClassesAxiomsByClass);
            }
            if (axiom.equals(OWLDisjointUnionAxiom.class)) {
                return Optional.of(this.disjointUnionAxiomsByClass);
            }
            if (axiom.equals(OWLHasKeyAxiom.class)) {
                return Optional.of(this.hasKeyAxiomsByClass);
            }
        }
        return Optional.absent();
    }

    @Nonnull
    protected <K, V extends OWLAxiom> MapPointer<K, V> build() {
        return this.build(null, null);
    }

    @Nonnull
    protected <K, V extends OWLAxiom> MapPointer<K, V> buildLazy(AxiomType<?> t, OWLAxiomVisitorEx<?> v) {
        return new MapPointer(t, v, false, this);
    }

    @Nonnull
    protected ClassAxiomByClassPointer buildClassAxiomByClass() {
        return new ClassAxiomByClassPointer(null, null, false, this);
    }

    @Nonnull
    protected <K, V extends OWLAxiom> MapPointer<K, V> build(AxiomType<?> t, OWLAxiomVisitorEx<?> v) {
        return new MapPointer(t, v, true, this);
    }

    public boolean addAxiom(final @Nonnull OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        if (this.getAxiomsByType().put(axiom.getAxiomType(), axiom)) {
            axiom.accept(this.addChangeVisitor);
            axiom.accept(new AbstractEntityRegistrationManager(){

                @Override
                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.put(ce, axiom);
                }

                @Override
                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.put(individual, axiom);
                }

                @Override
                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.put(property, axiom);
                }

                @Override
                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.put(node, axiom);
                }

                @Override
                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.put(individual, axiom);
                }
            });
            return true;
        }
        return false;
    }

    public boolean removeAxiom(final @Nonnull OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        if (this.getAxiomsByType().remove(axiom.getAxiomType(), axiom)) {
            axiom.accept(this.removeChangeVisitor);
            AbstractEntityRegistrationManager referenceRemover = new AbstractEntityRegistrationManager(){

                @Override
                public void visit(OWLClass ce) {
                    Internals.this.owlClassReferences.remove(ce, axiom);
                }

                @Override
                public void visit(OWLObjectProperty property) {
                    Internals.this.owlObjectPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLDataProperty property) {
                    Internals.this.owlDataPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLNamedIndividual individual) {
                    Internals.this.owlIndividualReferences.remove(individual, axiom);
                }

                @Override
                public void visit(OWLAnnotationProperty property) {
                    Internals.this.owlAnnotationPropertyReferences.remove(property, axiom);
                }

                @Override
                public void visit(OWLDatatype node) {
                    Internals.this.owlDatatypeReferences.remove(node, axiom);
                }

                @Override
                public void visit(OWLAnonymousIndividual individual) {
                    Internals.this.owlAnonymousIndividualReferences.remove(individual, axiom);
                }
            };
            axiom.accept(referenceRemover);
            return true;
        }
        return false;
    }

    public boolean isDeclared(OWLEntity e) {
        return this.declarationsByEntity.containsKey(e);
    }

    public boolean isEmpty() {
        return this.axiomsByType.isEmpty() && this.ontologyAnnotations.isEmpty();
    }

    @Nonnull
    public <K> Collection<? extends OWLAxiom> filterAxioms(@Nonnull OWLAxiomSearchFilter filter, @Nonnull K key) {
        Optional<MapPointer<OWLAnnotationSubject, OWLAnnotationAssertionAxiom>> mapPointerOptional;
        if (filter == Filters.annotations && (mapPointerOptional = this.get(OWLAnnotationSubject.class, OWLAnnotationAssertionAxiom.class)).isPresent()) {
            MapPointer mapPointer = (MapPointer)mapPointerOptional.get();
            List values = mapPointer.getValues((OWLAnnotationSubject)key);
            return values;
        }
        return this.getAxiomsByType().filterAxioms(filter, key);
    }

    public <K> boolean contains(@Nonnull OWLAxiomSearchFilter filter, @Nonnull K key) {
        for (AxiomType<?> at : filter.getAxiomTypes()) {
            for (OWLAxiom t : this.getAxiomsByType().getValues(at)) {
                assert (t != null);
                if (!filter.pass(t, key)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public Iterable<OWLImportsDeclaration> getImportsDeclarations(boolean copy) {
        if (!copy) {
            return this.importsDeclarations.iterable();
        }
        return this.importsDeclarations.copy();
    }

    public boolean addImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.add(importDeclaration);
    }

    public boolean removeImportsDeclaration(OWLImportsDeclaration importDeclaration) {
        return this.importsDeclarations.remove(importDeclaration);
    }

    @Nonnull
    Iterable<OWLAnnotation> getOntologyAnnotations(boolean copy) {
        if (!copy) {
            return this.ontologyAnnotations.iterable();
        }
        return this.ontologyAnnotations.copy();
    }

    public boolean addOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.add(ann);
    }

    public boolean removeOntologyAnnotation(OWLAnnotation ann) {
        return this.ontologyAnnotations.remove(ann);
    }

    public static <K, V extends OWLAxiom> boolean contains(@Nonnull MapPointer<K, V> p, K k, V v) {
        return p.contains(k, v);
    }

    public int getAxiomCount() {
        return this.axiomsByType.size();
    }

    @Nonnull
    public Iterable<OWLAxiom> getAxioms() {
        return this.axiomsByType.getAllValues();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        if (!this.axiomsByType.isInitialized()) {
            return 0;
        }
        return Iterables.size(this.axiomsByType.getValues(axiomType));
    }

    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        Set<OWLLogicalAxiom> axioms = CollectionFactory.createSet();
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            if (!type.isLogical()) continue;
            for (OWLAxiom ax : this.axiomsByType.getValues(type)) {
                axioms.add((OWLLogicalAxiom)ax);
            }
        }
        return axioms;
    }

    public int getLogicalAxiomCount() {
        int count = 0;
        for (AxiomType<?> type : AxiomType.AXIOM_TYPES) {
            if (!type.isLogical()) continue;
            count += Iterables.size(this.axiomsByType.getValues(type));
        }
        return count;
    }

    @Nonnull
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.generalClassAxioms.copy();
    }

    public boolean addGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.add(ax);
    }

    public boolean removeGeneralClassAxioms(OWLClassAxiom ax) {
        return this.generalClassAxioms.remove(ax);
    }

    public boolean addPropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.add(ax);
    }

    public boolean removePropertyChainSubPropertyAxioms(OWLSubPropertyChainOfAxiom ax) {
        return this.propertyChainSubPropertyAxioms.remove(ax);
    }

    @Nonnull
    public MapPointer<AxiomType<?>, OWLAxiom> getAxiomsByType() {
        return this.axiomsByType;
    }

    @Nonnull
    public String toString() {
        StringBuilder b = new StringBuilder("Internals{(first 20 axioms) ");
        for (OWLAxiom ax : Iterables.limit(this.axiomsByType.getAllValues(), (int)20)) {
            b.append(ax).append('\n');
        }
        b.append('}');
        return b.toString();
    }

    public boolean containsReference(@Nonnull OWLEntity entity) {
        return entity.accept(this.refChecker);
    }

    @Nonnull
    public Iterable<OWLAxiom> getReferencingAxioms(@Nonnull OWLEntity owlEntity) {
        return owlEntity.accept(this.refAxiomsCollector);
    }

    private class ReferencedAxiomsCollector
    implements OWLEntityVisitorEx<Iterable<OWLAxiom>>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        ReferencedAxiomsCollector() {
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLClass cls) {
            return Internals.this.owlClassReferences.getValues(cls);
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.getValues(property);
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.getValues(property);
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.getValues(individual);
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.getValues(datatype);
        }

        @Override
        public Iterable<OWLAxiom> visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.getValues(property);
        }
    }

    class RemoveAxiomVisitor
    extends OWLAxiomVisitorAdapter
    implements Serializable {
        private static final long serialVersionUID = 40000L;

        RemoveAxiomVisitor() {
        }

        @Override
        public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.remove(subClass, axiom);
                Internals.this.classAxiomsByClass.remove(subClass, axiom);
            } else {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.remove(axiom.getSuperClass().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                Internals.this.disjointClassesAxiomsByClass.remove(cls, axiom);
                Internals.this.classAxiomsByClass.remove(cls, axiom);
                allAnon = false;
            }
            if (allAnon) {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                Internals.this.objectPropertyDomainAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                Internals.this.equivalentObjectPropertyAxiomsByProperty.remove(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.remove(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                Internals.this.differentIndividualsAxiomsByIndividual.remove(ind, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                Internals.this.disjointDataPropertyAxiomsByProperty.remove(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                Internals.this.disjointObjectPropertyAxiomsByProperty.remove(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.remove((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.remove((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.remove(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.remove(axiom.getOWLClass(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.remove(axiom.getEntity(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.remove(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.remove((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                Internals.this.equivalentDataPropertyAxiomsByProperty.remove(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.remove(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.remove(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                Internals.this.equivalentClassesAxiomsByClass.remove((OWLClass)desc, axiom);
                Internals.this.classAxiomsByClass.remove((OWLClass)desc, axiom);
                allAnon = false;
            }
            if (allAnon) {
                Internals.this.removeGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.remove(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.remove((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.remove((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.remove((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                Internals.this.sameIndividualsAxiomsByIndividual.remove(ind, axiom);
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.removePropertyChainSubPropertyAxioms(axiom);
        }
    }

    class AddAxiomVisitor
    extends OWLAxiomVisitorAdapter
    implements Serializable {
        private static final long serialVersionUID = 40000L;

        AddAxiomVisitor() {
        }

        @Override
        public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                OWLClass subClass = (OWLClass)axiom.getSubClass();
                Internals.this.subClassAxiomsBySubPosition.put(subClass, axiom);
                Internals.this.classAxiomsByClass.put(subClass, axiom);
            } else {
                Internals.this.addGeneralClassAxioms(axiom);
            }
            if (!axiom.getSuperClass().isAnonymous()) {
                Internals.this.subClassAxiomsBySuperPosition.put((OWLClass)axiom.getSuperClass(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
            Internals.this.negativeObjectPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
            Internals.this.asymmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
            Internals.this.reflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                OWLClass cls = (OWLClass)desc;
                Internals.this.disjointClassesAxiomsByClass.put(cls, axiom);
                Internals.this.classAxiomsByClass.put(cls, axiom);
                allAnon = false;
            }
            if (allAnon) {
                Internals.this.addGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
            Internals.this.dataPropertyDomainAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
            if (axiom.getProperty() instanceof OWLObjectProperty) {
                Internals.this.objectPropertyDomainAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                Internals.this.equivalentObjectPropertyAxiomsByProperty.put(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getFirstProperty(), axiom);
            Internals.this.inversePropertyAxiomsByProperty.put(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
            Internals.this.negativeDataPropertyAssertionAxiomsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                Internals.this.differentIndividualsAxiomsByIndividual.put(ind, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                Internals.this.disjointDataPropertyAxiomsByProperty.put(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                Internals.this.disjointObjectPropertyAxiomsByProperty.put(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
            Internals.this.objectPropertyRangeAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
            Internals.this.objectPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
            Internals.this.functionalObjectPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            Internals.this.objectSubPropertyAxiomsBySubPosition.put((OWLObjectPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.objectSubPropertyAxiomsBySuperPosition.put((OWLObjectPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
            Internals.this.disjointUnionAxiomsByClass.put(axiom.getOWLClass(), axiom);
            Internals.this.classAxiomsByClass.put(axiom.getOWLClass(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDeclarationAxiom axiom) {
            Internals.this.declarationsByEntity.put(axiom.getEntity(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            Internals.this.annotationAssertionAxiomsBySubject.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.hasKeyAxiomsByClass.put(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
            Internals.this.symmetricPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
            Internals.this.dataPropertyRangeAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
            Internals.this.functionalDataPropertyAxiomsByProperty.put((OWLDataPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                Internals.this.equivalentDataPropertyAxiomsByProperty.put(prop, axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
            Internals.this.classAssertionAxiomsByIndividual.put(axiom.getIndividual(), axiom);
            if (!axiom.getClassExpression().isAnonymous()) {
                Internals.this.classAssertionAxiomsByClass.put(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
            boolean allAnon = true;
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (desc.isAnonymous()) continue;
                Internals.this.equivalentClassesAxiomsByClass.put((OWLClass)desc, axiom);
                Internals.this.classAxiomsByClass.put((OWLClass)desc, axiom);
                allAnon = false;
            }
            if (allAnon) {
                Internals.this.addGeneralClassAxioms(axiom);
            }
        }

        @Override
        public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
            Internals.this.dataPropertyAssertionsByIndividual.put(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
            Internals.this.transitivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
            Internals.this.irreflexivePropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            Internals.this.dataSubPropertyAxiomsBySubPosition.put((OWLDataPropertyExpression)axiom.getSubProperty(), axiom);
            Internals.this.dataSubPropertyAxiomsBySuperPosition.put((OWLDataPropertyExpression)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
            Internals.this.inverseFunctionalPropertyAxiomsByProperty.put((OWLObjectPropertyExpression)axiom.getProperty(), axiom);
        }

        @Override
        public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                Internals.this.sameIndividualsAxiomsByIndividual.put(ind, axiom);
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            Internals.this.addPropertyChainSubPropertyAxioms(axiom);
        }
    }

    protected class SetPointer<K extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 40000L;
        @Nonnull
        private final Set<K> set = CollectionFactory.createSyncSet();

        protected SetPointer() {
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Nonnull
        public Set<K> copy() {
            return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.set);
        }

        @Nonnull
        public Iterable<K> iterable() {
            return this.set;
        }

        public boolean add(K k) {
            return this.set.add(k);
        }

        public boolean contains(K k) {
            return this.set.contains(k);
        }

        public boolean remove(K k) {
            return this.set.remove(k);
        }
    }

    private class ReferenceChecker
    implements OWLEntityVisitorEx<Boolean>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        ReferenceChecker() {
        }

        @Override
        public Boolean visit(OWLClass cls) {
            return Internals.this.owlClassReferences.containsKey(cls);
        }

        @Override
        public Boolean visit(OWLObjectProperty property) {
            return Internals.this.owlObjectPropertyReferences.containsKey(property);
        }

        @Override
        public Boolean visit(OWLDataProperty property) {
            return Internals.this.owlDataPropertyReferences.containsKey(property);
        }

        @Override
        public Boolean visit(OWLNamedIndividual individual) {
            return Internals.this.owlIndividualReferences.containsKey(individual);
        }

        @Override
        public Boolean visit(OWLDatatype datatype) {
            return Internals.this.owlDatatypeReferences.containsKey(datatype);
        }

        @Override
        public Boolean visit(OWLAnnotationProperty property) {
            return Internals.this.owlAnnotationPropertyReferences.containsKey(property);
        }
    }
}

