/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.modularity.OntologySegmenter;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyntacticLocalityModuleExtractor.class);
    @Nonnull
    private ModuleType moduleType;
    private final OntologyAxiomSet ontologyAxiomSet;
    @Nonnull
    private final OWLOntology rootOntology;
    @Nonnull
    private final OWLOntology ontology;
    private final OWLOntologyManager manager;

    @Nonnull
    private static OWLOntology createOntology(@Nonnull OWLOntologyManager man, @Nonnull OWLOntology ont, @Nonnull Set<OWLAxiom> axs) {
        try {
            return man.createOntology(axs);
        }
        catch (OWLOntologyCreationException e) {
            return ont;
        }
    }

    public SyntacticLocalityModuleExtractor(@Nonnull OWLOntologyManager man, @Nonnull OWLOntology ont, @Nonnull Set<OWLAxiom> axs, @Nonnull ModuleType moduleType) {
        this.moduleType = OWLAPIPreconditions.checkNotNull(moduleType, "moduleType cannot be null");
        this.manager = OWLAPIPreconditions.checkNotNull(man, "man cannot be null");
        this.rootOntology = OWLAPIPreconditions.checkNotNull(ont, "ont cannot be null");
        this.ontologyAxiomSet = new OntologyAxiomSet(axs);
        this.ontology = OWLAPIPreconditions.checkNotNull(SyntacticLocalityModuleExtractor.createOntology(man, ont, axs));
    }

    public SyntacticLocalityModuleExtractor(@Nonnull OWLOntologyManager man, @Nonnull OWLOntology ont, @Nonnull ModuleType moduleType) {
        this(man, ont, SyntacticLocalityModuleExtractor.asAxiomSet(ont), moduleType);
    }

    @Nonnull
    private static Set<OWLAxiom> asAxiomSet(OWLOntology ont) {
        HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>(ont.getAxioms());
        for (OWLOntology importedOnt : ont.getImportsClosure()) {
            axs.addAll(importedOnt.getAxioms());
        }
        return axs;
    }

    public void setModuleType(@Nonnull ModuleType moduleType) {
        this.moduleType = OWLAPIPreconditions.checkNotNull(moduleType, "moduleType cannot be null");
    }

    @Nonnull
    public ModuleType getModuleType() {
        return this.moduleType;
    }

    @Nonnull
    boolean[] extractLogicalAxioms(@Nonnull boolean[] subOnt, @Nonnull Set<OWLEntity> signature, @Nonnull LocalityClass localityClass, boolean verbose) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                LOGGER.info("  Loop {}", (Object)loopNumber);
            }
            for (int i = 0; i < q2.length; ++i) {
                if (!q2[i]) continue;
                if (!sle.isLocal(this.ontologyAxiomSet.getAxiom(i), signature)) {
                    if (verbose) {
                        LOGGER.info("      Non-local axiom:   {}", (Object)this.minusOntologyURI(this.ontologyAxiomSet.getAxiom(i).toString()));
                    }
                    mod[i] = true;
                    q2[i] = false;
                    int oldSize = signature.size();
                    signature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    LOGGER.info("    New signature:   {}", signature);
                    continue;
                }
                if (!verbose) continue;
                LOGGER.info("      Local axiom:       {}", (Object)this.minusOntologyURI(this.ontologyAxiomSet.getAxiom(i).toString()));
            }
        }
        return mod;
    }

    @Nonnull
    Set<OWLAxiom> extract(@Nonnull Set<OWLAxiom> subOnt, @Nonnull Set<OWLEntity> signature, @Nonnull LocalityClass localityClass, boolean verbose) {
        HashSet<OWLAxiom> mod = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> q2 = new HashSet<OWLAxiom>(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                LOGGER.info("  Loop {}", (Object)loopNumber);
            }
            HashSet<OWLAxiom> q2remove = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : q2) {
                if (!sle.isLocal(ax, signature)) {
                    if (verbose) {
                        LOGGER.info("      Non-local axiom:   {}", (Object)this.minusOntologyURI(ax.toString()));
                    }
                    mod.add(ax);
                    q2remove.add(ax);
                    int oldSize = signature.size();
                    signature.addAll(ax.getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    LOGGER.info("    New signature:   {}", signature);
                    continue;
                }
                if (!verbose) continue;
                LOGGER.info("      Local axiom:       {}", (Object)this.minusOntologyURI(ax.toString()));
            }
            q2.removeAll(q2remove);
        }
        return mod;
    }

    @Nonnull
    Set<OWLAxiom> enrich(@Nonnull Set<OWLAxiom> module, @Nonnull Set<OWLEntity> sig, boolean verbose) {
        HashSet<OWLAxiom> enrichedModule = new HashSet<OWLAxiom>(module);
        if (verbose) {
            LOGGER.info("\nEnriching with declaration axioms, annotation axioms, same/different individual axioms ...");
        }
        for (OWLEntity entity : sig) {
            assert (entity != null);
            Set<OWLDeclarationAxiom> declarationAxioms = this.ontology.getDeclarationAxioms(entity);
            enrichedModule.addAll(declarationAxioms);
            if (!verbose) continue;
            for (OWLDeclarationAxiom declarationAxiom : declarationAxioms) {
                LOGGER.info("  Added entity declaration axiom:   {}", (Object)this.minusOntologyURI(declarationAxiom.toString()));
            }
        }
        HashSet<IRI> iris = new HashSet<IRI>(sig.size());
        for (OWLEntity i : sig) {
            iris.add(i.getIRI());
        }
        for (OWLAnnotationAssertionAxiom annotation : this.ontology.getAxioms(AxiomType.ANNOTATION_ASSERTION)) {
            if (!iris.contains(annotation.getSubject())) continue;
            enrichedModule.add(annotation);
            if (!verbose) continue;
            LOGGER.info("  Added entity annotation axiom:   {}", (Object)this.minusOntologyURI(annotation.toString()));
        }
        for (OWLEntity entity : sig) {
            if (!OWLNamedIndividual.class.isAssignableFrom(entity.getClass())) continue;
            OWLIndividual individual = (OWLIndividual)((Object)entity);
            Set<OWLSameIndividualAxiom> sameIndividualAxioms = this.ontology.getSameIndividualAxioms(individual);
            enrichedModule.addAll(sameIndividualAxioms);
            if (verbose) {
                for (OWLSameIndividualAxiom sameIndividualAxiom : sameIndividualAxioms) {
                    LOGGER.info("  Added same individual axiom:   {}", (Object)this.minusOntologyURI(sameIndividualAxiom.toString()));
                }
            }
            Set<OWLDifferentIndividualsAxiom> differentIndividualAxioms = this.ontology.getDifferentIndividualAxioms(individual);
            enrichedModule.addAll(differentIndividualAxioms);
            if (!verbose) continue;
            for (OWLDifferentIndividualsAxiom differentIndividualsAxiom : differentIndividualAxioms) {
                LOGGER.info("  Added different individual axiom:   {}", (Object)this.minusOntologyURI(differentIndividualsAxiom.toString()));
            }
        }
        return enrichedModule;
    }

    @Nonnull
    String minusOntologyURI(@Nonnull String s) {
        String uri = this.manager.getOntologyDocumentIRI(this.rootOntology) + "#";
        return s.replace(uri, "").replace("<", "").replace(">", "");
    }

    void outputSignature(@Nonnull String preamble, @Nonnull Set<OWLEntity> sig, boolean verbose) {
        if (verbose) {
            LOGGER.info(preamble);
            for (OWLEntity ent : sig) {
                LOGGER.info("  {}", (Object)this.minusOntologyURI(ent.toString()));
            }
        }
    }

    @Nonnull
    Set<OWLAxiom> extractUnnestedModule(@Nonnull Set<OWLEntity> sig, @Nonnull LocalityClass cls, boolean verbose) {
        this.outputSignature("\nExtracting " + (Object)((Object)cls) + " module for the following seed signature ... ", sig, verbose);
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        boolean[] module = this.extractLogicalAxioms(subOnt, signature, cls, verbose);
        Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(module);
        return this.enrich(moduleAsSet, signature, verbose);
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    static Set<OWLClass> SuperOrSubClasses(int superOrSubClassLevel, boolean superVsSub, @Nonnull OWLReasoner reasoner, @Nonnull Set<OWLClass> classesInSig) {
        HashSet<OWLClass> superOrSubClasses = new HashSet<OWLClass>();
        if (superOrSubClassLevel < 0) {
            for (OWLClassExpression oWLClassExpression : classesInSig) {
                NodeSet<OWLClass> nodes = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, false) : reasoner.getSubClasses(oWLClassExpression, false);
                superOrSubClasses.addAll(nodes.getFlattened());
            }
        } else if (superOrSubClassLevel > 0) {
            LinkedList<OWLClass> linkedList = new LinkedList<OWLClass>(classesInSig);
            LinkedList<OWLClass> suClassesToBeAdded = new LinkedList<OWLClass>();
            for (int i = 0; i < superOrSubClassLevel; ++i) {
                void var6_9;
                void toBeSuClassedNow = var6_9;
                LinkedList<OWLClass> linkedList2 = new LinkedList<OWLClass>();
                for (OWLClassExpression oWLClassExpression : toBeSuClassedNow) {
                    Set<OWLClass> suClasses = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, true).getFlattened() : reasoner.getSubClasses(oWLClassExpression, true).getFlattened();
                    for (OWLClass suClass : suClasses) {
                        if (classesInSig.contains(suClass) || suClassesToBeAdded.contains(suClass)) continue;
                        linkedList2.add(suClass);
                        suClassesToBeAdded.add(suClass);
                    }
                }
            }
            superOrSubClasses.addAll(suClassesToBeAdded);
        }
        return superOrSubClasses;
    }

    @Nonnull
    Set<OWLEntity> enrichSignature(@Nonnull Set<OWLEntity> sig, int superClassLevel, int subClassLevel, OWLReasoner reasoner) {
        HashSet<OWLEntity> enrichedSig = new HashSet<OWLEntity>(sig);
        HashSet<OWLClass> classesInSig = new HashSet<OWLClass>();
        for (OWLEntity ent : sig) {
            if (!OWLClass.class.isAssignableFrom(ent.getClass())) continue;
            classesInSig.add((OWLClass)ent);
        }
        if (superClassLevel != 0) {
            enrichedSig.addAll(SyntacticLocalityModuleExtractor.SuperOrSubClasses(superClassLevel, true, reasoner, classesInSig));
        }
        if (subClassLevel != 0) {
            enrichedSig.addAll(SyntacticLocalityModuleExtractor.SuperOrSubClasses(subClassLevel, false, reasoner, classesInSig));
        }
        return enrichedSig;
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> signature) {
        return this.extract(signature, 0, 0, null, false);
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> signature, int superClassLevel, int subClassLevel, OWLReasoner reasoner) {
        return this.extract(signature, superClassLevel, subClassLevel, reasoner, false);
    }

    @Nonnull
    public Set<OWLAxiom> extract(@Nonnull Set<OWLEntity> sig, int superClassLevel, int subClassLevel, OWLReasoner reasoner, boolean verbose) {
        Set<OWLEntity> enrichedSig = this.enrichSignature(sig, superClassLevel, subClassLevel, reasoner);
        switch (this.moduleType) {
            case TOP: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.TOP_TOP, verbose);
            }
            case BOT: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.BOTTOM_BOTTOM, verbose);
            }
            case STAR: {
                boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
                boolean nextStepNecessary = true;
                boolean inFirstStep = true;
                LocalityClass localityClass = LocalityClass.BOTTOM_BOTTOM;
                HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(enrichedSig);
                while (nextStepNecessary) {
                    this.outputSignature("\nExtracting " + (Object)((Object)localityClass) + " module for the following seed signature: ", enrichedSig, verbose);
                    int previousModuleSize = this.ontologyAxiomSet.subsetCardinality(subOnt);
                    seedSig = new HashSet<OWLEntity>(enrichedSig);
                    subOnt = this.extractLogicalAxioms(subOnt, seedSig, localityClass, verbose);
                    if (this.ontologyAxiomSet.subsetCardinality(subOnt) == previousModuleSize && !inFirstStep) {
                        nextStepNecessary = false;
                    }
                    inFirstStep = false;
                    if (localityClass == LocalityClass.BOTTOM_BOTTOM) {
                        localityClass = LocalityClass.TOP_TOP;
                        continue;
                    }
                    localityClass = LocalityClass.BOTTOM_BOTTOM;
                }
                Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(subOnt);
                return this.enrich(moduleAsSet, seedSig, verbose);
            }
        }
        throw new OWLRuntimeException("Unsupported module type: " + (Object)((Object)this.moduleType));
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, 0, 0, null, false);
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri, int superClassLevel, int subClassLevel, OWLReasoner reasoner) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, superClassLevel, subClassLevel, reasoner, false);
    }

    @Nonnull
    OWLOntology extractAsOntology(@Nonnull Set<OWLEntity> signature, @Nonnull IRI iri, int superClassLevel, int subClassLevel, OWLReasoner reasoner, boolean verbose) throws OWLOntologyCreationException {
        Set<OWLAxiom> axs = this.extract(signature, superClassLevel, subClassLevel, reasoner, verbose);
        OWLOntology newOnt = this.manager.createOntology(iri);
        LinkedList<AddAxiom> addaxs = new LinkedList<AddAxiom>();
        for (OWLAxiom ax : axs) {
            assert (ax != null);
            addaxs.add(new AddAxiom(newOnt, ax));
        }
        this.manager.applyChanges(addaxs);
        return newOnt;
    }

    static class OntologyAxiomSet {
        @Nonnull
        final OWLAxiom[] ax;

        OntologyAxiomSet(@Nonnull Set<OWLAxiom> axs) {
            this.ax = axs.toArray(new OWLAxiom[axs.size()]);
        }

        public int size() {
            return this.ax.length;
        }

        @Nonnull
        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        @Nonnull
        public OWLAxiom[] getAllAxioms() {
            OWLAxiom[] toReturn = new OWLAxiom[this.ax.length];
            System.arraycopy(this.ax, 0, toReturn, 0, this.ax.length);
            return toReturn;
        }

        @Nonnull
        public Set<OWLAxiom> getAxiomSet(boolean[] isIn) {
            HashSet<OWLAxiom> gas = new HashSet<OWLAxiom>();
            for (int i = 0; i < isIn.length; ++i) {
                if (!isIn[i]) continue;
                gas.add(this.ax[i]);
            }
            return gas;
        }

        @Nonnull
        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            for (int i = 0; i < this.ax.length; ++i) {
                subset[i] = init;
            }
            return subset;
        }

        @Nonnull
        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        @Nonnull
        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

