/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientResource;

public class ActiveMQProducerResource
extends AbstractActiveMQClientResource {
    boolean useDurableMessage = true;
    SimpleString address = null;
    ClientProducer producer;

    protected ActiveMQProducerResource(String url) {
        super(url);
    }

    protected ActiveMQProducerResource(ServerLocator serverLocator) {
        super(serverLocator);
    }

    public ActiveMQProducerResource(String url, String address) {
        this(url, SimpleString.toSimpleString((String)address));
    }

    public ActiveMQProducerResource(String url, SimpleString address) {
        super(url);
        if (address == null) {
            throw new IllegalArgumentException(String.format("%s construction error - address cannot be null", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        this.address = address;
    }

    public ActiveMQProducerResource(ServerLocator serverLocator, String address) {
        this(serverLocator, SimpleString.toSimpleString((String)address));
    }

    public ActiveMQProducerResource(ServerLocator serverLocator, SimpleString address) {
        super(serverLocator);
        if (address == null) {
            throw new IllegalArgumentException(String.format("%s construction error - address cannot be null", ((Object)((Object)this)).getClass().getSimpleName()));
        }
        this.address = address;
    }

    public boolean isUseDurableMessage() {
        return this.useDurableMessage;
    }

    public void setUseDurableMessage(boolean useDurableMessage) {
        this.useDurableMessage = useDurableMessage;
    }

    @Override
    protected void createClient() {
        try {
            if (!this.session.addressQuery(this.address).isExists() && this.autoCreateQueue) {
                this.log.warn("{}: queue does not exist - creating queue: address = {}, name = {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.address.toString(), this.address.toString()});
                this.session.createQueue(this.address, this.address);
            }
            this.producer = this.session.createProducer(this.address);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Error creating producer for address %s", this.address.toString()), (Exception)((Object)amqEx));
        }
    }

    @Override
    protected void stopClient() {
        if (this.producer != null) {
            try {
                this.producer.close();
            }
            catch (ActiveMQException amqEx) {
                this.log.warn("ActiveMQException encountered closing InternalClient ClientProducer - ignoring", (Throwable)amqEx);
            }
            finally {
                this.producer = null;
            }
        }
    }

    public ClientMessage createMessage() {
        if (this.session == null) {
            throw new IllegalStateException("ClientSession is null");
        }
        return this.session.createMessage(this.isUseDurableMessage());
    }

    public ClientMessage createMessage(byte[] body) {
        ClientMessage message = this.createMessage();
        if (body != null) {
            message.writeBodyBufferBytes(body);
        }
        return message;
    }

    public ClientMessage createMessage(String body) {
        ClientMessage message = this.createMessage();
        if (body != null) {
            message.writeBodyBufferString(body);
        }
        return message;
    }

    public ClientMessage createMessage(Map<String, Object> properties) {
        ClientMessage message = this.createMessage();
        ActiveMQProducerResource.addMessageProperties(message, properties);
        return message;
    }

    public ClientMessage createMessage(byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        ActiveMQProducerResource.addMessageProperties(message, properties);
        return message;
    }

    public ClientMessage createMessage(String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        ActiveMQProducerResource.addMessageProperties(message, properties);
        return message;
    }

    public void sendMessage(ClientMessage message) {
        try {
            this.producer.send((Message)message);
        }
        catch (ActiveMQException amqEx) {
            throw new AbstractActiveMQClientResource.ActiveMQClientResourceException(String.format("Failed to send message to %s", this.producer.getAddress().toString()), (Exception)((Object)amqEx));
        }
    }

    public ClientMessage sendMessage(byte[] body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }

    public ClientMessage sendMessage(String body) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }

    public ClientMessage sendMessage(Map<String, Object> properties) {
        ClientMessage message = this.createMessage(properties);
        this.sendMessage(message);
        return message;
    }

    public ClientMessage sendMessage(byte[] body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }

    public ClientMessage sendMessage(String body, Map<String, Object> properties) {
        ClientMessage message = this.createMessage(body);
        this.sendMessage(message);
        return message;
    }
}

