/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundleplugin;

import aQute.bnd.osgi.Analyzer;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.felix.bundleplugin.AbstractDependencyFilter;
import org.apache.felix.bundleplugin.BundlePlugin;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.util.StringUtils;

public final class DependencyEmbedder
extends AbstractDependencyFilter {
    public static final String EMBED_DEPENDENCY = "Embed-Dependency";
    public static final String EMBED_DIRECTORY = "Embed-Directory";
    public static final String EMBED_STRIP_GROUP = "Embed-StripGroup";
    public static final String EMBED_STRIP_VERSION = "Embed-StripVersion";
    public static final String EMBED_TRANSITIVE = "Embed-Transitive";
    public static final String EMBEDDED_ARTIFACTS = "Embedded-Artifacts";
    private static final String MAVEN_DEPENDENCIES = "{maven-dependencies}";
    private String m_embedDirectory;
    private String m_embedStripGroup;
    private String m_embedStripVersion;
    private final Collection<String> m_inlinedPaths = new LinkedHashSet<String>();
    private final Collection<Artifact> m_embeddedArtifacts = new LinkedHashSet<Artifact>();

    public DependencyEmbedder(Log log, DependencyNode dependencyGraph, Collection<Artifact> dependencyArtifacts) {
        super(dependencyGraph, dependencyArtifacts);
    }

    public void processHeaders(Analyzer analyzer) throws MojoExecutionException {
        StringBuffer includeResource = new StringBuffer();
        StringBuffer bundleClassPath = new StringBuffer();
        StringBuffer embeddedArtifacts = new StringBuffer();
        this.m_inlinedPaths.clear();
        this.m_embeddedArtifacts.clear();
        String embedDependencyHeader = analyzer.getProperty(EMBED_DEPENDENCY);
        if (StringUtils.isNotEmpty((String)embedDependencyHeader)) {
            this.m_embedDirectory = analyzer.getProperty(EMBED_DIRECTORY);
            this.m_embedStripGroup = analyzer.getProperty(EMBED_STRIP_GROUP, "true");
            this.m_embedStripVersion = analyzer.getProperty(EMBED_STRIP_VERSION);
            this.processInstructions(embedDependencyHeader);
            Iterator<String> i = this.m_inlinedPaths.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.inlineDependency(i.next(), includeResource);
            }
            i = this.m_embeddedArtifacts.iterator();
            while (i.hasNext()) {
                this.embedDependency((Artifact)i.next(), includeResource, bundleClassPath, embeddedArtifacts);
            }
        }
        if (analyzer.getProperty("-wab") == null && bundleClassPath.length() > 0 && analyzer.getProperty("Bundle-ClassPath") == null) {
            analyzer.setProperty("Bundle-ClassPath", ".");
        }
        DependencyEmbedder.appendDependencies(analyzer, "Include-Resource", includeResource.toString());
        DependencyEmbedder.appendDependencies(analyzer, "Bundle-ClassPath", bundleClassPath.toString());
        DependencyEmbedder.appendDependencies(analyzer, EMBEDDED_ARTIFACTS, embeddedArtifacts.toString());
    }

    @Override
    protected void processDependencies(Collection<Artifact> dependencies, String inline) {
        if (null == inline || "false".equalsIgnoreCase(inline)) {
            this.m_embeddedArtifacts.addAll(dependencies);
        } else {
            Iterator<Artifact> i = dependencies.iterator();
            while (i.hasNext()) {
                DependencyEmbedder.addInlinedPaths(i.next(), inline, this.m_inlinedPaths);
            }
        }
    }

    private static void addInlinedPaths(Artifact dependency, String inline, Collection<String> inlinedPaths) {
        File path = dependency.getFile();
        if (null != path && path.exists()) {
            if ("true".equalsIgnoreCase(inline) || inline.length() == 0) {
                inlinedPaths.add(path.getPath());
            } else {
                String[] filters = inline.split("\\|");
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].length() <= 0) continue;
                    inlinedPaths.add(path + "!/" + filters[i]);
                }
            }
        }
    }

    private void embedDependency(Artifact dependency, StringBuffer includeResource, StringBuffer bundleClassPath, StringBuffer embeddedArtifacts) {
        File sourceFile = dependency.getFile();
        if (null != sourceFile && sourceFile.exists()) {
            String extension;
            String embedDirectory = this.m_embedDirectory;
            if ("".equals(embedDirectory) || ".".equals(embedDirectory)) {
                embedDirectory = null;
            }
            if (!Boolean.valueOf(this.m_embedStripGroup).booleanValue()) {
                embedDirectory = new File(embedDirectory, dependency.getGroupId()).getPath();
            }
            StringBuffer targetFileName = new StringBuffer();
            targetFileName.append(dependency.getArtifactId());
            if (!Boolean.valueOf(this.m_embedStripVersion).booleanValue()) {
                targetFileName.append('-').append(dependency.getVersion());
                if (StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                    targetFileName.append('-').append(dependency.getClassifier());
                }
            }
            if (StringUtils.isNotEmpty((String)(extension = dependency.getArtifactHandler().getExtension()))) {
                targetFileName.append('.').append(extension);
            }
            File targetFile = new File(embedDirectory, targetFileName.toString());
            String targetFilePath = targetFile.getPath();
            if (File.separatorChar != '/') {
                targetFilePath = targetFilePath.replace(File.separatorChar, '/');
            }
            if (includeResource.length() > 0) {
                includeResource.append(',');
            }
            includeResource.append(targetFilePath);
            includeResource.append('=');
            includeResource.append(sourceFile);
            if (bundleClassPath.length() > 0) {
                bundleClassPath.append(',');
            }
            bundleClassPath.append(targetFilePath);
            if (embeddedArtifacts.length() > 0) {
                embeddedArtifacts.append(',');
            }
            embeddedArtifacts.append(targetFilePath).append(';');
            embeddedArtifacts.append("g=\"").append(dependency.getGroupId()).append('\"');
            embeddedArtifacts.append(";a=\"").append(dependency.getArtifactId()).append('\"');
            embeddedArtifacts.append(";v=\"").append(dependency.getBaseVersion()).append('\"');
            if (StringUtils.isNotEmpty((String)dependency.getClassifier())) {
                embeddedArtifacts.append(";c=\"").append(dependency.getClassifier()).append('\"');
            }
        }
    }

    private static void inlineDependency(String path, StringBuffer includeResource) {
        if (includeResource.length() > 0) {
            includeResource.append(',');
        }
        includeResource.append('@');
        includeResource.append(path);
    }

    public Collection<String> getInlinedPaths() {
        return this.m_inlinedPaths;
    }

    public Collection<Artifact> getEmbeddedArtifacts() {
        return this.m_embeddedArtifacts;
    }

    private static void appendDependencies(Analyzer analyzer, String directiveName, String mavenDependencies) {
        String instruction = analyzer.getProperty(directiveName);
        if (StringUtils.isNotEmpty((String)instruction)) {
            if (instruction.indexOf(MAVEN_DEPENDENCIES) >= 0) {
                if (mavenDependencies.length() == 0) {
                    String cleanInstruction = BundlePlugin.removeTagFromInstruction(instruction, MAVEN_DEPENDENCIES);
                    analyzer.setProperty(directiveName, cleanInstruction);
                } else {
                    String mergedInstruction = StringUtils.replace((String)instruction, (String)MAVEN_DEPENDENCIES, (String)mavenDependencies);
                    analyzer.setProperty(directiveName, mergedInstruction);
                }
            } else if (mavenDependencies.length() > 0) {
                if ("Include-Resource".equalsIgnoreCase(directiveName)) {
                    analyzer.setProperty(directiveName, mavenDependencies + ',' + instruction);
                } else {
                    analyzer.setProperty(directiveName, instruction + ',' + mavenDependencies);
                }
            }
        } else if (mavenDependencies.length() > 0) {
            analyzer.setProperty(directiveName, mavenDependencies);
        }
    }
}

