/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.util.GSet;
import org.apache.hadoop.util.GSetByHashMap;
import org.apache.hadoop.util.LightWeightCache;
import org.apache.hadoop.util.LightWeightGSet;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestLightWeightCache {
    private static final long starttime;
    private static final long seed;
    private static final Random ran;

    private static void print(Object s) {
        System.out.print(s);
        System.out.flush();
    }

    private static void println(Object s) {
        System.out.println(s);
    }

    @Test
    public void testLightWeightCache() {
        long creationExpiration = ran.nextInt(1024) + 1;
        TestLightWeightCache.check(1, creationExpiration, 0L, 1024, 65537);
        TestLightWeightCache.check(17, creationExpiration, 0L, 65536, 17);
        TestLightWeightCache.check(255, creationExpiration, 0L, 65536, 65537);
        for (int i = 0; i < 3; ++i) {
            long creationExpiration2 = ran.nextInt(1024) + 1;
            long accessExpiration = ran.nextInt(1024) + 1;
            TestLightWeightCache.check(1, creationExpiration2, accessExpiration, 1024, 65537);
            TestLightWeightCache.check(17, creationExpiration2, accessExpiration, 65536, 17);
            TestLightWeightCache.check(255, creationExpiration2, accessExpiration, 65536, 65537);
        }
        int dataSize = 65536;
        for (int i = 0; i < 10; ++i) {
            int modulus = ran.nextInt(1024) + 1;
            int sizeLimit = ran.nextInt(modulus) + 1;
            TestLightWeightCache.checkSizeLimit(sizeLimit, 65536, modulus);
        }
    }

    private static void checkSizeLimit(int sizeLimit, int datasize, int modulus) {
        LightWeightCacheTestCase test = new LightWeightCacheTestCase(sizeLimit, sizeLimit, 0x100000000L, 0x100000000L, datasize, modulus);
        TestLightWeightCache.print("  check size ................. ");
        for (int i = 0; i < test.data.size(); ++i) {
            test.cache.put((Object)test.data.get(i));
            Assert.assertTrue((test.cache.size() <= sizeLimit ? 1 : 0) != 0);
        }
        TestLightWeightCache.println("DONE " + test.stat());
    }

    public void testExpirationPeriods() {
        for (int k = -4; k < 10; k += 4) {
            long accessExpirationPeriod = k < 0 ? 0L : 1L << k;
            for (int j = 0; j < 10; j += 4) {
                long creationExpirationPeriod = 1L << j;
                TestLightWeightCache.runTests(1, creationExpirationPeriod, accessExpirationPeriod);
                for (int i = 1; i < 31; i += 8) {
                    TestLightWeightCache.runTests((1 << i) + 1, creationExpirationPeriod, accessExpirationPeriod);
                }
            }
        }
    }

    private static void runTests(int modulus, long creationExpirationPeriod, long accessExpirationPeriod) {
        TestLightWeightCache.println("\n\n\n*** runTest: modulus=" + modulus + ", creationExpirationPeriod=" + creationExpirationPeriod + ", accessExpirationPeriod=" + accessExpirationPeriod);
        for (int i = 0; i <= 16; i += 4) {
            int tablelength = 1 << i;
            int upper = i + 2;
            int steps = Math.max(1, upper / 3);
            for (int j = upper; j > 0; j -= steps) {
                int datasize = 1 << j;
                TestLightWeightCache.check(tablelength, creationExpirationPeriod, accessExpirationPeriod, datasize, modulus);
            }
        }
    }

    private static void check(int tablelength, long creationExpirationPeriod, long accessExpirationPeriod, int datasize, int modulus) {
        TestLightWeightCache.check(new LightWeightCacheTestCase(tablelength, -1, creationExpirationPeriod, accessExpirationPeriod, datasize, modulus));
    }

    private static void check(LightWeightCacheTestCase test) {
        int r;
        int i;
        int j;
        int i2;
        TestLightWeightCache.print("  check put .................. ");
        for (i2 = 0; i2 < test.data.size() / 2; ++i2) {
            test.put(test.data.get(i2));
        }
        for (i2 = 0; i2 < test.data.size(); ++i2) {
            test.put(test.data.get(i2));
        }
        TestLightWeightCache.println("DONE " + test.stat());
        TestLightWeightCache.print("  check remove & put ......... ");
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.remove(test.data.get(r));
            }
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.put(test.data.get(r));
            }
        }
        TestLightWeightCache.println("DONE " + test.stat());
        TestLightWeightCache.print("  check remove ............... ");
        for (i2 = 0; i2 < test.data.size(); ++i2) {
            test.remove(test.data.get(i2));
        }
        Assert.assertEquals((long)0L, (long)test.cache.size());
        TestLightWeightCache.println("DONE " + test.stat());
        TestLightWeightCache.print("  check remove & put again ... ");
        for (j = 0; j < 10; ++j) {
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.remove(test.data.get(r));
            }
            for (i = 0; i < test.data.size() / 2; ++i) {
                r = ran.nextInt(test.data.size());
                test.put(test.data.get(r));
            }
        }
        TestLightWeightCache.println("DONE " + test.stat());
        long s = (Time.now() - starttime) / 1000L;
        TestLightWeightCache.println("total time elapsed=" + s + "s\n");
    }

    static {
        seed = starttime = Time.now();
        ran = new Random(seed);
        TestLightWeightCache.println("Start time = " + new Date(starttime) + ", seed=" + seed);
    }

    private static class IntEntry
    implements LightWeightCache.Entry,
    Comparable<IntEntry> {
        private LightWeightGSet.LinkedElement next;
        final int id;
        final int value;
        private long expirationTime = 0L;

        IntEntry(int id, int value) {
            this.id = id;
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof IntEntry && this.value == ((IntEntry)obj).value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public int compareTo(IntEntry that) {
            return this.value - that.value;
        }

        public String toString() {
            return this.id + "#" + this.value + ",expirationTime=" + this.expirationTime;
        }

        public LightWeightGSet.LinkedElement getNext() {
            return this.next;
        }

        public void setNext(LightWeightGSet.LinkedElement e) {
            this.next = e;
        }

        public void setExpirationTime(long timeNano) {
            this.expirationTime = timeNano;
        }

        public long getExpirationTime() {
            return this.expirationTime;
        }
    }

    private static class IntData {
        final IntEntry[] integers;

        IntData(int size, int modulus) {
            this.integers = new IntEntry[size];
            for (int i = 0; i < this.integers.length; ++i) {
                this.integers[i] = new IntEntry(i, ran.nextInt(modulus));
            }
        }

        IntEntry get(int i) {
            return this.integers[i];
        }

        int size() {
            return this.integers.length;
        }
    }

    private static class LightWeightCacheTestCase
    implements GSet<IntEntry, IntEntry> {
        final GSet<IntEntry, IntEntry> hashMap = new GSetByHashMap(1024, 0.75f);
        final LightWeightCache<IntEntry, IntEntry> cache;
        final IntData data;
        final String info;
        final long starttime = Time.now();
        final int denominator;
        int iterate_count = 0;
        int contain_count = 0;
        private long currentTestTime = TestLightWeightCache.access$000().nextInt();

        LightWeightCacheTestCase(int tablelength, int sizeLimit, long creationExpirationPeriod, long accessExpirationPeriod, int datasize, int modulus) {
            this.denominator = Math.min((datasize >> 7) + 1, 65536);
            this.info = this.getClass().getSimpleName() + "(" + new Date(this.starttime) + "): tablelength=" + tablelength + ", creationExpirationPeriod=" + creationExpirationPeriod + ", accessExpirationPeriod=" + accessExpirationPeriod + ", datasize=" + datasize + ", modulus=" + modulus + ", denominator=" + this.denominator;
            TestLightWeightCache.println(this.info);
            this.data = new IntData(datasize, modulus);
            this.cache = new LightWeightCache(tablelength, sizeLimit, creationExpirationPeriod, 0L, new LightWeightCache.Clock(){

                long currentTime() {
                    return LightWeightCacheTestCase.this.currentTestTime;
                }
            });
            Assert.assertEquals((long)0L, (long)this.cache.size());
        }

        private boolean containsTest(IntEntry key) {
            boolean c = this.cache.contains((Object)key);
            if (c) {
                Assert.assertTrue((boolean)this.hashMap.contains((Object)key));
            } else {
                IntEntry h = (IntEntry)this.hashMap.remove((Object)key);
                if (h != null) {
                    Assert.assertTrue((boolean)this.cache.isExpired((LightWeightCache.Entry)h, this.currentTestTime));
                }
            }
            return c;
        }

        public boolean contains(IntEntry key) {
            boolean e = this.containsTest(key);
            this.check();
            return e;
        }

        private IntEntry getTest(IntEntry key) {
            IntEntry c = (IntEntry)this.cache.get((Object)key);
            if (c != null) {
                Assert.assertEquals((long)((IntEntry)this.hashMap.get((Object)key)).id, (long)c.id);
            } else {
                IntEntry h = (IntEntry)this.hashMap.remove((Object)key);
                if (h != null) {
                    Assert.assertTrue((boolean)this.cache.isExpired((LightWeightCache.Entry)h, this.currentTestTime));
                }
            }
            return c;
        }

        public IntEntry get(IntEntry key) {
            IntEntry e = this.getTest(key);
            this.check();
            return e;
        }

        private IntEntry putTest(IntEntry entry) {
            IntEntry c = (IntEntry)this.cache.put((Object)entry);
            if (c != null) {
                Assert.assertEquals((long)((IntEntry)this.hashMap.put((Object)entry)).id, (long)c.id);
            } else {
                IntEntry h = (IntEntry)this.hashMap.put((Object)entry);
                if (h != null && h != entry) {
                    Assert.assertTrue((boolean)this.cache.isExpired((LightWeightCache.Entry)h, this.currentTestTime));
                }
            }
            return c;
        }

        public IntEntry put(IntEntry entry) {
            IntEntry e = this.putTest(entry);
            this.check();
            return e;
        }

        private IntEntry removeTest(IntEntry key) {
            IntEntry c = (IntEntry)this.cache.remove((Object)key);
            if (c != null) {
                Assert.assertEquals((long)c.id, (long)((IntEntry)this.hashMap.remove((Object)key)).id);
            } else {
                IntEntry h = (IntEntry)this.hashMap.remove((Object)key);
                if (h != null) {
                    Assert.assertTrue((boolean)this.cache.isExpired((LightWeightCache.Entry)h, this.currentTestTime));
                }
            }
            return c;
        }

        public IntEntry remove(IntEntry key) {
            IntEntry e = this.removeTest(key);
            this.check();
            return e;
        }

        private int sizeTest() {
            int c = this.cache.size();
            Assert.assertTrue((this.hashMap.size() >= c ? 1 : 0) != 0);
            return c;
        }

        public int size() {
            int s = this.sizeTest();
            this.check();
            return s;
        }

        public Iterator<IntEntry> iterator() {
            throw new UnsupportedOperationException();
        }

        boolean tossCoin() {
            return ran.nextInt(this.denominator) == 0;
        }

        void check() {
            block6: {
                this.currentTestTime += (long)(ran.nextInt() & 3);
                this.sizeTest();
                if (this.tossCoin()) {
                    ++this.iterate_count;
                    for (IntEntry i : this.cache) {
                        this.getTest(i);
                    }
                }
                if (!this.tossCoin()) break block6;
                ++this.contain_count;
                int count = Math.min(this.data.size(), 1000);
                if (count == this.data.size()) {
                    for (IntEntry i : this.data.integers) {
                        this.containsTest(i);
                    }
                } else {
                    for (int j = 0; j < count; ++j) {
                        this.containsTest(this.data.get(ran.nextInt(this.data.size())));
                    }
                }
            }
        }

        String stat() {
            long t = Time.now() - this.starttime;
            return String.format(" iterate=%5d, contain=%5d, time elapsed=%5d.%03ds", this.iterate_count, this.contain_count, t / 1000L, t % 1000L);
        }

        public void clear() {
            this.hashMap.clear();
            this.cache.clear();
            Assert.assertEquals((long)0L, (long)this.size());
        }

        public Collection<IntEntry> values() {
            throw new UnsupportedOperationException();
        }
    }
}

