/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.mime4j.field;

import org.apache.james.mime4j.MimeException;

/**
 * This exception is thrown when parse errors are encountered.
 */
public class ParseException extends MimeException {

    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new parse exception with the specified detail message.
     * 
     * @param message
     *            detail message
     */
    protected ParseException(String message) {
        super(message);
    }

    /**
     * Constructs a new parse exception with the specified cause.
     * 
     * @param cause
     *            the cause
     */
    protected ParseException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new parse exception with the specified detail message and
     * cause.
     * 
     * @param message
     *            detail message
     * @param cause
     *            the cause
     */
    protected ParseException(String message, Throwable cause) {
        super(message, cause);
    }

}
