/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.StateRestoreCallback;

public class StateRestorer {
    static final int NO_CHECKPOINT = -1;
    private final Long checkpoint;
    private final long offsetLimit;
    private final boolean persistent;
    private final TopicPartition partition;
    private final StateRestoreCallback stateRestoreCallback;
    private long restoredOffset;
    private long startingOffset;

    StateRestorer(TopicPartition partition, StateRestoreCallback stateRestoreCallback, Long checkpoint, long offsetLimit, boolean persistent) {
        this.partition = partition;
        this.stateRestoreCallback = stateRestoreCallback;
        this.checkpoint = checkpoint;
        this.offsetLimit = offsetLimit;
        this.persistent = persistent;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    long checkpoint() {
        return this.checkpoint == null ? -1L : this.checkpoint;
    }

    void restore(byte[] key, byte[] value) {
        this.stateRestoreCallback.restore(key, value);
    }

    boolean isPersistent() {
        return this.persistent;
    }

    void setRestoredOffset(long restoredOffset) {
        this.restoredOffset = Math.min(this.offsetLimit, restoredOffset);
    }

    void setStartingOffset(long startingOffset) {
        this.startingOffset = Math.min(this.offsetLimit, startingOffset);
    }

    long startingOffset() {
        return this.startingOffset;
    }

    boolean hasCompleted(long recordOffset, long endOffset) {
        return endOffset == 0L || recordOffset >= this.readTo(endOffset);
    }

    Long restoredOffset() {
        return this.restoredOffset;
    }

    long restoredNumRecords() {
        return this.restoredOffset - this.startingOffset;
    }

    long offsetLimit() {
        return this.offsetLimit;
    }

    private Long readTo(long endOffset) {
        return endOffset < this.offsetLimit ? endOffset : this.offsetLimit;
    }
}

