/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyWindowStore<K, V>
implements ReadOnlyWindowStore<K, V> {
    private final QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType;
    private final String storeName;
    private final StateStoreProvider provider;

    public CompositeReadOnlyWindowStore(StateStoreProvider provider, QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType, String storeName) {
        this.provider = provider;
        this.windowStoreType = windowStoreType;
        this.storeName = storeName;
    }

    public <IteratorType extends KeyValueIterator<?, V>> IteratorType fetch(Fetcher<K, V, IteratorType> fetcher) {
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                IteratorType result = fetcher.fetch(windowStore);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return fetcher.empty();
    }

    @Override
    public WindowStoreIterator<V> fetch(final K key, final long timeFrom, final long timeTo) {
        return (WindowStoreIterator)this.fetch(new Fetcher<K, V, WindowStoreIterator<V>>(){

            @Override
            public WindowStoreIterator<V> fetch(ReadOnlyWindowStore<K, V> store) {
                return store.fetch(key, timeFrom, timeTo);
            }

            @Override
            public WindowStoreIterator<V> empty() {
                return KeyValueIterators.emptyWindowStoreIterator();
            }
        });
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(final K from, final K to, final long timeFrom, final long timeTo) {
        return this.fetch(new Fetcher<K, V, KeyValueIterator<Windowed<K>, V>>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> fetch(ReadOnlyWindowStore<K, V> store) {
                return store.fetch(from, to, timeFrom, timeTo);
            }

            @Override
            public KeyValueIterator<Windowed<K>, V> empty() {
                return KeyValueIterators.emptyIterator();
            }
        });
    }

    private static interface Fetcher<K, V, IteratorType extends KeyValueIterator<?, V>> {
        public IteratorType fetch(ReadOnlyWindowStore<K, V> var1);

        public IteratorType empty();
    }
}

