/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Map;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.Windows;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KStreamAggProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.WindowStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KStreamWindowAggregate<K, V, T, W extends Window>
implements KStreamAggProcessorSupplier<K, Windowed<K>, V, T> {
    private static final Logger LOG = LoggerFactory.getLogger(KStreamWindowAggregate.class);
    private final String storeName;
    private final Windows<W> windows;
    private final Initializer<T> initializer;
    private final Aggregator<? super K, ? super V, T> aggregator;
    private boolean sendOldValues = false;

    KStreamWindowAggregate(Windows<W> windows, String storeName, Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator) {
        this.windows = windows;
        this.storeName = storeName;
        this.initializer = initializer;
        this.aggregator = aggregator;
    }

    @Override
    public Processor<K, V> get() {
        return new KStreamWindowAggregateProcessor();
    }

    @Override
    public void enableSendingOldValues() {
        this.sendOldValues = true;
    }

    @Override
    public KTableValueGetterSupplier<Windowed<K>, T> view() {
        return new KTableValueGetterSupplier<Windowed<K>, T>(){

            @Override
            public KTableValueGetter<Windowed<K>, T> get() {
                return new KStreamWindowAggregateValueGetter();
            }

            @Override
            public String[] storeNames() {
                return new String[]{KStreamWindowAggregate.this.storeName};
            }
        };
    }

    private class KStreamWindowAggregateValueGetter
    implements KTableValueGetter<Windowed<K>, T> {
        private WindowStore<K, T> windowStore;

        private KStreamWindowAggregateValueGetter() {
        }

        @Override
        public void init(ProcessorContext context) {
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
        }

        @Override
        public T get(Windowed<K> windowedKey) {
            Object key = windowedKey.key();
            Window window = windowedKey.window();
            return this.windowStore.fetch(key, window.start());
        }

        @Override
        public void close() {
        }
    }

    private class KStreamWindowAggregateProcessor
    extends AbstractProcessor<K, V> {
        private WindowStore<K, T> windowStore;
        private TupleForwarder<Windowed<K>, T> tupleForwarder;
        private StreamsMetricsImpl metrics;

        private KStreamWindowAggregateProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            this.metrics = (StreamsMetricsImpl)context.metrics();
            this.windowStore = (WindowStore)context.getStateStore(KStreamWindowAggregate.this.storeName);
            this.tupleForwarder = new TupleForwarder(this.windowStore, context, new ForwardingCacheFlushListener(context, KStreamWindowAggregate.this.sendOldValues), KStreamWindowAggregate.this.sendOldValues);
        }

        @Override
        public void process(K key, V value) {
            if (key == null) {
                LOG.warn("Skipping record due to null key. value=[{}] topic=[{}] partition=[{}] offset=[{}]", new Object[]{value, this.context().topic(), this.context().partition(), this.context().offset()});
                this.metrics.skippedRecordsSensor().record();
                return;
            }
            long timestamp = this.context().timestamp();
            Map matchedWindows = KStreamWindowAggregate.this.windows.windowsFor(timestamp);
            for (Map.Entry entry : matchedWindows.entrySet()) {
                Object oldAgg = this.windowStore.fetch(key, entry.getKey());
                if (oldAgg == null) {
                    oldAgg = KStreamWindowAggregate.this.initializer.apply();
                }
                Object newAgg = KStreamWindowAggregate.this.aggregator.apply(key, value, oldAgg);
                this.windowStore.put(key, newAgg, entry.getKey());
                this.tupleForwarder.maybeForward(new Windowed(key, (Window)entry.getValue()), newAgg, oldAgg);
            }
        }
    }
}

