/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.LinkedList;
import org.apache.kafka.streams.processor.internals.Stamped;
import org.apache.kafka.streams.processor.internals.TimestampTracker;

public class MinTimestampTracker<E>
implements TimestampTracker<E> {
    private final LinkedList<Stamped<E>> ascendingSubsequence = new LinkedList();
    private long lastKnownTime = -1L;

    @Override
    public void addElement(Stamped<E> elem) {
        if (elem == null) {
            throw new NullPointerException();
        }
        Stamped<E> maxElem = this.ascendingSubsequence.peekLast();
        while (maxElem != null && maxElem.timestamp >= elem.timestamp) {
            this.ascendingSubsequence.removeLast();
            maxElem = this.ascendingSubsequence.peekLast();
        }
        this.ascendingSubsequence.offerLast(elem);
    }

    @Override
    public void removeElement(Stamped<E> elem) {
        if (elem == null) {
            return;
        }
        if (this.ascendingSubsequence.peekFirst() == elem) {
            this.ascendingSubsequence.removeFirst();
        }
        if (this.ascendingSubsequence.isEmpty()) {
            this.lastKnownTime = elem.timestamp;
        }
    }

    @Override
    public int size() {
        return this.ascendingSubsequence.size();
    }

    @Override
    public long get() {
        Stamped<E> stamped = this.ascendingSubsequence.peekFirst();
        if (stamped == null) {
            return this.lastKnownTime;
        }
        return stamped.timestamp;
    }

    @Override
    public void clear() {
        this.lastKnownTime = -1L;
        this.ascendingSubsequence.clear();
    }
}

