/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jcl;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.jcl.Log4jLog;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.LoggerContext;

public class LogFactoryImpl
extends LogFactory {
    private final Map<LoggerContext, ConcurrentMap<String, Log>> contextMap = new WeakHashMap<LoggerContext, ConcurrentMap<String, Log>>();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Log getInstance(String name) throws LogConfigurationException {
        ConcurrentMap<String, Log> loggers = this.getLoggersMap();
        if (loggers.containsKey(name)) {
            return (Log)loggers.get(name);
        }
        loggers.putIfAbsent(name, new Log4jLog(PrivateManager.getLogger(name)));
        return (Log)loggers.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<String, Log> getLoggersMap() {
        LoggerContext context = PrivateManager.getContext();
        Map<LoggerContext, ConcurrentMap<String, Log>> map = this.contextMap;
        synchronized (map) {
            ConcurrentMap<String, Log> map2 = this.contextMap.get(context);
            if (map2 == null) {
                map2 = new ConcurrentHashMap<String, Log>();
                this.contextMap.put(context, map2);
            }
            return map2;
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public void release() {
        this.getLoggersMap().clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    private static class PrivateManager
    extends LogManager {
        private static final String FQCN = LogFactory.class.getName();

        private PrivateManager() {
        }

        public static LoggerContext getContext() {
            return PrivateManager.getContext((String)FQCN, (boolean)false);
        }

        public static ExtendedLogger getLogger(String name) {
            return PrivateManager.getContext().getLogger(name);
        }
    }
}

