/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.File;
import java.io.IOException;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.profiles.activation.ProfileActivationException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProjectBuildingException
extends Exception {
    private final String projectId;
    private File pomFile;

    public ProjectBuildingException(String projectId, String message) {
        super(message);
        this.projectId = projectId;
    }

    protected ProjectBuildingException(String projectId, String message, String pomLocation) {
        super(message);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile) {
        super(message);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    protected ProjectBuildingException(String projectId, String message, File pomFile, Throwable cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, ProfileActivationException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, ProfileActivationException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, IOException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, IOException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, IOException cause) {
        super(message, cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, XmlPullParserException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, XmlPullParserException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    protected ProjectBuildingException(String projectId, String message, XmlPullParserException cause) {
        super(message, cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, ArtifactResolutionException cause) {
        super(message, cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, InvalidRepositoryException cause) {
        super(message, cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, InvalidRepositoryException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, ArtifactNotFoundException cause) {
        super(message, cause);
        this.projectId = projectId;
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, ArtifactResolutionException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, ArtifactResolutionException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, ArtifactNotFoundException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, ArtifactNotFoundException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, InvalidVersionSpecificationException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, InvalidVersionSpecificationException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public ProjectBuildingException(String projectId, String message, File pomFile, InvalidDependencyVersionException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = pomFile;
    }

    public ProjectBuildingException(String projectId, String message, String pomLocation, InvalidDependencyVersionException cause) {
        super(message, cause);
        this.projectId = projectId;
        this.pomFile = new File(pomLocation);
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public String getPomLocation() {
        if (this.getPomFile() != null) {
            return this.getPomFile().getAbsolutePath();
        }
        return "null";
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getMessage() {
        return super.getMessage() + " for project " + this.projectId + (this.getPomFile() == null ? "" : " at " + this.getPomFile().getAbsolutePath());
    }
}

