/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.surefire.suite.RunResult;

public final class SurefireHelper {
    private SurefireHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void reportExecution(SurefireReportParameters reportParameters, RunResult result, Log log) throws MojoFailureException {
        if (result.getCompletedCount() == 0) {
            if (reportParameters.getFailIfNoTests() == null || !reportParameters.getFailIfNoTests().booleanValue()) {
                return;
            }
            throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
        }
        if (result.isErrorFree()) {
            return;
        }
        String msg = result.isFailureOrTimeout() ? "There was a timeout or other error in the fork" : "There are test failures.\n\nPlease refer to " + reportParameters.getReportsDirectory() + " for the individual test results.";
        if (!reportParameters.isTestFailureIgnore()) {
            throw new MojoFailureException(msg);
        }
        log.error((CharSequence)msg);
    }

    public static void reportExecution(SurefireReportParameters reportParameters, int result, Log log) throws MojoFailureException {
        if (result == 0) {
            return;
        }
        if (result == 254) {
            if (reportParameters.getFailIfNoTests() == null || !reportParameters.getFailIfNoTests().booleanValue()) {
                return;
            }
            throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
        }
        String msg = "There are test failures.\n\nPlease refer to " + reportParameters.getReportsDirectory() + " for the individual test results.";
        if (!reportParameters.isTestFailureIgnore()) {
            throw new MojoFailureException(msg);
        }
        log.error((CharSequence)msg);
    }
}

