/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class ParquetWriter<T>
implements Closeable {
    public static final int DEFAULT_BLOCK_SIZE = 0x8000000;
    public static final int DEFAULT_PAGE_SIZE = 0x100000;
    public static final CompressionCodecName DEFAULT_COMPRESSION_CODEC_NAME = CompressionCodecName.UNCOMPRESSED;
    public static final boolean DEFAULT_IS_DICTIONARY_ENABLED = true;
    public static final boolean DEFAULT_IS_VALIDATING_ENABLED = false;
    public static final ParquetProperties.WriterVersion DEFAULT_WRITER_VERSION = ParquetProperties.WriterVersion.PARQUET_1_0;
    private final InternalParquetRecordWriter<T> writer;

    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, true, false);
    }

    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, pageSize, enableDictionary, validating);
    }

    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, DEFAULT_WRITER_VERSION);
    }

    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion) throws IOException {
        this(file, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, new Configuration());
    }

    public ParquetWriter(Path file, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        this(file, ParquetFileWriter.Mode.CREATE, writeSupport, compressionCodecName, blockSize, pageSize, dictionaryPageSize, enableDictionary, validating, writerVersion, conf);
    }

    public ParquetWriter(Path file, ParquetFileWriter.Mode mode, WriteSupport<T> writeSupport, CompressionCodecName compressionCodecName, int blockSize, int pageSize, int dictionaryPageSize, boolean enableDictionary, boolean validating, ParquetProperties.WriterVersion writerVersion, Configuration conf) throws IOException {
        WriteSupport.WriteContext writeContext = writeSupport.init(conf);
        MessageType schema = writeContext.getSchema();
        ParquetFileWriter fileWriter = new ParquetFileWriter(conf, schema, file, mode);
        fileWriter.start();
        CodecFactory codecFactory = new CodecFactory(conf);
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(compressionCodecName, 0);
        this.writer = new InternalParquetRecordWriter<T>(fileWriter, writeSupport, schema, writeContext.getExtraMetaData(), blockSize, pageSize, compressor, dictionaryPageSize, enableDictionary, validating, writerVersion);
    }

    public ParquetWriter(Path file, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000);
    }

    public ParquetWriter(Path file, Configuration conf, WriteSupport<T> writeSupport) throws IOException {
        this(file, writeSupport, DEFAULT_COMPRESSION_CODEC_NAME, 0x8000000, 0x100000, 0x100000, true, false, DEFAULT_WRITER_VERSION, conf);
    }

    public void write(T object) throws IOException {
        try {
            this.writer.write(object);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.writer.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

