/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DateTimeUtils$ {
    public static final DateTimeUtils$ MODULE$;
    private final int JULIAN_DAY_OF_EPOCH;
    private final long SECONDS_PER_DAY;
    private final long MICROS_PER_SECOND;
    private final long NANOS_PER_SECOND;
    private final long MICROS_PER_DAY;
    private final long MILLIS_PER_DAY;
    private final int daysIn400Years;
    private final int to2001;
    private final int YearZero;
    private final int toYearZero;
    private transient TimeZone defaultTimeZone;
    private final ThreadLocal<TimeZone> threadLocalLocalTimeZone;
    private final ThreadLocal<DateFormat> threadLocalTimestampFormat;
    private final ThreadLocal<DateFormat> threadLocalDateFormat;
    private final int[] monthDays;
    private final int TRUNC_TO_YEAR;
    private final int TRUNC_TO_MONTH;
    private final int TRUNC_INVALID;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DateTimeUtils$();
    }

    private TimeZone defaultTimeZone$lzycompute() {
        DateTimeUtils$ dateTimeUtils$ = this;
        synchronized (dateTimeUtils$) {
            if (!this.bitmap$trans$0) {
                this.defaultTimeZone = TimeZone.getDefault();
                this.bitmap$trans$0 = true;
            }
            return this.defaultTimeZone;
        }
    }

    public final int JULIAN_DAY_OF_EPOCH() {
        return 2440588;
    }

    public final long SECONDS_PER_DAY() {
        return 86400L;
    }

    public final long MICROS_PER_SECOND() {
        return 1000000L;
    }

    public final long NANOS_PER_SECOND() {
        return 1000000000L;
    }

    public final long MICROS_PER_DAY() {
        return 86400000000L;
    }

    public final long MILLIS_PER_DAY() {
        return 86400000L;
    }

    public final int daysIn400Years() {
        return this.daysIn400Years;
    }

    public final int to2001() {
        return -11323;
    }

    public final int YearZero() {
        return -17999;
    }

    public final int toYearZero() {
        return 7293527;
    }

    public TimeZone defaultTimeZone() {
        return this.bitmap$trans$0 ? this.defaultTimeZone : this.defaultTimeZone$lzycompute();
    }

    private ThreadLocal<TimeZone> threadLocalLocalTimeZone() {
        return this.threadLocalLocalTimeZone;
    }

    private ThreadLocal<DateFormat> threadLocalTimestampFormat() {
        return this.threadLocalTimestampFormat;
    }

    private ThreadLocal<DateFormat> threadLocalDateFormat() {
        return this.threadLocalDateFormat;
    }

    public int millisToDays(long millisUtc) {
        long millisLocal = millisUtc + (long)this.threadLocalLocalTimeZone().get().getOffset(millisUtc);
        return (int)Math.floor((double)millisLocal / (double)86400000L);
    }

    public long daysToMillis(int days) {
        long millisUtc = (long)days * 86400000L;
        return millisUtc - (long)this.threadLocalLocalTimeZone().get().getOffset(millisUtc);
    }

    public String dateToString(int days) {
        return this.threadLocalDateFormat().get().format(this.toJavaDate(days));
    }

    /*
     * Enabled aggressive block sorting
     */
    public String timestampToString(long us) {
        String string;
        Timestamp ts = this.toJavaTimestamp(us);
        String timestampString = ts.toString();
        String formatted = this.threadLocalTimestampFormat().get().format(ts);
        if (timestampString.length() > 19) {
            String string2 = timestampString.substring(19);
            String string3 = ".0";
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                string = new StringBuilder().append((Object)formatted).append((Object)timestampString.substring(19)).toString();
                return string;
            }
        }
        string = formatted;
        return string;
    }

    public java.util.Date stringToTime(String s) {
        int indexOfGMT;
        while ((indexOfGMT = s.indexOf("GMT")) != -1) {
            String s0 = s.substring(0, indexOfGMT);
            String s1 = s.substring(indexOfGMT + 3);
            s = new StringBuilder().append((Object)s0).append((Object)s1).toString();
        }
        return new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)'T')) ? DatatypeConverter.parseDateTime((String)s).getTime() : (new StringOps(Predef$.MODULE$.augmentString(s)).contains((Object)BoxesRunTime.boxToCharacter((char)' ')) ? Timestamp.valueOf(s) : Date.valueOf(s));
    }

    public int fromJavaDate(Date date) {
        return this.millisToDays(date.getTime());
    }

    public Date toJavaDate(int daysSinceEpoch) {
        return new Date(this.daysToMillis(daysSinceEpoch));
    }

    public Timestamp toJavaTimestamp(long us) {
        long seconds = us / 1000000L;
        long micros = us % 1000000L;
        if (micros < 0L) {
            micros += 1000000L;
            --seconds;
        }
        Timestamp t = new Timestamp(seconds * 1000L);
        t.setNanos((int)micros * 1000);
        return t;
    }

    public long fromJavaTimestamp(Timestamp t) {
        return t == null ? 0L : t.getTime() * 1000L + (long)t.getNanos() / 1000L % 1000L;
    }

    public long fromJulianDay(int day2, long nanoseconds) {
        long seconds = (long)(day2 - 2440588) * 86400L;
        return seconds * 1000000L + nanoseconds / 1000L;
    }

    public Tuple2<Object, Object> toJulianDay(long us) {
        long julian_us = us + 210866803200000000L;
        long day2 = julian_us / 86400000000L;
        long micros = julian_us % 86400000000L;
        return new Tuple2.mcIJ.sp((int)day2, micros * 1000L);
    }

    public Option<Object> stringToTimestamp(UTF8String s) {
        Calendar calendar;
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        None$ timeZone = None$.MODULE$;
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1, 0, 0, 0, 0, 0, 0}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.getBytes();
        int digitsMilli = 0;
        boolean justTime = false;
        for (j = 0; j < bytes.length; ++j) {
            int parsedValue;
            block25: {
                byte b;
                block26: {
                    block30: {
                        block28: {
                            block29: {
                                block27: {
                                    b = bytes[j];
                                    parsedValue = b - (byte)48;
                                    if (parsedValue >= 0 && parsedValue <= 9) break block25;
                                    if (j == 0 && b == 84) {
                                        justTime = true;
                                        i += 3;
                                        continue;
                                    }
                                    if (i < 2) {
                                        if (b == 45) {
                                            if (i == 0 && j != 4) {
                                                return None$.MODULE$;
                                            }
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        if (i == 0 && b == 58) {
                                            justTime = true;
                                            segments[3] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            i = 4;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i == 2) {
                                        if (b == 32 || b == 84) {
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i == 3 || i == 4) {
                                        if (b == 58) {
                                            segments[i] = currentSegmentValue;
                                            currentSegmentValue = 0;
                                            ++i;
                                            continue;
                                        }
                                        return None$.MODULE$;
                                    }
                                    if (i != 5 && i != 6) break block26;
                                    if (b != 90) break block27;
                                    segments[i] = currentSegmentValue;
                                    currentSegmentValue = 0;
                                    ++i;
                                    timeZone = new Some((Object)BoxesRunTime.boxToByte((byte)43));
                                    break block28;
                                }
                                if (b != 45 && b != 43) break block29;
                                segments[i] = currentSegmentValue;
                                currentSegmentValue = 0;
                                ++i;
                                timeZone = new Some((Object)BoxesRunTime.boxToByte((byte)b));
                                break block28;
                            }
                            if (b != 46 || i != 5) break block30;
                            segments[i] = currentSegmentValue;
                            currentSegmentValue = 0;
                            ++i;
                        }
                        if (i != 6 || b == 46) continue;
                        ++i;
                        continue;
                    }
                    return None$.MODULE$;
                }
                if (b == 58 || b == 32) {
                    segments[i] = currentSegmentValue;
                    currentSegmentValue = 0;
                    ++i;
                    continue;
                }
                return None$.MODULE$;
            }
            if (i == 6) {
                ++digitsMilli;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        segments[i] = currentSegmentValue;
        if (!justTime && i == 0 && j != 4) {
            return None$.MODULE$;
        }
        while (digitsMilli < 6) {
            segments[6] = segments[6] * 10;
            ++digitsMilli;
        }
        if (!(justTime || segments[0] >= 0 && segments[0] <= 9999 && segments[1] >= 1 && segments[1] <= 12 && segments[2] >= 1 && segments[2] <= 31)) {
            return None$.MODULE$;
        }
        if (segments[6] > 999999) {
            segments[6] = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(((Object)BoxesRunTime.boxToInteger((int)segments[6])).toString())).take(6))).toInt();
        }
        if (segments[3] < 0 || segments[3] > 23 || segments[4] < 0 || segments[4] > 59 || segments[5] < 0 || segments[5] > 59 || segments[6] < 0 || segments[6] > 999999 || segments[7] < 0 || segments[7] > 23 || segments[8] < 0 || segments[8] > 59) {
            return None$.MODULE$;
        }
        if (timeZone.isEmpty()) {
            calendar = Calendar.getInstance();
        } else {
            Character arg$1 = BoxesRunTime.boxToCharacter((char)((char)BoxesRunTime.unboxToByte((Object)timeZone.get())));
            int arg$2 = segments[7];
            int arg$3 = segments[8];
            calendar = Calendar.getInstance(TimeZone.getTimeZone(new StringOps(Predef$.MODULE$.augmentString("GMT%s%02d:%02d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, BoxesRunTime.boxToInteger((int)arg$2), BoxesRunTime.boxToInteger((int)arg$3)}))));
        }
        Calendar c = calendar;
        c.set(14, 0);
        if (justTime) {
            c.set(11, segments[3]);
            c.set(12, segments[4]);
            c.set(13, segments[5]);
        } else {
            c.set(segments[0], segments[1] - 1, segments[2], segments[3], segments[4], segments[5]);
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)(c.getTimeInMillis() * 1000L + (long)segments[6])));
    }

    public Option<Object> stringToDate(UTF8String s) {
        int j;
        if (s == null) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int i = 0;
        int currentSegmentValue = 0;
        byte[] bytes = s.getBytes();
        for (j = 0; j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84; ++j) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (i == 0 && j != 4) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                ++i;
                continue;
            }
            int parsedValue = b - (byte)48;
            if (parsedValue < 0 || parsedValue > 9) {
                return None$.MODULE$;
            }
            currentSegmentValue = currentSegmentValue * 10 + parsedValue;
        }
        if (i == 0 && j != 4) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        if (segments[0] < 0 || segments[0] > 9999 || segments[1] < 1 || segments[1] > 12 || segments[2] < 1 || segments[2] > 31) {
            return None$.MODULE$;
        }
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.set(segments[0], segments[1] - 1, segments[2], 0, 0, 0);
        c.set(14, 0);
        return new Some((Object)BoxesRunTime.boxToInteger((int)((int)(c.getTimeInMillis() / 86400000L))));
    }

    private long absoluteMicroSecond(long microsec) {
        return microsec + 630160732800000000L;
    }

    private long localTimestamp(long microsec) {
        return this.absoluteMicroSecond(microsec) + (long)this.defaultTimeZone().getOffset(microsec / 1000L) * 1000L;
    }

    public int getHours(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L / 3600L % 24L);
    }

    public int getMinutes(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L / 60L % 60L);
    }

    public int getSeconds(long microsec) {
        return (int)(this.localTimestamp(microsec) / 1000000L % 60L);
    }

    private boolean isLeapYear(int year2) {
        return year2 % 4 == 0 && (year2 % 100 != 0 || year2 % 400 == 0);
    }

    private int yearBoundary(int year2) {
        return year2 * 365 + (year2 / 4 - year2 / 100 + year2 / 400);
    }

    private Tuple2<Object, Object> numYears(int days) {
        int year2 = days / 365;
        int boundary = this.yearBoundary(year2);
        return days > boundary ? new Tuple2.mcII.sp(year2, days - boundary) : new Tuple2.mcII.sp(year2 - 1, days - this.yearBoundary(year2 - 1));
    }

    private Tuple2<Object, Object> getYearAndDayInYear(int daysSince1970) {
        int daysNormalized = daysSince1970 + 7293527;
        int numOfQuarterCenturies = daysNormalized / this.daysIn400Years();
        int daysInThis400 = daysNormalized % this.daysIn400Years() + 1;
        Tuple2<Object, Object> tuple2 = this.numYears(daysInThis400);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int years = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(years, dayInYear);
            int years2 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            int year2 = -17999 + 400 * numOfQuarterCenturies + years2;
            return new Tuple2.mcII.sp(year2, dayInYear2);
        }
        throw new MatchError(tuple2);
    }

    public int getDayInYear(int date) {
        return this.getYearAndDayInYear(date)._2$mcI$sp();
    }

    public int getYear(int date) {
        return this.getYearAndDayInYear(date)._1$mcI$sp();
    }

    public int getQuarter(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year2 = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year2, dayInYear);
            int year3 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year3)) {
                --dayInYear2;
            }
            return dayInYear2 <= 90 ? 1 : (dayInYear2 <= 181 ? 2 : (dayInYear2 <= 273 ? 3 : 4));
        }
        throw new MatchError(tuple2);
    }

    public Tuple4<Object, Object, Object, Object> splitDate(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple4 tuple4;
            Tuple2.mcII.sp sp2;
            int year2 = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year2, dayInYear);
            int year3 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            boolean isLeap = this.isLeapYear(year3);
            if (isLeap && dayInYear2 == 60) {
                tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)29), (Object)BoxesRunTime.boxToInteger((int)0));
            } else {
                if (isLeap && dayInYear2 > 60) {
                    --dayInYear2;
                }
                tuple4 = dayInYear2 <= 181 ? (dayInYear2 <= 31 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)dayInYear2), (Object)BoxesRunTime.boxToInteger((int)(31 - dayInYear2))) : (dayInYear2 <= 59 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 31)), (Object)(isLeap ? BoxesRunTime.boxToInteger((int)(60 - dayInYear2)) : BoxesRunTime.boxToInteger((int)(59 - dayInYear2)))) : (dayInYear2 <= 90 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)3), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 59)), (Object)BoxesRunTime.boxToInteger((int)(90 - dayInYear2))) : (dayInYear2 <= 120 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)4), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 90)), (Object)BoxesRunTime.boxToInteger((int)(120 - dayInYear2))) : (dayInYear2 <= 151 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)5), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 120)), (Object)BoxesRunTime.boxToInteger((int)(151 - dayInYear2))) : new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)6), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 151)), (Object)BoxesRunTime.boxToInteger((int)(181 - dayInYear2)))))))) : (dayInYear2 <= 212 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)7), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 181)), (Object)BoxesRunTime.boxToInteger((int)(212 - dayInYear2))) : (dayInYear2 <= 243 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)8), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 212)), (Object)BoxesRunTime.boxToInteger((int)(243 - dayInYear2))) : (dayInYear2 <= 273 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)9), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 243)), (Object)BoxesRunTime.boxToInteger((int)(273 - dayInYear2))) : (dayInYear2 <= 304 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)10), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 273)), (Object)BoxesRunTime.boxToInteger((int)(304 - dayInYear2))) : (dayInYear2 <= 334 ? new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)11), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 304)), (Object)BoxesRunTime.boxToInteger((int)(334 - dayInYear2))) : new Tuple4((Object)BoxesRunTime.boxToInteger((int)year3), (Object)BoxesRunTime.boxToInteger((int)12), (Object)BoxesRunTime.boxToInteger((int)(dayInYear2 - 334)), (Object)BoxesRunTime.boxToInteger((int)(365 - dayInYear2))))))));
            }
            return tuple4;
        }
        throw new MatchError(tuple2);
    }

    public int getMonth(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year2 = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year2, dayInYear);
            int year3 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year3)) {
                if (dayInYear2 == 60) {
                    return 2;
                }
                if (dayInYear2 > 60) {
                    --dayInYear2;
                }
            }
            return dayInYear2 <= 31 ? 1 : (dayInYear2 <= 59 ? 2 : (dayInYear2 <= 90 ? 3 : (dayInYear2 <= 120 ? 4 : (dayInYear2 <= 151 ? 5 : (dayInYear2 <= 181 ? 6 : (dayInYear2 <= 212 ? 7 : (dayInYear2 <= 243 ? 8 : (dayInYear2 <= 273 ? 9 : (dayInYear2 <= 304 ? 10 : (dayInYear2 <= 334 ? 11 : 12))))))))));
        }
        throw new MatchError(tuple2);
    }

    public int getDayOfMonth(int date) {
        Tuple2<Object, Object> tuple2 = this.getYearAndDayInYear(date);
        if (tuple2 != null) {
            Tuple2.mcII.sp sp2;
            int year2 = tuple2._1$mcI$sp();
            int dayInYear = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(year2, dayInYear);
            int year3 = sp3._1$mcI$sp();
            int dayInYear2 = sp3._2$mcI$sp();
            if (this.isLeapYear(year3)) {
                if (dayInYear2 == 60) {
                    return 29;
                }
                if (dayInYear2 > 60) {
                    --dayInYear2;
                }
            }
            return dayInYear2 <= 31 ? dayInYear2 : (dayInYear2 <= 59 ? dayInYear2 - 31 : (dayInYear2 <= 90 ? dayInYear2 - 59 : (dayInYear2 <= 120 ? dayInYear2 - 90 : (dayInYear2 <= 151 ? dayInYear2 - 120 : (dayInYear2 <= 181 ? dayInYear2 - 151 : (dayInYear2 <= 212 ? dayInYear2 - 181 : (dayInYear2 <= 243 ? dayInYear2 - 212 : (dayInYear2 <= 273 ? dayInYear2 - 243 : (dayInYear2 <= 304 ? dayInYear2 - 273 : (dayInYear2 <= 334 ? dayInYear2 - 304 : dayInYear2 - 334))))))))));
        }
        throw new MatchError(tuple2);
    }

    private int[] monthDays() {
        return this.monthDays;
    }

    private int firstDayOfMonth(int absoluteMonth) {
        int absoluteYear = absoluteMonth / 12;
        int monthInYear = absoluteMonth - absoluteYear * 12;
        int date = this.getDateFromYear(absoluteYear);
        if (monthInYear >= 2 && this.isLeapYear(absoluteYear + -17999)) {
            ++date;
        }
        while (monthInYear > 0) {
            date += this.monthDays()[monthInYear - 1];
            --monthInYear;
        }
        return date;
    }

    private int getDateFromYear(int absoluteYear) {
        int absoluteDays = absoluteYear * 365 + absoluteYear / 400 - absoluteYear / 100 + absoluteYear / 4;
        return absoluteDays - 7293527;
    }

    public int dateAddMonths(int days, int months) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(days);
        if (tuple4 != null) {
            Tuple4 tuple42;
            int year2 = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int monthInYear = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int dayOfMonth = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int daysToMonthEnd = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear), (Object)BoxesRunTime.boxToInteger((int)dayOfMonth), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd));
            int year3 = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int dayOfMonth2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            int absoluteMonth = (year3 - -17999) * 12 + monthInYear2 - 1 + months;
            int nonNegativeMonth = absoluteMonth >= 0 ? absoluteMonth : 0;
            int currentMonthInYear = nonNegativeMonth % 12;
            int currentYear = nonNegativeMonth / 12;
            int leapDay = currentMonthInYear == 1 && this.isLeapYear(currentYear + -17999) ? 1 : 0;
            int lastDayOfMonth = this.monthDays()[currentMonthInYear] + leapDay;
            int currentDayInMonth = daysToMonthEnd2 == 0 || dayOfMonth2 >= lastDayOfMonth ? lastDayOfMonth : dayOfMonth2;
            return this.firstDayOfMonth(nonNegativeMonth) + currentDayInMonth - 1;
        }
        throw new MatchError(tuple4);
    }

    public long timestampAddInterval(long start2, int months, long microseconds) {
        int days = this.millisToDays(start2 / 1000L);
        int newDays = this.dateAddMonths(days, months);
        return this.daysToMillis(newDays) * 1000L + start2 - this.daysToMillis(days) * 1000L + microseconds;
    }

    public double monthsBetween(long time1, long time2) {
        long millis1 = time1 / 1000L;
        long millis2 = time2 / 1000L;
        int date1 = this.millisToDays(millis1);
        int date2 = this.millisToDays(millis2);
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date1);
        if (tuple4 != null) {
            Tuple4 tuple42;
            int year1 = BoxesRunTime.unboxToInt((Object)tuple4._1());
            int monthInYear1 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            int dayInMonth1 = BoxesRunTime.unboxToInt((Object)tuple4._3());
            int daysToMonthEnd1 = BoxesRunTime.unboxToInt((Object)tuple4._4());
            Tuple4 tuple43 = tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year1), (Object)BoxesRunTime.boxToInteger((int)monthInYear1), (Object)BoxesRunTime.boxToInteger((int)dayInMonth1), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd1));
            int year12 = BoxesRunTime.unboxToInt((Object)tuple43._1());
            int monthInYear12 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            int dayInMonth12 = BoxesRunTime.unboxToInt((Object)tuple43._3());
            int daysToMonthEnd12 = BoxesRunTime.unboxToInt((Object)tuple43._4());
            Tuple4<Object, Object, Object, Object> tuple44 = this.splitDate(date2);
            if (tuple44 != null) {
                Tuple4 tuple45;
                int year2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
                int monthInYear2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
                int dayInMonth2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
                int daysToMonthEnd2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
                Tuple4 tuple46 = tuple45 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)year2), (Object)BoxesRunTime.boxToInteger((int)monthInYear2), (Object)BoxesRunTime.boxToInteger((int)dayInMonth2), (Object)BoxesRunTime.boxToInteger((int)daysToMonthEnd2));
                int year22 = BoxesRunTime.unboxToInt((Object)tuple46._1());
                int monthInYear22 = BoxesRunTime.unboxToInt((Object)tuple46._2());
                int dayInMonth22 = BoxesRunTime.unboxToInt((Object)tuple46._3());
                int daysToMonthEnd22 = BoxesRunTime.unboxToInt((Object)tuple46._4());
                int months1 = year12 * 12 + monthInYear12;
                int months2 = year22 * 12 + monthInYear22;
                if (dayInMonth12 == dayInMonth22 || daysToMonthEnd12 == 0 && daysToMonthEnd22 == 0) {
                    return months1 - months2;
                }
                long timeInDay1 = millis1 - this.daysToMillis(date1);
                long timeInDay2 = millis2 - this.daysToMillis(date2);
                double timesBetween = (double)(timeInDay1 - timeInDay2) / (double)86400000L;
                double diff = (double)(months1 - months2) + ((double)(dayInMonth12 - dayInMonth22) + timesBetween) / 31.0;
                return (double)package$.MODULE$.round(diff * 1.0E8) / 1.0E8;
            }
            throw new MatchError(tuple44);
        }
        throw new MatchError(tuple4);
    }

    public int getDayOfWeekFromString(UTF8String string) {
        int n;
        boolean bl;
        String dowString;
        String string2;
        String string3 = string2 = (dowString = string.toString().toUpperCase());
        if (!("SU" != null ? !"SU".equals(string3) : string3 != null)) {
            bl = true;
        } else {
            String string4 = string2;
            if (!("SUN" != null ? !"SUN".equals(string4) : string4 != null)) {
                bl = true;
            } else {
                String string5 = string2;
                bl = !("SUNDAY" != null ? !"SUNDAY".equals(string5) : string5 != null);
            }
        }
        if (bl) {
            n = 3;
        } else {
            boolean bl2;
            String string6 = string2;
            if (!("MO" != null ? !"MO".equals(string6) : string6 != null)) {
                bl2 = true;
            } else {
                String string7 = string2;
                if (!("MON" != null ? !"MON".equals(string7) : string7 != null)) {
                    bl2 = true;
                } else {
                    String string8 = string2;
                    bl2 = !("MONDAY" != null ? !"MONDAY".equals(string8) : string8 != null);
                }
            }
            if (bl2) {
                n = 4;
            } else {
                boolean bl3;
                String string9 = string2;
                if (!("TU" != null ? !"TU".equals(string9) : string9 != null)) {
                    bl3 = true;
                } else {
                    String string10 = string2;
                    if (!("TUE" != null ? !"TUE".equals(string10) : string10 != null)) {
                        bl3 = true;
                    } else {
                        String string11 = string2;
                        bl3 = !("TUESDAY" != null ? !"TUESDAY".equals(string11) : string11 != null);
                    }
                }
                if (bl3) {
                    n = 5;
                } else {
                    boolean bl4;
                    String string12 = string2;
                    if (!("WE" != null ? !"WE".equals(string12) : string12 != null)) {
                        bl4 = true;
                    } else {
                        String string13 = string2;
                        if (!("WED" != null ? !"WED".equals(string13) : string13 != null)) {
                            bl4 = true;
                        } else {
                            String string14 = string2;
                            bl4 = !("WEDNESDAY" != null ? !"WEDNESDAY".equals(string14) : string14 != null);
                        }
                    }
                    if (bl4) {
                        n = 6;
                    } else {
                        boolean bl5;
                        String string15 = string2;
                        if (!("TH" != null ? !"TH".equals(string15) : string15 != null)) {
                            bl5 = true;
                        } else {
                            String string16 = string2;
                            if (!("THU" != null ? !"THU".equals(string16) : string16 != null)) {
                                bl5 = true;
                            } else {
                                String string17 = string2;
                                bl5 = !("THURSDAY" != null ? !"THURSDAY".equals(string17) : string17 != null);
                            }
                        }
                        if (bl5) {
                            n = 0;
                        } else {
                            boolean bl6;
                            String string18 = string2;
                            if (!("FR" != null ? !"FR".equals(string18) : string18 != null)) {
                                bl6 = true;
                            } else {
                                String string19 = string2;
                                if (!("FRI" != null ? !"FRI".equals(string19) : string19 != null)) {
                                    bl6 = true;
                                } else {
                                    String string20 = string2;
                                    bl6 = !("FRIDAY" != null ? !"FRIDAY".equals(string20) : string20 != null);
                                }
                            }
                            if (bl6) {
                                n = 1;
                            } else {
                                boolean bl7;
                                String string21 = string2;
                                if (!("SA" != null ? !"SA".equals(string21) : string21 != null)) {
                                    bl7 = true;
                                } else {
                                    String string22 = string2;
                                    if (!("SAT" != null ? !"SAT".equals(string22) : string22 != null)) {
                                        bl7 = true;
                                    } else {
                                        String string23 = string2;
                                        bl7 = !("SATURDAY" != null ? !"SATURDAY".equals(string23) : string23 != null);
                                    }
                                }
                                n = bl7 ? 2 : -1;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    public int getNextDateForDayOfWeek(int startDate, int dayOfWeek) {
        return startDate + 1 + ((dayOfWeek - 1 - startDate) % 7 + 7) % 7;
    }

    public int getLastDayOfMonth(int date) {
        Tuple4<Object, Object, Object, Object> tuple4 = this.splitDate(date);
        if (tuple4 != null) {
            int daysToMonthEnd;
            int n;
            int daysToMonthEnd2 = n = (daysToMonthEnd = BoxesRunTime.unboxToInt((Object)tuple4._4()));
            return date + daysToMonthEnd2;
        }
        throw new MatchError(tuple4);
    }

    private int TRUNC_TO_YEAR() {
        return this.TRUNC_TO_YEAR;
    }

    private int TRUNC_TO_MONTH() {
        return this.TRUNC_TO_MONTH;
    }

    private int TRUNC_INVALID() {
        return this.TRUNC_INVALID;
    }

    public int truncDate(int d, int level) {
        block4: {
            int n;
            block3: {
                block2: {
                    if (level != this.TRUNC_TO_YEAR()) break block2;
                    n = d - this.getDayInYear(d) + 1;
                    break block3;
                }
                if (level != this.TRUNC_TO_MONTH()) break block4;
                n = d - this.getDayOfMonth(d) + 1;
            }
            return n;
        }
        throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid trunc level: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)level)})));
    }

    public int parseTruncLevel(UTF8String format) {
        int n;
        if (format == null) {
            n = this.TRUNC_INVALID();
        } else {
            int n2;
            boolean bl;
            String string;
            String string2 = string = format.toString().toUpperCase();
            if (!("YEAR" != null ? !"YEAR".equals(string2) : string2 != null)) {
                bl = true;
            } else {
                String string3 = string;
                if (!("YYYY" != null ? !"YYYY".equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = string;
                    bl = !("YY" != null ? !"YY".equals(string4) : string4 != null);
                }
            }
            if (bl) {
                n2 = this.TRUNC_TO_YEAR();
            } else {
                boolean bl2;
                String string5 = string;
                if (!("MON" != null ? !"MON".equals(string5) : string5 != null)) {
                    bl2 = true;
                } else {
                    String string6 = string;
                    if (!("MONTH" != null ? !"MONTH".equals(string6) : string6 != null)) {
                        bl2 = true;
                    } else {
                        String string7 = string;
                        bl2 = !("MM" != null ? !"MM".equals(string7) : string7 != null);
                    }
                }
                n2 = bl2 ? this.TRUNC_TO_MONTH() : this.TRUNC_INVALID();
            }
            n = n2;
        }
        return n;
    }

    public long fromUTCTime(long time, String timeZone) {
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        int offset = tz.getOffset(time / 1000L);
        return time + (long)offset * 1000L;
    }

    public long toUTCTime(long time, String timeZone) {
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        int offset = tz.getOffset(time / 1000L);
        return time - (long)offset * 1000L;
    }

    private DateTimeUtils$() {
        MODULE$ = this;
        this.daysIn400Years = 146097;
        this.threadLocalLocalTimeZone = new anon.1();
        this.threadLocalTimestampFormat = new anon.2();
        this.threadLocalDateFormat = new anon.3();
        this.monthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        this.TRUNC_TO_YEAR = 1;
        this.TRUNC_TO_MONTH = 2;
        this.TRUNC_INVALID = -1;
    }
}

